<?php
include '../includes/conn.php';
if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  echo '<div class="alert alert-danger">Invalid class/subject id</div>';
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add Mid Term Plan</title>
  <script src="<?php echo BASE_URL; ?>/ckeditor/ckeditor.js"></script>
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/ckeditor/samples/sample.css">

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->

</head>

<body class="sticky-header">
  <section>
    <?php include 'nav.php';
    //   echo str_replace('\', ' ',$organisation);
    ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">
        <div class="col-lg-11">
          <?php
          if (isset($_POST['submit'])) {
            $month = isset($_POST['month']) ? (int)$_POST['month'] : 0;

            $term = isset($_POST['term']) ? (int)$_POST['term'] : 0;
            // $week = $_POST['week'];
            // $title = $_POST['title'];
            // $summary = $_POST['summary'];
            // $plenary = $_POST['plenary'];
            // $periodsperweek = $_POST['periodsperweek'];
            // $additional_activity = $_POST['additional_activity'];

            if ($month <= 0 || $term <= 0) {
              echo '<div class="alert alert-danger">Oops!! Some Fields Are Empty</div>';
            } else {
              $upload_dir = __DIR__ . "/../uploads/midterm_plans/";
              if (!file_exists($upload_dir)) {
                mkdir($upload_dir, 0777, true);
              }

              if (!empty($_FILES['midterm_plan']) && is_array($_FILES['midterm_plan']['name'])) {
                $files = $_FILES['midterm_plan'];
                $file_count = count($files['name']);

                // prepare insert
                $stmt = mysqli_prepare($con, "INSERT INTO midterm_plans (class_sub_id, teacher_id, month, term, file_path, timestamp, status) VALUES(?,?,?,?,?,? ,1)");
                if (!$stmt) {
                  $err = mysqli_error($con);
                  error_log('addmidtermplan: prepare failed: ' . $err);
                  if (isset($_SESSION['schoolsyslevel']) && (int)$_SESSION['schoolsyslevel'] === 1) {
                    echo '<div class="alert alert-danger">DB prepare error: ' . htmlspecialchars($err, ENT_QUOTES) . '</div>';
                  } else {
                    echo '<div class="alert alert-danger">Database error (prepare failed)</div>';
                  }
                }

                for ($i = 0; $i < $file_count; $i++) {
                  if ($files['error'][$i] === UPLOAD_ERR_OK) {
                    $file_name = $files['name'][$i];
                    $file_tmp = $files['tmp_name'][$i];
                    $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

                    if ($file_ext !== 'pdf') {
                      echo '<div class="alert alert-danger">Only PDF files are allowed!</div>';
                      continue;
                    }

                    $new_filename = time() . '_' . bin2hex(random_bytes(6)) . '.' . $file_ext;
                    $file_path = $upload_dir . $new_filename;

                    // basic size check (10MB)
                    $file_size = $files['size'][$i] ?? 0;
                    if ($file_size > 10 * 1024 * 1024) {
                      echo '<div class="alert alert-danger">File too large; max 10MB</div>';
                      continue;
                    }

                    if (move_uploaded_file($file_tmp, $file_path)) {
                      $db_path = 'uploads/midterm_plans/' . $new_filename;
                      if ($stmt) {
                        $teacher_id = isset($_SESSION['teachersys']) ? (int)$_SESSION['teachersys'] : 0;
                        $timestamp = $timenow ?? date('Y-m-d H:i:s');
                        // correct types: class_sub_id:int, teacher_id:int, month:int, term:int, file_path:string, timestamp:string
                        if (!mysqli_stmt_bind_param($stmt, 'iiiiss', $id, $teacher_id, $month, $term, $db_path, $timestamp)) {
                          $bErr = mysqli_stmt_error($stmt);
                          error_log('addmidtermplan: bind_param failed: ' . $bErr);
                          if (isset($_SESSION['schoolsyslevel']) && (int)$_SESSION['schoolsyslevel'] === 1) echo '<div class="alert alert-danger">Bind error: ' . htmlspecialchars($bErr, ENT_QUOTES) . '</div>';
                        }
                        $exec = mysqli_stmt_execute($stmt);
                        if ($exec === false) {
                          if (isset($_SESSION['schoolsyslevel']) && (int)$_SESSION['schoolsyslevel'] === 1) {
                            echo '<div class="alert alert-danger">DB error: ' . htmlspecialchars(mysqli_stmt_error($stmt), ENT_QUOTES) . '</div>';
                          } else {
                            echo '<div class="alert alert-danger">Error saving plan to database</div>';
                          }
                        }
                        mysqli_stmt_reset($stmt);
                      }
                    } else {
                      $uploadErr = isset($files['error'][$i]) ? (int)$files['error'][$i] : -1;
                      error_log('addmidtermplan: move_uploaded_file failed, tmp=' . var_export($file_tmp, true) . ' target=' . $file_path . ' error=' . $uploadErr);
                      echo '<div class="alert alert-danger">Error uploading file! upload error code: ' . htmlspecialchars($uploadErr) . '</div>';
                    }
                  }
                }

                if (isset($stmt) && $stmt) mysqli_stmt_close($stmt);
                echo '<div class="alert alert-success">Mid-term Plan(s) successfully Added</div>';
              }
            }
          }
          ?>
          <form method="post" name='form' class="form" action="" enctype="multipart/form-data">
            <section class="panel">
              <header class="panel-heading">
                Add Midterm Plan
              </header>
              <div class="panel-body">

                <div class="row">
                  <div class="form-group col-lg-4">
                    <label class="control-label">Select Month</label>
                    <select name="month" class="form-control" required>
                      <option value="1">Jan</option>
                      <option value="2">Feb</option>
                      <option value="3">Mar</option>
                      <option value="4">Apr</option>
                      <option value="5">May</option>
                      <option value="6">Jun</option>
                      <option value="7">Jul</option>
                      <option value="8">Aug</option>
                      <option value="9">Sep</option>
                      <option value="10">Oct</option>
                      <option value="11">Nov</option>
                      <option value="12">Dec</option>
                    </select>
                  </div>
                  <div class="form-group col-lg-4">
                    <label class="control-label">Select Term</label>
                    <select name="term" class="form-control">

                      <?php
                      $terms = mysqli_query($con, "SELECT financialterm_id,term,year FROM financialterms WHERE status=1");
                      if ($terms) {
                        while ($row = mysqli_fetch_assoc($terms)) {
                          $financialterm_id = (int)($row['financialterm_id'] ?? 0);
                          $termName = $row['term'] ?? '';
                          $year = $row['year'] ?? '';
                      ?>
                        <option value="<?php echo $financialterm_id; ?>"><?php echo htmlspecialchars('Term ' . $termName . ' ' . $year); ?></option>
                      <?php }
                      }
                      ?>
                    </select>

                  </div>
                </div>
                <div class="pharmacy-sec">
                  <div class="row">
                    <!-- <div class="form-group col-lg-2">
                    <label class="control-label">Select Week</label>
                    <select name="week[]" class="form-control" required>

                      <?php
                      // $terms =  mysqli_query($con, "SELECT  * FROM weeks WHERE status=1");
                      // while ($row =  mysqli_fetch_array($terms)) {
                      //   $financialterm_id = $row['week_id'];
                      //   $term = $row['week'];

                      ?>
                        <option value="<?php echo $financialterm_id; ?>"><?php echo $term; ?></option>
                      <?php
                      // } 
                      ?>
                    </select>

                  </div>
                  <div class="form-group col-lg-5">
                    <label class="control-label">Title</label>
                    <textarea class="form-control" id="editor1" name="title[]" rows="8" columns='4' required></textarea>
                  </div>
                  <div class="form-group col-lg-5">
                    <label class="control-label">Summary</label>
                    <textarea class="form-control" id="editor2" name="summary[]" rows="8" columns='4' required></textarea>
                  </div> -->
                    <div class="form-group col-lg-11">
                      <label class="control-label">Upload Midterm Plan (PDF)</label>
                      <input type="file" name="midterm_plan[]" class="form-control" accept=".pdf" required>
                      <small class="text-muted">Please upload a PDF file containing your midterm plan</small>
                    </div>
                  </div>


                </div>
              </div>
              <div class="form-group">
                <button class="drug_button btn btn-info btn-xs">Add more</button>
              </div>
            </section>



            <div class="form-group col-lg-12">
              <button class="btn btn-primary" type="submit" name="submit">Add Plan</button>
            </div>

          </form>
        </div>
    </section>

    </div>

    </div>


    </div>
    <!-- page end-->
  </section>

  </div>
  <!-- main content end-->
  </section>

  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
  <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>

  <script>
    $('#data_5 .input-daterange').datepicker({
      keyboardNavigation: false,
      forceParse: false,
      autoclose: true
    });
  </script>
  <script>
    $('.drug_button').click(function(e) { //on add input button click
      e.preventDefault();
      $(document).ready(function() {

        // $('.pharmacy-sec').append(`
        //     <div class="form-group col-lg-2">
        //                 <label class="control-label">Select Week</label>
        //                 <select name="week[]" class="form-control" required>

        //                 <?php
        //                 $terms =  mysqli_query($con, "SELECT  * FROM weeks WHERE status=1");
        //                 while ($row =  mysqli_fetch_array($terms)) {
        //                     $financialterm_id = $row['week_id'];
        //                     $term = $row['week'];
                            
        //                 ?>
        //                     <option value="<?php echo $financialterm_id; ?>"><?php echo $term; ?></option>
        //                 <?php 
      // } ?>
        //                 </select> 

        //              </div>
        //             <div class="form-group col-lg-5">
        //               <label class="control-label">Title</label>
        //               <textarea class="form-control" id="editor1" name="title[]" rows="8" columns='4' required></textarea>
        //             </div>
        //             <div class="form-group col-lg-5">
        //               <label class="control-label">Summary</label>
        //               <textarea class="form-control" id="editor2" name="summary[]" rows="8" columns='4' required></textarea>
        //             </div>
        // `);
        $('.pharmacy-sec').append(`
          <div class="row">
            <div class="col-lg-12">
              <strong style="font-size:14px;color:#000">ADD MIDTERM PLAN</strong>
            </div>
            <div class="form-group col-lg-11">
              <label class="control-label">Upload Midterm Plan (PDF)</label>
              <input type="file" name="midterm_plan[]" class="form-control" accept=".pdf" required>
              <small class="text-muted">Please upload a PDF file containing your midterm plan</small>
            </div>
            <button class="remove_drug btn btn-danger btn-sm" style="margin-top:20px">
              <i class="fa fa-minus"></i>
            </button>
          </div>
        `);
      });
      $('.pharmacy-sec').on("click", ".remove_drug", function(e) { //user click on remove text
        e.preventDefault();
        $(this).parent('div').remove();
      //   x--;
      // });
      // $('#data_2 .input-group.date').datepicker({
      //   todayBtn: "linked",
      //   keyboardNavigation: false,
      //   forceParse: false,
      //   calendarWeeks: true,
      //   autoclose: true
      });
    });
    $('#data_1 .input-group.date').datepicker({
      todayBtn: "linked",
      keyboardNavigation: false,
      forceParse: false,
      calendarWeeks: true,
      autoclose: true
    });
  </script>

</body>

</html>