<?php
include '../includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

$cl = isset($_GET['cl']) ? (int)$_GET['cl'] : 0;
$as = isset($_GET['as']) ? (int)$_GET['as'] : 0;
$sub = isset($_GET['sub']) ? (int)$_GET['sub'] : 0;
$tm = isset($_GET['tm']) ? (int)$_GET['tm'] : 0;
$dt = $_GET['dt'] ?? '';
$rk = isset($_GET['rk']) ? (int)$_GET['rk'] : 0;
$paper = isset($_GET['paper']) ? (int)$_GET['paper'] : 0;

if ($cl <= 0 || $as <= 0 || $sub <= 0 || $tm <= 0) {
  echo '<div class="alert alert-danger">Invalid parameters</div>';
  exit;
}

// normalize date for display and db matching
$dt_display = '';
if (is_numeric($dt) && ((int)$dt) > 0) {
  $dt_display = date('d/M/Y', (int)$dt);
  $dt_db = (string)((int)$dt);
} else {
  $ts = strtotime((string)$dt);
  if ($ts !== false) {
    $dt_display = date('d/M/Y', $ts);
    $dt_db = date('Y-m-d', $ts);
  } else {
    $dt_display = htmlspecialchars((string)$dt);
    $dt_db = htmlspecialchars((string)$dt);
  }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Add Marks-School Manager</title>
   <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
 <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
        <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->
     
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                     Add assesment Results
                    </header>
                          <div class="panel-body">  
                        
                                <?php
                                $getclasses = mysqli_query($con, "SELECT class,category_id FROM classes WHERE class_id=" . $cl . " LIMIT 1");
                                       $class2 = '';
                                       $category_id2 = 0;
                                       if ($getclasses) {
                                           $row2 = mysqli_fetch_assoc($getclasses);
                                           $class2 = $row2['class'] ?? '';
                                           $category_id2 = (int)($row2['category_id'] ?? 0);
                                       }
                                        $getsubjects = mysqli_query($con, "SELECT subject FROM subjects WHERE subject_id=" . $sub . " LIMIT 1");
                                       $subject2 = '';
                                       if ($getsubjects) {
                                           $row3 = mysqli_fetch_assoc($getsubjects);
                                           $subject2 = $row3['subject'] ?? '';
                                       }
                                       $getterm = mysqli_query($con, "SELECT term,year FROM financialterms WHERE financialterm_id=" . $tm . " LIMIT 1");
  $term2 = '';
  $year = '';
  if ($getterm) {
    $row4 = mysqli_fetch_assoc($getterm);
    $term2 = $row4['term'] ?? '';
    $year = $row4['year'] ?? '';
  }
  if ($paper != 0) {
    $single_paper = mysqli_query($con, "SELECT paper_name FROM papers WHERE paper_id=" . $paper . " LIMIT 1");
    if ($single_paper) {
      $row_single_paper = mysqli_fetch_assoc($single_paper);
      $paper_name = $row_single_paper['paper_name'] ?? '';
    }
  }
  $gettypes = mysqli_query($con, "SELECT assessmenttype FROM assessmenttypes WHERE assessmenttype_id=" . $as . " LIMIT 1");
  $assessment = '';
  if ($gettypes) {
    $rowt = mysqli_fetch_assoc($gettypes);
    $assessment = $rowt['assessmenttype'] ?? '';
  }
                                ?>
                                    <table  class="display table  table-striped" id="dynamic-table">
     
        <tbody>
         
                <tr class="gradeA">
                       <th>Assessment</th>
                       <td><?php echo $assessment;?></td>
                  </tr>
                 <tr class="gradeA">
                       <th>Class</th>
                       <td><?php echo $class2;?></td>
                  </tr>
                       <tr class="gradeA">
                             <th>Subject</th>
            <td><?php echo $subject2; ?></td>
            </tr>
            <tr class="gradeA">
              <?php if ($paper != 0){ ?>
                             <th>Paper</th>
            <td><?php echo $paper_name; ?></td>
            </tr>
            <?php } ?>
                           <tr class="gradeA">
                             <th> Term</th>
                             <td><?php echo $term2.' '.$year;?></td>
            </tr>
              <tr class="gradeA">
                               <th> Date</th>
                               <td><?php echo htmlspecialchars($dt_display); ?></td>
              </tr>
         <tr class="gradeA">
               <th>Rank</th>
               <td><?php 
                $rank = '';
                $getranks = mysqli_query($con, "SELECT rank FROM ranks WHERE status=1 AND rank_id=" . $rk . " LIMIT 1");
                if ($getranks) {
                  $row = mysqli_fetch_assoc($getranks);
                  $rank = $row['rank'] ?? '';
                }
               echo htmlspecialchars($rank);?></td>
      </tr>
                   </tbody>
                        </table>
                              
                        </div>
                      </section>
                        </div>
                <div class="col-lg-8">
                   <section class="panel">
                    <header class="panel-heading">
                     Add Assesment Results
                    </header>
                          <div class="panel-body">  
  <?php
                // Check if marks already exist for this assessment/date combination
                // Allow multiple continuous assessments (assessment id 1). For other assessment types, keep the uniqueness check.
                $already = false;
                if ($as != 1) {
                  $check_stmt = mysqli_prepare($con, "SELECT mark_id FROM marks WHERE assessment = ? AND term_id = ? AND subject_id = ? AND class_id = ? AND date = ?");
                  if ($check_stmt) {
                    mysqli_stmt_bind_param($check_stmt, 'iiiis', $as, $tm, $sub, $cl, $dt_db);
                    mysqli_stmt_execute($check_stmt);
                    mysqli_stmt_store_result($check_stmt);
                    if (mysqli_stmt_num_rows($check_stmt) > 0) {
                      $already = true;
                    }
                    mysqli_stmt_close($check_stmt);
                  }
                }

                if ($already) {
                  echo '<div class="alert alert-danger">Assessment results already exist for this class, subject, and date. To record new results, please use a different date.</div>';
                } else {
                  // Insert new assessment results
                  if (isset($_POST['mark'], $_POST['student']) && is_array($_POST['mark']) && is_array($_POST['student'])) {
                    $stdmark = $_POST['mark'];
                    $student = $_POST['student'];
                    if ($paper == 0) {
                      $paper = 1; // fallback to paper 1
                    }
                    $allstudents = count($student);

                    // Get the actual rank value (out of) instead of rank_id
                    $rank_value = '';
                    if ($rk > 0) {
                      $rank_query = mysqli_query($con, "SELECT rank FROM ranks WHERE status=1 AND rank_id=" . $rk . " LIMIT 1");
                      if ($rank_query && $rank_row = mysqli_fetch_assoc($rank_query)) {
                        $rank_value = $rank_row['rank'] ?? '';
                      }
                    }

                    // prepare insert statement
                    $ins = mysqli_prepare($con, "INSERT INTO marks(marks,rank,subject_id,paper_id,class_id,assessment,student_id,term_id,date,status) VALUES(?,?,?,?,?,?,?,?,?,1)");

                    $added = 0;
                    $errors = [];
                    $rank_numeric = is_numeric($rank_value) ? (float)$rank_value : 0;

                    if ($ins) {
                      // bind insert params by reference variables
                      $mark_val = 0.0;
                      $student_id = 0;
                      mysqli_stmt_bind_param($ins, 'dsiiiiiis', $mark_val, $rank_value, $sub, $paper, $cl, $as, $student_id, $tm, $dt_db);
                      
                      for ($x = 0; $x < $allstudents; $x++) {
                        $mark_val = is_numeric($stdmark[$x]) ? (float)$stdmark[$x] : 0.0;
                        $student_id = (int)$student[$x];

                        // Validate: mark should not exceed rank
                        if ($rank_numeric > 0 && $mark_val > $rank_numeric) {
                          $errors[] = "Student ID $student_id: Mark ($mark_val) exceeds rank ($rank_numeric)";
                          continue; // Skip this student
                        }

                        // Insert new mark
                        if (mysqli_stmt_execute($ins)) {
                          $added++;
                        }
                      }
                      
                      mysqli_stmt_close($ins);
                    } else {
                      echo '<div class="alert alert-danger">Unable to prepare statement for saving marks.</div>';
                    }

                    if (!empty($errors)) {
                      echo '<div class="alert alert-warning"><strong>Validation Errors:</strong><ul>';
                      foreach ($errors as $err) {
                        echo '<li>' . htmlspecialchars($err) . '</li>';
                      }
                      echo '</ul></div>';
                    }

                    if ($added > 0) {
                      echo '<div class="alert alert-success">Marks successfully added: ' . $added . ' students.</div>';
                    } elseif (empty($errors)) {
                      echo '<div class="alert alert-info">No marks were saved.</div>';
                    }
                  }
                }
      ?>
      <table  class="display table" id="dynamic-table">
                                            <tr>
                                                <th>Student Name</th>
                                                <th>Mark</th>
                                                <th>Not in My Class</th>
                                            </tr>
 <form method="POST" name='form' class="form-horizontal" action=""  enctype="multipart/form-data">
                              <?php
                                     $getstudents=  mysqli_query($con,"SELECT * FROM students WHERE class_id='$cl'");
                                while ($row = mysqli_fetch_array($getstudents)) {
                                              $student_id=$row['student_id'];
                                              $fullname=$row['fullname'];       
                                                                                
                                      ?>
                                      
                                        <tbody class="table table-striped table-advance table-hover">
                                            
                                            <tr>
                                                <td><?php echo $fullname; ?></td>
                                                <td>
                                                <div class="col-sm-8">                                      
                                        <input type="number" name="student[]" value="<?php echo $student_id; ?>" style="display:none">
                                        <input type="text" class="form-control" name="mark[]" id="mark<?php echo $student_id; ?>" step="0.01">
                                                                        </div></td>
                                                <td>
                                                <div class="form-group">
                                <input type="checkbox" class="attend" data-id="<?php echo $student_id; ?>" id="attend<?php echo $student_id; ?>"  name="attendance[]" value="<?php echo $student_id; ?>">
                                </div>
                                                  </td>
                                            </tr>
                                        </tbody>
                         
                <!-- <div class="form-group"><label class="col-sm-4 control-label">*<?php echo $fullname; ?></label>

                                   
                                </div> -->
                               
           <?php
        } // end while
?>
                                                
                        </table>

                            <!-- <div class="hr-line-dashed"></div> -->
                            
                                                                                                  
                <div class="form-group col-lg-12">
                                                                      
                    <button class="btn btn-primary" type="submit">Submit Marks</button>
                                </div>
              </form>
                         </div>
                   </section>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
        <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
<script>
  // function to toggle student marks if not in class
  function toggleStudent(student_id) {
    var mark = document.getElementById('mark' + student_id);
    var attend = document.getElementById('attend' + student_id);
    if (attend.checked) {
      mark.style.display = 'none';
      // pass N/A to the input field
      mark.value = 'N/A';
    } else {
      mark.style.display = 'block';
      // clear the input field
      mark.value = '';
    }
  }

  $(document).on('click','.attend',function(){
    var student_id = $(this).attr('data-id');
    console.log(student_id)
    toggleStudent(student_id);
  }
  );
  </script>

  
</body>

</html>
 