<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$sub = isset($_GET['sub']) ? (int)$_GET['sub'] : 0;
$cl = isset($_GET['cl']) ? (int)$_GET['cl'] : 0;
if ($id <= 0 || $sub <= 0 || $cl <= 0) {
  echo '<div class="alert alert-danger">Invalid parameters</div>';
  exit;
}

$getclasses = mysqli_query($con, "SELECT class,category_id FROM classes WHERE class_id=" . $cl . " LIMIT 1");
$class = '';
$category_id = 0;
if ($getclasses) {
  $row2 = mysqli_fetch_assoc($getclasses);
  $class = $row2['class'] ?? '';
  $category_id = (int)($row2['category_id'] ?? 0);
}

$getsubjects = mysqli_query($con, "SELECT subject FROM subjects WHERE subject_id=" . $sub . " LIMIT 1");
$subject = '';
if ($getsubjects) {
  $row3 = mysqli_fetch_assoc($getsubjects);
  $subject = $row3['subject'] ?? '';
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add Long Term Plan</title>
  <script src="<?php echo BASE_URL; ?>/ckeditor/ckeditor.js"></script>
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/ckeditor/samples/sample.css">

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->

</head>

<body class="sticky-header">
  <section>
    <?php include 'nav.php';
    //   echo str_replace('\', ' ',$organisation);
    ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">
        <div class="col-lg-11">
          <?php
          if (isset($_POST['submit'])) {
            $month = $_POST['month'] ?? [];
            $term = isset($_POST['term']) ? (int)$_POST['term'] : 0;
            if (empty($month) || $term <= 0) {
              echo '<div class="alert alert-danger">Oops!! Some Fields Are Empty</div>';
            } else {
              // Create upload directory if it doesn't exist
              $upload_dir = __DIR__ . "/../uploads/longterm_plans/";
              if (!file_exists($upload_dir)) {
                mkdir($upload_dir, 0777, true);
              }

              if (!empty($_FILES['longterm_plan']) && is_array($_FILES['longterm_plan']['name'])) {
                $files = $_FILES['longterm_plan'];
                $file_count = count($files['name']);

                // prepare insert statement
                $stmt = mysqli_prepare($con, "INSERT INTO longterm_plans (class_sub_id, teacher_id, term, file_path, timestamp, status) VALUES(?,?,?,?,?,1)");
                if (!$stmt) {
                  $err = mysqli_error($con);
                  error_log('addlongtermplan: prepare failed: ' . $err);
                  echo '<div class="alert alert-danger">Database prepare error</div>';
                }

                for ($i = 0; $i < $file_count; $i++) {
                  if ($files['error'][$i] === UPLOAD_ERR_OK) {
                    $file_name = $files['name'][$i];
                    $file_tmp = $files['tmp_name'][$i];
                    $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

                    if ($file_ext !== 'pdf') {
                      echo '<div class="alert alert-danger">Only PDF files are allowed!</div>';
                      continue;
                    }

                    // create a safe unique filename
                    $new_filename = time() . '_' . bin2hex(random_bytes(6)) . '.' . $file_ext;
                    $file_path = $upload_dir . $new_filename;

                    if (move_uploaded_file($file_tmp, $file_path)) {
                      // store relative path in DB
                      $db_path = 'uploads/longterm_plans/' . $new_filename;
                      if ($stmt) {
                        $teacher_id = isset($_SESSION['teachersys']) ? (int)$_SESSION['teachersys'] : 0;
                        $timestamp = $timenow ?? date('Y-m-d H:i:s');
                        if (!mysqli_stmt_bind_param($stmt, 'iiiss', $id, $teacher_id, $term, $db_path, $timestamp)) {
                          $bErr = mysqli_stmt_error($stmt);
                          error_log('addlongtermplan: bind_param failed: ' . $bErr);
                          echo '<div class="alert alert-danger">Bind error: ' . htmlspecialchars($bErr, ENT_QUOTES) . '</div>';
                        }
                        $exec = mysqli_stmt_execute($stmt);
                        if ($exec === false) {
                          error_log('addlongtermplan: execute failed: ' . mysqli_stmt_error($stmt));
                          echo '<div class="alert alert-danger">DB execute error</div>';
                        }
                        mysqli_stmt_reset($stmt);
                      }
                    } else {
                      $uploadErr = isset($files['error'][$i]) ? (int)$files['error'][$i] : -1;
                      error_log('addlongtermplan: move_uploaded_file failed, tmp=' . var_export($file_tmp, true) . ' target=' . $file_path . ' error=' . $uploadErr);
                      echo '<div class="alert alert-danger">Error uploading file! upload error code: ' . htmlspecialchars($uploadErr) . '</div>';
                    }
                  }
                }

                if (isset($stmt) && is_resource($stmt) === false) {
                  // if stmt was prepared, close it
                  @mysqli_stmt_close($stmt);
                } elseif (isset($stmt)) {
                  mysqli_stmt_close($stmt);
                }

                echo '<div class="alert alert-success">Long-term Plan(s) successfully Added</div>';
              }
            }
          }

          ?>
          <form method="post" name='form' class="form" action="" enctype="multipart/form-data">
            <section class="panel">
              <header class="panel-heading">
                Add <?php echo htmlspecialchars($subject . ' : ' . $class); ?> Long Term Lesson Plan
              </header>
              <div class="panel-body">

                <div class="row">
                  <!-- <div class="form-group col-lg-4" >
                  <label class="control-label">Select Month</label>
                    <select name="month" class="form-control" required>
                        <option value="1">Jan</option>
                        <option value="2">Feb</option>
                        <option value="3">Mar</option>
                        <option value="4">Apr</option>
                        <option value="5">May</option>
                        <option value="6">Jun</option>
                        <option value="7">Jul</option>
                        <option value="8">Aug</option>
                        <option value="9">Sep</option>
                        <option value="10">Oct</option>
                        <option value="11">Nov</option>
                        <option value="12">Dec</option>
                    </select>
                  </div> -->
                  <div class="form-group col-lg-12">
                    <label class="control-label">Select Term</label>
                    <select name="term" class="form-control">

                      <?php
                      $terms = mysqli_query($con, "SELECT financialterm_id,term,year FROM financialterms WHERE status=1");
                      if ($terms) {
                        while ($row = mysqli_fetch_assoc($terms)) {
                          $financialterm_id = (int)($row['financialterm_id'] ?? 0);
                          $termName = $row['term'] ?? '';
                          $year = $row['year'] ?? '';
                      ?>
                        <option value="<?php echo $financialterm_id; ?>"><?php echo htmlspecialchars('Term ' . $termName . ' ' . $year); ?></option>
                      <?php }
                      }
                      ?>
                    </select>

                  </div>
                </div>
                <div class="pharmacy-sec">
                  <div class="row">
                    <div class="form-group col-lg-2">
                      <label class="control-label">Select Month</label>
                      <select name="month[]" class="form-control" required>
                        <option value="1">Jan</option>
                        <option value="2">Feb</option>
                        <option value="3">Mar</option>
                        <option value="4">Apr</option>
                        <option value="5">May</option>
                        <option value="6">Jun</option>
                        <option value="7">Jul</option>
                        <option value="8">Aug</option>
                        <option value="9">Sep</option>
                        <option value="10">Oct</option>
                        <option value="11">Nov</option>
                        <option value="12">Dec</option>
                      </select>

                    </div>
                    <!-- <div class="form-group col-lg-5">
                      <label class="control-label">Title</label>
                      <textarea class="form-control" id="editor1" name="title[]" rows="8" columns='4' required></textarea>
                    </div>
                    <div class="form-group col-lg-5">
                      <label class="control-label">Summary</label>
                      <textarea class="form-control" id="editor2" name="summary[]" rows="8" columns='4' required></textarea>
                    </div> -->
                    <div class="form-group col-lg-11">
                      <label class="control-label">Upload Long Term Plan (PDF)</label>
                      <input type="file" name="longterm_plan[]" class="form-control" accept=".pdf" required>
                      <small class="text-muted">Please upload a PDF file containing your long term plan</small>
                    </div>
                  </div>
                </div>
              </div>
              <!-- <div class="form-group">
                <button class="drug_button btn btn-info btn-xs">Add more</button>
              </div> -->
            </section>



            <div class="form-group col-lg-12">
              <button class="btn btn-primary" type="submit" name="submit">Add Plan</button>
            </div>

          </form>
        </div>
    </section>

    </div>

    </div>


    </div>
    <!-- page end-->
  </section>

  </div>
  <!-- main content end-->
  </section>

  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
  <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>

  <script>
    $('#data_5 .input-daterange').datepicker({
      keyboardNavigation: false,
      forceParse: false,
      autoclose: true
    });
  </script>
  <script>
    $('.drug_button').click(function(e) { //on add input button click
      e.preventDefault();
      $(document).ready(function() {
        $('.pharmacy-sec').append(`
            <div class="form-group col-lg-2">
                        <label class="control-label">Select Month</label>
                        <select name="month[]" class="form-control" required>
                        <option value="1">Jan</option>
                        <option value="2">Feb</option>
                        <option value="3">Mar</option>
                        <option value="4">Apr</option>
                        <option value="5">May</option>
                        <option value="6">Jun</option>
                        <option value="7">Jul</option>
                        <option value="8">Aug</option>
                        <option value="9">Sep</option>
                        <option value="10">Oct</option>
                        <option value="11">Nov</option>
                        <option value="12">Dec</option>
                        </select> 

                     </div>
                    <div class="form-group col-lg-5">
                      <label class="control-label">Title</label>
                      <textarea class="form-control" id="editor1" name="title[]" rows="8" columns='4' required></textarea>
                    </div>
                    <div class="form-group col-lg-5">
                      <label class="control-label">Summary</label>
                      <textarea class="form-control" id="editor2" name="summary[]" rows="8" columns='4' required></textarea>
                    </div>
        `);
      });
      $('.pharmacy-sec').on("click", ".remove_drug", function(e) { //user click on remove text
        e.preventDefault();
        $(this).parent('div').remove();
        x--;
      });
      $('#data_2 .input-group.date').datepicker({
        todayBtn: "linked",
        keyboardNavigation: false,
        forceParse: false,
        calendarWeeks: true,
        autoclose: true
      });
    });
    $('#data_1 .input-group.date').datepicker({
      todayBtn: "linked",
      keyboardNavigation: false,
      forceParse: false,
      calendarWeeks: true,
      autoclose: true
    });
  </script>

</body>

</html>