<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
    header('Location: login.php');
    exit;
}

// Validate query params
$std = isset($_GET['id']) ? (int) $_GET['id'] : 0;
$tm = isset($_GET['tm']) ? (int) $_GET['tm'] : 0;
$subject_id = isset($_GET['sub']) ? (int) $_GET['sub'] : 0;

if ($std <= 0 || $tm <= 0 || $subject_id < 0) {
    echo '<div class="alert alert-danger">Invalid parameters</div>';
    exit;
}

// Load financial term
$term2 = $year = $startdate = $enddate = '';
$stmt = mysqli_prepare($con, "SELECT term, year, startdate, enddate FROM financialterms WHERE financialterm_id = ? LIMIT 1");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $tm);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $row4 = mysqli_fetch_assoc($res);
    if ($row4) {
        $term2 = $row4['term'] ?? '';
        $year = $row4['year'] ?? '';
        $startdate = $row4['startdate'] ?? '';
        $enddate = $row4['enddate'] ?? '';
    }
    mysqli_stmt_close($stmt);
}

// Find class_id for this student's marks in this term
$class_id = 0;
$stmt = mysqli_prepare($con, "SELECT class_id FROM marks WHERE term_id = ? AND student_id = ? LIMIT 1");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'ii', $tm, $std);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $roww = mysqli_fetch_assoc($res);
    if ($roww) $class_id = (int) ($roww['class_id'] ?? 0);
    mysqli_stmt_close($stmt);
}

// Load class info
$class2 = '';
$category_id = 0;
$report_type = 0;
$stmt = mysqli_prepare($con, "SELECT class, category_id, report_type FROM classes WHERE class_id = ? LIMIT 1");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $class_id);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $row2 = mysqli_fetch_assoc($res);
    if ($row2) {
        $class2 = $row2['class'] ?? '';
        $category_id = (int) ($row2['category_id'] ?? 0);
        $report_type = (int) ($row2['report_type'] ?? 0);
    }
    mysqli_stmt_close($stmt);
}

// Load class category
$classcategory = '';
if ($category_id > 0) {
    $stmt = mysqli_prepare($con, "SELECT classcategory FROM classcategories WHERE classcategory_id = ? LIMIT 1");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, 'i', $category_id);
        mysqli_stmt_execute($stmt);
        $res = mysqli_stmt_get_result($stmt);
        $rowc = mysqli_fetch_assoc($res);
        if ($rowc) $classcategory = $rowc['classcategory'] ?? '';
        mysqli_stmt_close($stmt);
    }
}

// Load student name
$fullname = '';
$stmt = mysqli_prepare($con, "SELECT fullname FROM students WHERE student_id = ? LIMIT 1");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $std);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $rows = mysqli_fetch_assoc($res);
    if ($rows) $fullname = $rows['fullname'] ?? '';
    mysqli_stmt_close($stmt);
}

// Load class teacher name
$teachername = '';
if ($class_id > 0) {
    $stmt = mysqli_prepare($con, "SELECT fullname FROM teachers WHERE status = 1 AND class_id = ? LIMIT 1");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, 'i', $class_id);
        mysqli_stmt_execute($stmt);
        $res = mysqli_stmt_get_result($stmt);
        $rowt = mysqli_fetch_assoc($res);
        if ($rowt) $teachername = $rowt['fullname'] ?? '';
        mysqli_stmt_close($stmt);
    }
}

// Handle POST - update effort
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['type2'])) {
    $effort = isset($_POST['effort']) ? (int) $_POST['effort'] : 0;
    if ($effort > 0) {
        if ($subject_id > 0) {
            // Update specific subject
            $upd = mysqli_prepare($con, "UPDATE marks SET effort_id = ? WHERE student_id = ? AND term_id = ? AND subject_id = ?");
            if ($upd) {
                mysqli_stmt_bind_param($upd, 'iiii', $effort, $std, $tm, $subject_id);
                mysqli_stmt_execute($upd);
                mysqli_stmt_close($upd);
                $flash = '<div class="alert alert-success">Effort Successfully Added</div>';
            } else {
                $flash = '<div class="alert alert-danger">Database error: could not prepare update.</div>';
            }
        } else {
            // Update all subjects for this student in this term (class teacher mode)
            $upd = mysqli_prepare($con, "UPDATE marks SET effort_id = ? WHERE student_id = ? AND term_id = ?");
            if ($upd) {
                mysqli_stmt_bind_param($upd, 'iii', $effort, $std, $tm);
                mysqli_stmt_execute($upd);
                mysqli_stmt_close($upd);
                $flash = '<div class="alert alert-success">Effort Successfully Added to All Subjects</div>';
            } else {
                $flash = '<div class="alert alert-danger">Database error: could not prepare update.</div>';
            }
        }
    } else {
        $flash = '<div class="alert alert-warning">Please select an effort level.</div>';
    }
}

// Fetch marks for display
$marks_rows = [];
if ($subject_id > 0) {
    // Fetch marks for a specific subject
    $marks_stmt = mysqli_prepare($con, "SELECT * FROM marks WHERE student_id = ? AND term_id = ? AND subject_id = ? AND status = 1 GROUP BY subject_id");
    if ($marks_stmt) {
        mysqli_stmt_bind_param($marks_stmt, 'iii', $std, $tm, $subject_id);
        mysqli_stmt_execute($marks_stmt);
        $res = mysqli_stmt_get_result($marks_stmt);
        while ($r = mysqli_fetch_assoc($res)) {
            $marks_rows[] = $r;
        }
        mysqli_stmt_close($marks_stmt);
    }
} else {
    // Fetch marks for all subjects (class teacher mode)
    $marks_stmt = mysqli_prepare($con, "SELECT * FROM marks WHERE student_id = ? AND term_id = ? AND status = 1 GROUP BY subject_id");
    if ($marks_stmt) {
        mysqli_stmt_bind_param($marks_stmt, 'ii', $std, $tm);
        mysqli_stmt_execute($marks_stmt);
        $res = mysqli_stmt_get_result($marks_stmt);
        while ($r = mysqli_fetch_assoc($res)) {
            $marks_rows[] = $r;
        }
        mysqli_stmt_close($marks_stmt);
    }
}

// Load papers (ordered)
$papers = [];
$res = mysqli_query($con, "SELECT * FROM papers WHERE status = 1 ORDER BY paper_id");
if ($res) {
    while ($p = mysqli_fetch_assoc($res)) $papers[] = $p;
}

// Load effort types
$effort_types = [];
$res = mysqli_query($con, "SELECT * FROM effort_types WHERE status = 1 ORDER BY rank ASC");
if ($res) {
    while ($e = mysqli_fetch_assoc($res)) $effort_types[] = $e;
}

?><!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Effort - School Manager</title>
    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'nav.php'; ?>
    <div class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">Add Effort for <?php echo htmlspecialchars($fullname); ?></header>
                    <div class="panel-body">
                        <?php echo $flash ?? ''; ?>

                        <?php if (empty($marks_rows)) { ?>
                            <div class="alert alert-info">No marks found for this student / subject / term.</div>
                        <?php } else { ?>

                        <?php if ($subject_id > 0) { ?>
                            <!-- Single subject mode -->
                        <form method="POST" class="form-horizontal" action="" enctype="multipart/form-data">
                            <table class="display table" id="dynamic-table">
                                <thead>
                                <tr>
                                    <th>Subject</th>
                                    <?php foreach ($papers as $p) echo '<th>' . htmlspecialchars($p['paper_name']) . '</th>'; ?>
                                    <th>Tot</th>
                                    <th>%</th>
                                    <th>Effort</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($marks_rows as $row) {
                                    // load subject name
                                    $sid = (int) ($row['subject_id'] ?? 0);
                                    $subject = '';
                                    $sres = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1");
                                    if ($sres) {
                                        mysqli_stmt_bind_param($sres, 'i', $sid);
                                        mysqli_stmt_execute($sres);
                                        $srow = mysqli_stmt_get_result($sres);
                                        if ($srow) {
                                            $sfetch = mysqli_fetch_assoc($srow);
                                            $subject = $sfetch['subject'] ?? '';
                                        }
                                        mysqli_stmt_close($sres);
                                    }

                                    // calculate paper marks
                                    $total = 0;
                                    $markArr = [];
                                    foreach ($papers as $paper) {
                                        $paper_id = (int) $paper['paper_id'];
                                        $gstmt = mysqli_prepare($con, "SELECT marks, rank FROM marks WHERE class_id = ? AND student_id = ? AND term_id = ? AND subject_id = ? AND assessment = ? AND paper_id = ? AND status = 1 LIMIT 1");
                                        $exammark_display = 'N/A';
                                        if ($gstmt) {
                                            $assessment = 2; // exam
                                            mysqli_stmt_bind_param($gstmt, 'iiiiii', $class_id, $std, $tm, $sid, $assessment, $paper_id);
                                            mysqli_stmt_execute($gstmt);
                                            $gres = mysqli_stmt_get_result($gstmt);
                                            if ($grow = mysqli_fetch_assoc($gres)) {
                                                $m1 = (int) ($grow['marks'] ?? 0);
                                                $rank = (int) ($grow['rank'] ?? 1);
                                                $exammark = $rank > 0 ? round(($m1 / $rank) * 100) : 0;
                                                $exammark_display = $exammark;
                                                $markArr[] = $exammark;
                                                $total += $exammark;
                                            }
                                            mysqli_stmt_close($gstmt);
                                        }
                                        echo '<td>' . htmlspecialchars((string) $exammark_display) . '</td>';
                                    }

                                    $numpapers = max(1, count($papers));
                                    // compute grand total/average
                                    if (in_array('N/A', $markArr, true) && count($markArr) === 0) {
                                        $grand = $numpapers > 0 ? round($total / $numpapers) : 0;
                                    } elseif (count($markArr) > 0) {
                                        $grand = round(array_sum($markArr) / count($markArr));
                                    } else {
                                        $grand = round($total / $numpapers);
                                    }

                                    echo '<td>' . htmlspecialchars((string) $total) . '</td>';
                                    echo '<td>' . htmlspecialchars((string) $grand) . '</td>';

                                    // current effort for this row
                                    $effort_id2 = (int) ($row['effort_id'] ?? 0);

                                    echo '<td><select name="effort" class="form-control">';
                                    echo '<option value="">Select Effort</option>';
                                    foreach ($effort_types as $et) {
                                        $eid = (int) $et['effort_id'];
                                        $ename = $et['name'] ?? '';
                                        $sel = $eid === $effort_id2 ? ' selected' : '';
                                        echo '<option value="' . $eid . '"' . $sel . '>' . htmlspecialchars($ename) . '</option>';
                                    }
                                    echo '</select></td>';

                                    echo '</tr>';
                                }
                                ?>
                                </tbody>
                            </table>

                            <div class="form-group">
                                <button class="btn btn-primary" type="submit" name="type2">Submit Effort</button>
                            </div>
                        </form>

                        <?php } else { ?>
                            <!-- Class Teacher mode - Apply effort to all subjects -->
                            <div class="alert alert-info">
                                <strong>Class Teacher Mode:</strong> You can set the same effort level for all subjects for this student.
                            </div>
                            
                            <form method="POST" class="form-horizontal" action="" enctype="multipart/form-data">
                            <table class="display table table-bordered" id="dynamic-table">
                                <thead>
                                <tr>
                                    <th>Subject</th>
                                    <?php foreach ($papers as $p) echo '<th>' . htmlspecialchars($p['paper_name']) . '</th>'; ?>
                                    <th>Tot</th>
                                    <th>%</th>
                                    <th>Current Effort</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($marks_rows as $row) {
                                    // load subject name
                                    $sid = (int) ($row['subject_id'] ?? 0);
                                    $subject = '';
                                    $sres = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1");
                                    if ($sres) {
                                        mysqli_stmt_bind_param($sres, 'i', $sid);
                                        mysqli_stmt_execute($sres);
                                        $srow = mysqli_stmt_get_result($sres);
                                        if ($srow) {
                                            $sfetch = mysqli_fetch_assoc($srow);
                                            $subject = $sfetch['subject'] ?? '';
                                        }
                                        mysqli_stmt_close($sres);
                                    }

                                    echo '<tr><td>' . htmlspecialchars($subject) . '</td>';

                                    // calculate paper marks
                                    $total = 0;
                                    $markArr = [];
                                    foreach ($papers as $paper) {
                                        $paper_id = (int) $paper['paper_id'];
                                        $gstmt = mysqli_prepare($con, "SELECT marks, rank FROM marks WHERE class_id = ? AND student_id = ? AND term_id = ? AND subject_id = ? AND assessment = ? AND paper_id = ? AND status = 1 LIMIT 1");
                                        $exammark_display = 'N/A';
                                        if ($gstmt) {
                                            $assessment = 2; // exam
                                            mysqli_stmt_bind_param($gstmt, 'iiiiii', $class_id, $std, $tm, $sid, $assessment, $paper_id);
                                            mysqli_stmt_execute($gstmt);
                                            $gres = mysqli_stmt_get_result($gstmt);
                                            if ($grow = mysqli_fetch_assoc($gres)) {
                                                $m1 = (int) ($grow['marks'] ?? 0);
                                                $rank = (int) ($grow['rank'] ?? 1);
                                                $exammark = $rank > 0 ? round(($m1 / $rank) * 100) : 0;
                                                $exammark_display = $exammark;
                                                $markArr[] = $exammark;
                                                $total += $exammark;
                                            }
                                            mysqli_stmt_close($gstmt);
                                        }
                                        echo '<td>' . htmlspecialchars((string) $exammark_display) . '</td>';
                                    }

                                    $numpapers = max(1, count($papers));
                                    if (in_array('N/A', $markArr, true) && count($markArr) === 0) {
                                        $grand = $numpapers > 0 ? round($total / $numpapers) : 0;
                                    } elseif (count($markArr) > 0) {
                                        $grand = round(array_sum($markArr) / count($markArr));
                                    } else {
                                        $grand = round($total / $numpapers);
                                    }

                                    echo '<td>' . htmlspecialchars((string) $total) . '</td>';
                                    echo '<td>' . htmlspecialchars((string) $grand) . '</td>';

                                    // current effort for this row (display only)
                                    $effort_id2 = (int) ($row['effort_id'] ?? 0);
                                    $current_effort_name = 'Not Set';
                                    foreach ($effort_types as $et) {
                                        if ((int)$et['effort_id'] === $effort_id2) {
                                            $current_effort_name = $et['name'] ?? 'Not Set';
                                            break;
                                        }
                                    }
                                    echo '<td>' . htmlspecialchars($current_effort_name) . '</td>';
                                    echo '</tr>';
                                }
                                ?>
                                </tbody>
                            </table>

                            <div class="form-group">
                                <label class="col-sm-2 control-label">Set Effort for All Subjects:</label>
                                <div class="col-sm-4">
                                    <select name="effort" class="form-control" required>
                                        <option value="">Select Effort Level</option>
                                        <?php foreach ($effort_types as $et) {
                                            $eid = (int) $et['effort_id'];
                                            $ename = $et['name'] ?? '';
                                            echo '<option value="' . $eid . '">' . htmlspecialchars($ename) . '</option>';
                                        } ?>
                                    </select>
                                </div>
                                <div class="col-sm-4">
                                    <button class="btn btn-primary" type="submit" name="type2">Apply Effort to All Subjects</button>
                                </div>
                            </div>
                        </form>
                        <?php } ?>

                        <?php } ?>
                    </div>
                </section>
            </div>
        </div>
    </div>
</section>
<script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
</body>
</html>
 



