<?php
include 'includes/conn.php';
include 'includes/roles.php';

// Only Super Admin can access system configuration
if ($_SESSION['schoolsyslevel'] != 1) {
    header('Location:login.php');
    exit();
}

// Handle configuration updates
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'update_config') {
    $config_key = mysqli_real_escape_string($con, $_POST['config_key'] ?? '');
    $config_value = mysqli_real_escape_string($con, $_POST['config_value'] ?? '');
    
    if (empty($config_key)) {
        $_SESSION['message'] = 'Configuration key is required';
        $_SESSION['msg_type'] = 'danger';
    } else {
        $check_query = "SELECT * FROM system_configuration WHERE config_key = '$config_key'";
        $check_result = mysqli_query($con, $check_query);
        
        if (mysqli_num_rows($check_result) > 0) {
            $update_query = "UPDATE system_configuration SET config_value = '$config_value', updated_at = NOW() WHERE config_key = '$config_key'";
            if (mysqli_query($con, $update_query)) {
                $_SESSION['message'] = 'Configuration updated successfully';
                $_SESSION['msg_type'] = 'success';
            } else {
                $_SESSION['message'] = 'Error updating configuration: ' . mysqli_error($con);
                $_SESSION['msg_type'] = 'danger';
            }
        } else {
            $_SESSION['message'] = 'Configuration key not found';
            $_SESSION['msg_type'] = 'danger';
        }
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>System Configuration</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title">
                            <i class="fa fa-cogs"></i> System Configuration
                        </h4>
                    </header>
                    <div class="panel-body">
                        <?php
                        if (isset($_SESSION['message'])) {
                            echo '<div class="alert alert-' . (isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info') . ' alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    ' . htmlspecialchars($_SESSION['message']) . '
                                 </div>';
                            unset($_SESSION['message']);
                            unset($_SESSION['msg_type']);
                        }
                        ?>
                        
                        <!-- Navigation Tabs -->
                        <ul class="nav nav-tabs margin-bottom-20">
                            <li class="active"><a data-toggle="tab" href="#general">General Settings</a></li>
                            <li><a data-toggle="tab" href="#financial">Financial Settings</a></li>
                            <li><a data-toggle="tab" href="#security">Security & Backup</a></li>
                            <li><a data-toggle="tab" href="#system">System Utilities</a></li>
                        </ul>
                        
                        <div class="tab-content">
                            <!-- General Settings Tab -->
                            <div id="general" class="tab-pane fade in active">
                                <form method="POST" action="">
                                    <input type="hidden" name="action" value="update_config">
                                    
                                    <div class="form-group">
                                        <label class="control-label">Currency Code</label>
                                        <input type="text" name="config_value" class="form-control" placeholder="e.g., KES" maxlength="10">
                                        <small class="form-text text-muted">ISO 4217 currency code</small>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="control-label">Currency Symbol</label>
                                        <input type="text" name="config_value" class="form-control" placeholder="e.g., KES, $, £" maxlength="5">
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="control-label">Decimal Places</label>
                                        <select name="config_value" class="form-control">
                                            <option value="2">2 (Default)</option>
                                            <option value="0">0 (Whole numbers)</option>
                                            <option value="1">1 (Single decimal)</option>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="control-label">Date Format</label>
                                        <input type="text" name="config_value" class="form-control" placeholder="e.g., d/M/Y" value="d/M/Y">
                                    </div>
                                    
                                    <button type="submit" class="btn btn-success">Save Settings</button>
                                </form>
                            </div>
                            
                            <!-- Financial Settings Tab -->
                            <div id="financial" class="tab-pane fade">
                                <form method="POST" action="">
                                    <input type="hidden" name="action" value="update_config">
                                    
                                    <div class="form-group">
                                        <label class="control-label">Financial Year Start Month</label>
                                        <select name="config_value" class="form-control">
                                            <option value="01">January</option>
                                            <option value="04">April</option>
                                            <option value="07">July</option>
                                            <option value="09">September</option>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="control-label">Invoice Prefix</label>
                                        <input type="text" name="config_value" class="form-control" placeholder="e.g., INV-" value="INV-">
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="control-label">Receipt Prefix</label>
                                        <input type="text" name="config_value" class="form-control" placeholder="e.g., RCP-" value="RCP-">
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="control-label">Tax Calculation Method</label>
                                        <select name="config_value" class="form-control">
                                            <option value="automatic">Automatic (from tax tables)</option>
                                            <option value="manual">Manual (entered by user)</option>
                                        </select>
                                    </div>
                                    
                                    <button type="submit" class="btn btn-success">Save Settings</button>
                                </form>
                            </div>
                            
                            <!-- Security & Backup Tab -->
                            <div id="security" class="tab-pane fade">
                                <form method="POST" action="">
                                    <input type="hidden" name="action" value="update_config">
                                    
                                    <div class="form-group">
                                        <label class="control-label">Enable Audit Logging</label>
                                        <select name="config_value" class="form-control">
                                            <option value="true">Yes (Enabled)</option>
                                            <option value="false">No (Disabled)</option>
                                        </select>
                                        <small class="form-text text-muted">Track all financial transactions for compliance</small>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="control-label">Enable Data Encryption</label>
                                        <select name="config_value" class="form-control">
                                            <option value="false">No (Disabled)</option>
                                            <option value="true">Yes (Enabled)</option>
                                        </select>
                                        <small class="form-text text-muted">Encrypt sensitive financial data (requires OpenSSL)</small>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="control-label">Backup Frequency</label>
                                        <select name="config_value" class="form-control">
                                            <option value="daily">Daily</option>
                                            <option value="weekly">Weekly</option>
                                            <option value="monthly">Monthly</option>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="control-label">Backup Retention (Days)</label>
                                        <input type="number" name="config_value" class="form-control" value="90" min="7" max="365">
                                    </div>
                                    
                                    <button type="submit" class="btn btn-success">Save Settings</button>
                                </form>
                            </div>
                            
                            <!-- System Utilities Tab -->
                            <div id="system" class="tab-pane fade">
                                <div class="row">
                                    <div class="col-md-6">
                                        <section class="panel">
                                            <header class="panel-heading">
                                                <h4 class="panel-title">Database Backup</h4>
                                            </header>
                                            <div class="panel-body">
                                                <p>Create a complete backup of your school database for safekeeping.</p>
                                                <button type="button" class="btn btn-primary btn-block" onclick="confirmBackup()">
                                                    <i class="fa fa-download"></i> Create Backup Now
                                                </button>
                                            </div>
                                        </section>
                                    </div>
                                    <div class="col-md-6">
                                        <section class="panel">
                                            <header class="panel-heading">
                                                <h4 class="panel-title">Database Restore</h4>
                                            </header>
                                            <div class="panel-body">
                                                <p>Restore your database from a previously created backup.</p>
                                                <button type="button" class="btn btn-warning btn-block" data-toggle="modal" data-target="#restoreModal">
                                                    <i class="fa fa-upload"></i> Restore from Backup
                                                </button>
                                            </div>
                                        </section>
                                    </div>
                                </div>
                                
                                <div class="row margin-top-20">
                                    <div class="col-md-6">
                                        <section class="panel">
                                            <header class="panel-heading">
                                                <h4 class="panel-title">System Logs</h4>
                                            </header>
                                            <div class="panel-body">
                                                <p>View and export system transaction logs and audit trails.</p>
                                                <a href="transactionlogs.php" class="btn btn-info btn-block">
                                                    <i class="fa fa-file"></i> View Logs
                                                </a>
                                            </div>
                                        </section>
                                    </div>
                                    <div class="col-md-6">
                                        <section class="panel">
                                            <header class="panel-heading">
                                                <h4 class="panel-title">Database Statistics</h4>
                                            </header>
                                            <div class="panel-body">
                                                <p>View database usage statistics and optimization recommendations.</p>
                                                <button type="button" class="btn btn-success btn-block" onclick="viewDatabaseStats()">
                                                    <i class="fa fa-bar-chart"></i> Database Stats
                                                </button>
                                            </div>
                                        </section>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<!-- Restore Modal -->
<div class="modal fade" id="restoreModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Restore Database from Backup</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="POST" action="restorebackup.php" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="alert alert-danger">
                        <strong>Warning:</strong> Restoring from backup will overwrite your current data. Please ensure you have a current backup before proceeding.
                    </div>
                    <div class="form-group">
                        <label class="control-label">Select Backup File</label>
                        <input type="file" name="backup_file" class="form-control" accept=".sql,.zip" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger" onclick="return confirm('This will overwrite your current database. Are you sure?')">
                        <i class="fa fa-exclamation-triangle"></i> Restore Database
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/scripts.js"></script>
<script>
function confirmBackup() {
    if (confirm('Create a backup of your database now?')) {
        window.location.href = 'includes/backup_restore.php?action=create';
    }
}

function viewDatabaseStats() {
    window.location.href = 'databasestats.php';
}
</script>
</body>
</html>
