<?php
// substitutions.php - admin view for recorded substitutions
include 'includes/conn.php';
// includes/conn.php already starts the session safely when needed.
// Use a defensive check here in case a future include changes behavior.
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
if (!isset($_SESSION['schoolsyslevel']) || (int)$_SESSION['schoolsyslevel'] !== 1) {
    header('Location: login.php');
    exit;
}

// simple pagination
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$per = 20;
$offset = ($page - 1) * $per;

$total_r = mysqli_query($con, "SELECT COUNT(*) AS c FROM substitutions");
$total = 0;
if ($total_r) {
    $tr = mysqli_fetch_assoc($total_r);
    $total = (int)($tr['c'] ?? 0);
}

$res = mysqli_query($con, "SELECT s.*, c.class AS class_name, st.stream AS stream_name, t1.fullname AS original_name, t2.fullname AS substitute_name, u.fullname AS created_by_name FROM substitutions s LEFT JOIN classes c ON s.class_id=c.class_id LEFT JOIN streams st ON s.stream_id=st.stream_id LEFT JOIN teachers t1 ON s.original_teacher_id=t1.teacher_id LEFT JOIN teachers t2 ON s.substitute_teacher_id=t2.teacher_id LEFT JOIN users u ON s.created_by=u.user_id ORDER BY s.created_at DESC LIMIT {$per} OFFSET {$offset}");

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <title>Substitutions</title>
  <!-- common styles (use BASE_URL to ensure correct paths) -->
  <!-- Load theme styles after bootstrap (bootstrap is imported inside style.css) -->
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
</head>
<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

    <div class="wrapper">
      <div class="container" style="margin-top:20px;">
  <h3>Substitutions (<?php echo $total; ?>)</h3>
  <table class="table table-striped table-bordered">
    <thead>
      <tr>
        <th>ID</th>
        <th>Date</th>
        <th>Time</th>
        <th>Class</th>
        <th>Original</th>
        <th>Substitute</th>
        <th>Created By</th>
        <th>Created At</th>
        <th>Status</th>
        <th>Actions</th>
      </tr>
    </thead>
    <tbody>
<?php
if ($res) {
    while ($r = mysqli_fetch_assoc($res)) {
        echo '<tr>';
        echo '<td>'.(int)$r['substitution_id'].'</td>';
    $date_disp = htmlspecialchars($r['date']);
    $day_disp = '';
    if (!empty($r['date'])) {
      try { $day_disp = (new DateTime($r['date']))->format('D'); } catch (Exception $e) { $day_disp = ''; }
    }
    echo '<td>'.$date_disp.(!empty($day_disp)? ' <span class="label label-default">'.$day_disp.'</span>' : '').'</td>';
        echo '<td>'.htmlspecialchars($r['starttime'].' - '.$r['endtime']).'</td>';
        echo '<td>'.htmlspecialchars(($r['class_name']??'').' '.($r['stream_name']??'')).'</td>';
        echo '<td>'.htmlspecialchars($r['original_name'] ?? 'N/A').'</td>';
        echo '<td>'.htmlspecialchars($r['substitute_name'] ?? 'N/A').'</td>';
        echo '<td>'.htmlspecialchars($r['created_by_name'] ?? '').'</td>';
        echo '<td>'.htmlspecialchars($r['created_at'] ?? '').'</td>';
        echo '<td>'.((int)$r['status']===1? 'Active' : 'Cancelled').'</td>';
        echo '<td>';
        echo '<a href="substitution_details.php?id='.(int)$r['substitution_id'].'" class="btn btn-sm btn-info">View</a> ';
        if ((int)$r['status']===1) {
            echo '<form method="POST" action="cancel_substitution.php" style="display:inline;">';
            echo '<input type="hidden" name="id" value="'.(int)$r['substitution_id'].'">';
            echo '<button class="btn btn-sm btn-danger" type="submit" onclick="return confirm(\'Cancel this substitution?\')">Cancel</button>';
            echo '</form>';
        }
        echo '</td>';
        echo '</tr>';
    }
}
?>
    </tbody>
  </table>
  <nav>
    <ul class="pagination">
<?php
$pages = ceil($total/$per);
for ($i=1;$i<=$pages;$i++) {
    $cls = $i===$page? 'active':'';
    echo '<li class="page-item '.$cls.'"><a class="page-link" href="?page='.$i.'">'.$i.'</a></li>';
}
?>
    </ul>
  </nav>
      </div> <!-- /container -->
    </div> <!-- /wrapper -->
    <!-- main content end -->
</section>
<!-- common scripts -->
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>
</html>
