<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsyslevel']) && !isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  echo 'Invalid substitution id';
  exit;
}

$q = mysqli_prepare($con, "SELECT s.*, t1.fullname AS original_name, t2.fullname AS substitute_name, c.class AS class_name, st.stream AS stream_name, cs.class_sub_id, sub.subject AS subject_name FROM substitutions s LEFT JOIN teachers t1 ON s.original_teacher_id=t1.teacher_id LEFT JOIN teachers t2 ON s.substitute_teacher_id=t2.teacher_id LEFT JOIN classes c ON s.class_id=c.class_id LEFT JOIN streams st ON s.stream_id=st.stream_id LEFT JOIN class_subjects cs ON s.class_sub_id=cs.class_sub_id LEFT JOIN subjects sub ON cs.subject_id=sub.subject_id WHERE s.substitution_id = ? LIMIT 1");
if ($q) {
  mysqli_stmt_bind_param($q, 'i', $id);
  mysqli_stmt_execute($q);
  $res = mysqli_stmt_get_result($q);
  if ($res && mysqli_num_rows($res) > 0) {
    $r = mysqli_fetch_assoc($res);
  } else {
    echo 'Substitution not found';
    exit;
  }
  if ($q) mysqli_stmt_close($q);
} else {
  echo 'Failed to prepare query';
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <title>Substitution Details</title>
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
</head>
<body class="sticky-header">
  <section>
    <?php include 'includes/header.php'; ?>
    <div class="wrapper">
      <div class="row">
        <div class="col-lg-10">
          <section class="panel">
            <header class="panel-heading">Substitution Details</header>
            <div class="panel-body">
    <table class="table table-bordered">
      <tr><th>Reference ID</th><td><?php echo (int)$r['substitution_id']; ?></td></tr>
      <tr><th>Date</th><td><?php $dd = $r['date'] ?? ''; $dlabel=''; if (!empty($dd)) { try { $dlabel = (new DateTime($dd))->format('l'); } catch (Exception $e) { $dlabel=''; } } echo htmlspecialchars($dd).(!empty($dlabel)? ' <span class="label label-default">'.$dlabel.'</span>':'' ); ?></td></tr>
      <tr><th>Time</th><td><?php echo htmlspecialchars(($r['starttime'] ?? '') . ' - ' . ($r['endtime'] ?? '')); ?></td></tr>
      <tr><th>Class</th><td><?php echo htmlspecialchars($r['class_name'] ?? ''); ?></td></tr>
      <tr><th>Stream</th><td><?php echo htmlspecialchars($r['stream_name'] ?? ''); ?></td></tr>
      <tr><th>Subject</th><td><?php echo htmlspecialchars($r['subject_name'] ?? ($r['class_sub_id'] ?? 'N/A')); ?></td></tr>
      <tr><th>Original Teacher</th><td><?php echo htmlspecialchars($r['original_name'] ?? 'N/A'); ?></td></tr>
      <tr><th>Substitute Teacher</th><td><?php echo htmlspecialchars($r['substitute_name'] ?? 'N/A'); ?></td></tr>
      <tr><th>Assigned By</th><td><?php echo htmlspecialchars($r['created_by'] ?? ''); ?></td></tr>
      <tr><th>Created At</th><td><?php echo htmlspecialchars($r['created_at'] ?? ''); ?></td></tr>
      <?php if (!empty($r['notes'])): ?>
      <tr><th>Notes</th><td><?php echo nl2br(htmlspecialchars($r['notes'])); ?></td></tr>
      <?php endif; ?>
      <tr><th>Status</th><td><?php echo ((int)($r['status'] ?? 0) === 1) ? '<span class="label label-success">Active</span>' : '<span class="label label-default">Cancelled</span>'; ?></td></tr>
    </table>
    <p>
      <a href="substitutions.php" class="btn btn-primary">Back to Substitutions List</a>
    </p>
            </div>
          </section>
        </div>
      </div>
    </div>
  </section>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>
</html>