<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['schoolsyslevel']) || !in_array($_SESSION['schoolsyslevel'], [1,2,3,8,10])){
    header('Location:login.php');
    exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    header('Location:accountstudents.php');
    exit;
}

// Get student information
$studentQ = mysqli_query($con, "SELECT s.*, c.class FROM students s 
    JOIN classes c ON s.class_id = c.class_id 
    WHERE s.student_id = $id AND s.status = 1 LIMIT 1");
$student = mysqli_fetch_assoc($studentQ);

if (!$student) {
    header('Location:accountstudents.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Student Fee Details - <?php echo htmlspecialchars($student['fullname']); ?></title>
  <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
  <style>
    .fee-breakdown { background: #f9f9f9; padding: 15px; border-radius: 5px; margin: 10px 0; }
    .fee-row { display: flex; justify-content: space-between; padding: 8px 0; border-bottom: 1px solid #e0e0e0; }
    .fee-row.total { font-weight: bold; font-size: 1.1em; border-top: 2px solid #333; margin-top: 10px; }
    .discount-badge { background: #27ae60; color: white; padding: 3px 8px; border-radius: 3px; font-size: 0.9em; }
    .penalty-badge { background: #e74c3c; color: white; padding: 3px 8px; border-radius: 3px; font-size: 0.9em; }
    .early-badge { background: #3498db; color: white; padding: 3px 8px; border-radius: 3px; font-size: 0.9em; }
    .overpaid-badge { background: #9b59b6; color: white; padding: 3px 8px; border-radius: 3px; font-size: 0.9em; }
    .status-paid { color: #27ae60; font-weight: bold; }
    .status-partial { color: #f39c12; font-weight: bold; }
    .status-unpaid { color: #e74c3c; font-weight: bold; }
  </style>
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

<section class="wrapper">
<div class="row">
    <?php
    // Check if required tables exist
    $calcTableCheck = mysqli_query($con, "SHOW TABLES LIKE 'student_fee_calculations'");
    $tablesExist = $calcTableCheck && mysqli_num_rows($calcTableCheck) > 0;
    
    if (!$tablesExist) {
        ?>
        <div class="col-md-12">
            <div class="alert alert-warning alert-block" style="margin: 20px;">
                <button type="button" class="close" data-dismiss="alert">×</button>
                <h4><i class="fa fa-info-circle"></i> Enhanced Fee System Not Yet Configured</h4>
                <p>The advanced fee calculation features (family discounts, early payment, etc.) require database setup.</p>
                <p>To enable these features, run the SQL script: <code>sql/family_discount_enhancements.sql</code></p>
                <p>See <code>DATABASE_SETUP_REQUIRED.md</code> for instructions.</p>
            </div>
        </div>
        <?php
    }
    ?>
    
    <!-- Student Info Sidebar -->
    <div class="col-lg-3">
        <section class="panel">
            <div class="panel-body text-center">
                <img src="<?php echo BASE_URL;?>/images/students/<?php echo md5($id).'.'.$student['ext'].'?'.time(); ?>" 
                     class="img img-responsive" alt="Student Photo">
                <h4 style="margin-top: 15px;"><?php echo htmlspecialchars($student['fullname']); ?></h4>
                <p><?php echo htmlspecialchars($student['regnumber']); ?></p>
                <p><strong>Class:</strong> <?php echo htmlspecialchars($student['class']); ?></p>
            </div>
        </section>
        
        <?php
        // Get family information
        $familyId = isset($student['family_id']) ? (int)$student['family_id'] : 0;
        if ($familyId > 0) {
            // Check if families table exists
            $famTableCheck = mysqli_query($con, "SHOW TABLES LIKE 'families'");
            if ($famTableCheck && mysqli_num_rows($famTableCheck) > 0) {
                $familyQ = mysqli_query($con, "SELECT * FROM families WHERE family_id = $familyId LIMIT 1");
            } else {
                $familyQ = false;
            }
                if ($familyQ && mysqli_num_rows($familyQ) > 0) {
                    $family = mysqli_fetch_assoc($familyQ);
                    ?>
                    <section class="panel panel-info">
                    <header class="panel-heading">
                        <h4><i class="fa fa-users"></i> Family Information</h4>
                    </header>
                    <div class="panel-body">
                        <p><strong>Family:</strong> <?php echo htmlspecialchars($family['family_name'] ?? 'Family '.$familyId); ?></p>
                        <p><strong>Total Students:</strong> <?php echo (int)$family['total_students']; ?></p>
                        <p><strong>Eligible for Discount:</strong> <?php echo (int)$family['discount_eligible_count']; ?></p>
                        <?php if ($family['discount_eligible_count'] >= 2) { ?>
                            <p class="text-success"><i class="fa fa-check"></i> Eligible for Sibling Discount</p>
                        <?php } ?>
                    </div>
                </section>
                <?php
            }
        }
        ?>
        
        <a href="accountstudents.php" class="btn btn-default btn-block">
            <i class="fa fa-arrow-left"></i> Back to Students
        </a>
    </div>

    <!-- Fee Details Main Content -->
    <div class="col-lg-9">
        
        <!-- Quick Actions -->
        <?php if (in_array($_SESSION['schoolsyslevel'], [1,2,3,8])) { ?>
        <div class="btn-group" style="margin-bottom: 15px;">
            <a href="addfeespayment.php?id=<?php echo $id; ?>" class="btn btn-success">
                <i class="fa fa-money"></i> Add Payment
            </a>
            <a href="addfeesdiscount.php?id=<?php echo $id; ?>" class="btn btn-info">
                <i class="fa fa-gift"></i> Add Discount
            </a>
            <button onclick="recalculateFees(<?php echo $id; ?>)" class="btn btn-primary">
                <i class="fa fa-refresh"></i> Recalculate Fees
            </button>
            <a href="student_fee_statement.php?id=<?php echo $id; ?>" class="btn btn-default" target="_blank">
                <i class="fa fa-print"></i> Print Statement
            </a>
        </div>
        <?php } ?>

        <!-- Term-by-Term Fee Details -->
        <?php
        // Get all terms with payments
        $termsQuery = "SELECT DISTINCT ft.financialterm_id, ft.term, ft.year, ft.startdate, ft.enddate
            FROM financialterms ft
            WHERE ft.status = 1
            ORDER BY ft.financialterm_id DESC";
        $termsResult = mysqli_query($con, $termsQuery);
        
        while ($termRow = mysqli_fetch_assoc($termsResult)) {
            $termId = (int)$termRow['financialterm_id'];
            $termName = "Term " . $termRow['term'] . " " . $termRow['year'];
            
            // Check if student_fee_calculations table exists
            $tableCheck = mysqli_query($con, "SHOW TABLES LIKE 'student_fee_calculations'");
            
            if (!$tableCheck || mysqli_num_rows($tableCheck) == 0) {
                // Table doesn't exist yet, skip this term
                continue;
            }
            
            // Get or calculate fee details for this term
            $calcQuery = "SELECT * FROM student_fee_calculations 
                WHERE student_id = $id AND term_id = $termId LIMIT 1";
            $calcResult = mysqli_query($con, $calcQuery);
            
            if (!$calcResult || mysqli_num_rows($calcResult) == 0) {
                // Check if stored procedure exists before calling
                $procCheck = mysqli_query($con, "SHOW PROCEDURE STATUS WHERE Name = 'sp_calculate_student_fees'");
                if ($procCheck && mysqli_num_rows($procCheck) > 0) {
                    mysqli_query($con, "CALL sp_calculate_student_fees($id, $termId)");
                    $calcResult = mysqli_query($con, $calcQuery);
                }
            }
            
            $calc = mysqli_fetch_assoc($calcResult);
            
            // Get payment details
            $paymentsQuery = "SELECT fp.*, pb.bank_account_id, pb.transaction_reference, pb.payer_name, 
                ba.bank_name, pm.method_name
                FROM feespayments fp
                LEFT JOIN payment_bank_details pb ON fp.feespayment_id = pb.feespayment_id
                LEFT JOIN bank_accounts ba ON pb.bank_account_id = ba.bank_account_id
                LEFT JOIN payment_methods pm ON pb.payment_method_id = pm.payment_method_id
                WHERE fp.student_id = $id AND fp.term_id = $termId AND fp.status = 1
                ORDER BY fp.date DESC";
            $paymentsResult = mysqli_query($con, $paymentsQuery);
            
            if ($calc) {
                ?>
                <section class="panel">
                    <header class="panel-heading" style="background: #34495e; color: white;">
                        <h4 style="margin: 0;">
                            <?php echo $termName; ?>
                            <span class="pull-right status-<?php echo strtolower($calc['payment_status']); ?>">
                                <?php echo strtoupper($calc['payment_status']); ?>
                            </span>
                        </h4>
                    </header>
                    <div class="panel-body">
                        
                        <!-- Fee Breakdown -->
                        <div class="fee-breakdown">
                            <h5><strong>Fee Breakdown</strong></h5>
                            
                            <div class="fee-row">
                                <span>Base School Fee:</span>
                                <span>KSh <?php echo number_format($calc['base_fee_amount'], 2); ?></span>
                            </div>
                            
                            <?php if ($calc['sibling_discount_percentage'] > 0) { ?>
                            <div class="fee-row">
                                <span>
                                    Sibling Discount (<?php echo $calc['sibling_discount_percentage']; ?>% - 
                                    <?php
                                    if ($calc['sibling_position'] == 2) echo '2nd Child';
                                    elseif ($calc['sibling_position'] >= 3) echo $calc['sibling_position'].'rd+ Child';
                                    ?>)
                                    <span class="discount-badge">DISCOUNT</span>
                                </span>
                                <span class="text-success">-KSh <?php echo number_format($calc['sibling_discount_amount'], 2); ?></span>
                            </div>
                            <?php } ?>
                            
                            <?php if ($calc['early_payment_discount'] > 0) { ?>
                            <div class="fee-row">
                                <span>Early Payment Discount (5%) <span class="early-badge">EARLY</span></span>
                                <span class="text-success">-KSh <?php echo number_format($calc['early_payment_discount'], 2); ?></span>
                            </div>
                            <?php } ?>
                            
                            <?php if ($calc['late_payment_penalty'] > 0) { ?>
                            <div class="fee-row">
                                <span>Late Payment Penalty (5%) <span class="penalty-badge">LATE</span></span>
                                <span class="text-danger">+KSh <?php echo number_format($calc['late_payment_penalty'], 2); ?></span>
                            </div>
                            <?php } ?>
                            
                            <?php if ($calc['other_discounts'] > 0) { ?>
                            <div class="fee-row">
                                <span>Other Discounts:</span>
                                <span class="text-success">-KSh <?php echo number_format($calc['other_discounts'], 2); ?></span>
                            </div>
                            <?php } ?>
                            
                            <div class="fee-row total">
                                <span>Total Fee to Pay:</span>
                                <span>KSh <?php echo number_format($calc['final_fee_amount'], 2); ?></span>
                            </div>
                            
                            <div class="fee-row">
                                <span>Total Paid:</span>
                                <span class="<?php echo $calc['total_paid'] >= $calc['final_fee_amount'] ? 'text-success' : 'text-warning'; ?>">
                                    KSh <?php echo number_format($calc['total_paid'], 2); ?>
                                </span>
                            </div>
                            
                            <?php if ($calc['overpayment'] > 0) { ?>
                            <div class="fee-row">
                                <span>Overpayment <span class="overpaid-badge">CREDIT</span></span>
                                <span class="text-primary">KSh <?php echo number_format($calc['overpayment'], 2); ?></span>
                            </div>
                            <?php } ?>
                            
                            <?php if ($calc['balance'] > 0) { ?>
                            <div class="fee-row total">
                                <span>Balance Due:</span>
                                <span class="text-danger">KSh <?php echo number_format($calc['balance'], 2); ?></span>
                            </div>
                            <?php } ?>
                        </div>

                        <!-- Payment History for This Term -->
                        <?php if ($paymentsResult && mysqli_num_rows($paymentsResult) > 0) { ?>
                        <h5 style="margin-top: 20px;"><strong>Payment History</strong></h5>
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Amount</th>
                                    <th>Bank</th>
                                    <th>Payment Method</th>
                                    <th>Reference</th>
                                    <th>Paid By</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($payment = mysqli_fetch_assoc($paymentsResult)) { ?>
                                <tr>
                                    <td><?php echo date('d/M/Y', $payment['date']); ?></td>
                                    <td><strong>KSh <?php echo number_format($payment['amount'], 2); ?></strong></td>
                                    <td><?php echo htmlspecialchars($payment['bank_name'] ?? 'N/A'); ?></td>
                                    <td><?php echo htmlspecialchars($payment['method_name'] ?? 'N/A'); ?></td>
                                    <td><?php echo htmlspecialchars($payment['transaction_reference'] ?? 'N/A'); ?></td>
                                    <td><?php echo htmlspecialchars($payment['payer_name'] ?? 'Parent/Guardian'); ?></td>
                                    <td>
                                        <a href="feesreceipt.php?id=<?php echo $payment['feespayment_id']; ?>" 
                                           class="btn btn-xs btn-primary" target="_blank">
                                            <i class="fa fa-print"></i> Receipt
                                        </a>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                        <?php } else { ?>
                        <div class="alert alert-warning">
                            <i class="fa fa-exclamation-triangle"></i> No payments recorded for this term yet.
                        </div>
                        <?php } ?>
                        
                    </div>
                </section>
                <?php
            }
        }
        ?>
        
    </div>
</div>
</section>

</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script src="js/scripts.js"></script>

<script>
function recalculateFees(studentId) {
    if (confirm('Recalculate all fees and discounts for this student?')) {
        $.ajax({
            url: 'ajax/recalculate_student_fees.php',
            type: 'POST',
            data: { student_id: studentId },
            success: function(response) {
                alert('Fees recalculated successfully!');
                location.reload();
            },
            error: function() {
                alert('Error recalculating fees. Please try again.');
            }
        });
    }
}
</script>

</body>
</html>
