<?php
include 'includes/conn.php';
include 'includes/roles.php';

// Allow teachers, staff, and financial users to request
if (!in_array($_SESSION['schoolsyslevel'], [1, 2, 3, 7, 8, 9])) {
    header('Location:login.php');
    exit();
}

$status_filter = $_GET['status'] ?? '';
$user_id = $_SESSION['user_id'] ?? 0;

// Determine if user is finance/admin
$is_approver = hasFinancialAccess($_SESSION['schoolsyslevel']);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Stock Requisitions</title>
    <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title">
                            <i class="fa fa-list"></i> Stock Requisitions
                        </h4>
                    </header>
                    <div class="panel-body">
                        <?php
                        if (isset($_SESSION['message'])) {
                            echo '<div class="alert alert-' . (isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info') . ' alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    ' . htmlspecialchars($_SESSION['message']) . '
                                 </div>';
                            unset($_SESSION['message']);
                            unset($_SESSION['msg_type']);
                        }
                        ?>
                        
                        <a href="#addRequisitionModal" data-toggle="modal" class="btn btn-primary btn-sm margin-bottom-10">
                            <i class="fa fa-plus"></i> New Requisition
                        </a>
                        
                        <!-- Status Filter -->
                        <div class="margin-bottom-20">
                            <span class="label label-primary">Filter:</span>
                            <a href="stockrequisitions.php" class="btn btn-default btn-sm">All</a>
                            <a href="stockrequisitions.php?status=Pending" class="btn btn-default btn-sm">Pending</a>
                            <a href="stockrequisitions.php?status=Approved" class="btn btn-success btn-sm">Approved</a>
                            <a href="stockrequisitions.php?status=Fulfilled" class="btn btn-info btn-sm">Fulfilled</a>
                            <a href="stockrequisitions.php?status=Rejected" class="btn btn-danger btn-sm">Rejected</a>
                        </div>
                        
                        <table class="display table table-striped" id="dynamic-table">
                            <thead>
                                <tr>
                                    <th>Requisition #</th>
                                    <th>Requested By</th>
                                    <th>Date Requested</th>
                                    <th>Items</th>
                                    <th>Purpose</th>
                                    <th>Status</th>
                                    <th>Approval Info</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query = "SELECT sr.*, u.username as requester, a.username as approver 
                                         FROM stock_requisitions sr 
                                         LEFT JOIN users u ON sr.requested_by = u.user_id
                                         LEFT JOIN users a ON sr.approved_by = a.user_id
                                         WHERE 1=1";
                                
                                // If not an approver, only show own requisitions
                                if (!$is_approver) {
                                    $query .= " AND sr.requested_by = $user_id";
                                }
                                
                                if ($status_filter) {
                                    $status_filter = mysqli_real_escape_string($con, $status_filter);
                                    $query .= " AND sr.approval_status = '$status_filter'";
                                }
                                
                                $query .= " ORDER BY sr.requested_date DESC";
                                
                                $result = mysqli_query($con, $query);
                                if ($result && mysqli_num_rows($result) > 0) {
                                    while ($row = mysqli_fetch_array($result)) {
                                        $status_class = 'label-warning';
                                        if ($row['approval_status'] == 'Approved') $status_class = 'label-success';
                                        elseif ($row['approval_status'] == 'Fulfilled') $status_class = 'label-info';
                                        elseif ($row['approval_status'] == 'Rejected') $status_class = 'label-danger';
                                        
                                        $approval_info = '-';
                                        if ($row['approver']) {
                                            $approval_info = htmlspecialchars($row['approver']);
                                            if ($row['approval_date']) {
                                                $approval_info .= '<br><small>' . date('d/M/Y', strtotime($row['approval_date'])) . '</small>';
                                            }
                                        }
                                        
                                        echo '<tr>
                                            <td><strong>' . htmlspecialchars($row['requisition_number']) . '</strong></td>
                                            <td>' . htmlspecialchars($row['requester'] ?? '-') . '</td>
                                            <td>' . ($row['requested_date'] ? date('d/M/Y', strtotime($row['requested_date'])) : '-') . '</td>
                                            <td>' . $row['total_items'] . ' items</td>
                                            <td>' . htmlspecialchars(substr($row['purpose'] ?? '', 0, 50)) . '...</td>
                                            <td><span class="label ' . $status_class . '">' . htmlspecialchars($row['approval_status']) . '</span></td>
                                            <td>' . $approval_info . '</td>
                                            <td>
                                                <a href="viewstockrequisition.php?id=' . $row['requisition_id'] . '" class="btn btn-info btn-xs"><i class="fa fa-eye"></i> View</a>';
                                        
                                        if ($row['approval_status'] == 'Pending' && $is_approver) {
                                            echo '<a href="approverequisition.php?id=' . $row['requisition_id'] . '" class="btn btn-success btn-xs"><i class="fa fa-check"></i> Approve</a>';
                                            echo '<a href="rejectrequisition.php?id=' . $row['requisition_id'] . '" class="btn btn-danger btn-xs"><i class="fa fa-times"></i> Reject</a>';
                                        }
                                        
                                        echo '</td>
                                        </tr>';
                                    }
                                } else {
                                    echo '<tr><td colspan="8" class="text-center">No requisitions found</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>

    <!-- Add Requisition Modal -->
    <div id="addRequisitionModal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="create_stock_requisition.php" method="post">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title">New Stock Requisition</h4>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Purpose</label>
                            <textarea name="purpose" class="form-control" rows="3" required></textarea>
                        </div>
                        <div class="form-group">
                            <label>Total Items</label>
                            <input type="number" name="total_items" class="form-control" min="1" value="1" required />
                        </div>
                        <div class="form-group">
                            <label>Items (optional) — plain lines or JSON</label>
                            <textarea name="requisition_items" class="form-control" rows="4" placeholder='One item per line, e.g. "Pens x 2" or "123:4" (item_id:qty)'></textarea>
                            <small class="text-muted">Enter one item per line (examples: <code>Pens x 2</code>, <code>Notebook - 3</code>, <code>123:4</code>) or paste a JSON array. The system will parse it for you.</small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Create Requisition</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
