<?php
include 'includes/conn.php';
include 'includes/roles.php';

if (!hasFinancialAccess($_SESSION['schoolsyslevel']) && $_SESSION['schoolsyslevel'] != 7) {
    header('Location:login.php');
    exit();
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Stock Management</title>
    <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title">
                            <i class="fa fa-inbox"></i> Stock Management
                        </h4>
                    </header>
                    <div class="panel-body">
                        <?php
                        if (isset($_SESSION['message'])) {
                            echo '<div class="alert alert-' . (isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info') . ' alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    ' . htmlspecialchars($_SESSION['message']) . '
                                 </div>';
                            unset($_SESSION['message']);
                            unset($_SESSION['msg_type']);
                        }
                        ?>
                        
                        <a href="stockrequisitions.php" class="btn btn-primary btn-sm margin-bottom-10">
                            <i class="fa fa-plus"></i> View Requisitions
                        </a>
                        <a href="monthlystockreport.php" class="btn btn-success btn-sm margin-bottom-10">
                            <i class="fa fa-calendar"></i> Monthly Report
                        </a>
                        
                        <table class="display table table-striped" id="dynamic-table">
                            <thead>
                                <tr>
                                    <th>Item Name</th>
                                    <th>Item Code</th>
                                    <th>Stock In</th>
                                    <th>Stock Out</th>
                                    <th>Current Stock</th>
                                    <th>Reorder Level</th>
                                    <th>Status</th>
                                    <th>Last Updated</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                // Ensure the `items` table exists to avoid fatal errors on missing schema
                                $items_table_exists = false;
                                $check = mysqli_query($con, "SELECT COUNT(*) AS cnt FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = 'items'");
                                if ($check) {
                                    $chkrow = mysqli_fetch_assoc($check);
                                    if (!empty($chkrow['cnt'])) {
                                        $items_table_exists = (int)$chkrow['cnt'] > 0;
                                    }
                                }

                                if ($items_table_exists) {
                                    $query = "SELECT sm.*, i.item_name, i.item_code 
                                             FROM stock_management sm 
                                             LEFT JOIN items i ON sm.item_id = i.item_id 
                                             WHERE i.status = 1
                                             ORDER BY sm.updated_at DESC";

                                    $result = mysqli_query($con, $query);
                                    if ($result && mysqli_num_rows($result) > 0) {
                                        while ($row = mysqli_fetch_array($result)) {
                                        $status_class = 'label-success';
                                        $status_text = 'OK';
                                        
                                        if ($row['current_stock'] <= $row['reorder_level']) {
                                            $status_class = 'label-danger';
                                            $status_text = 'LOW STOCK';
                                        } elseif ($row['current_stock'] <= ($row['reorder_level'] * 1.5)) {
                                            $status_class = 'label-warning';
                                            $status_text = 'REORDER SOON';
                                        }
                                        
                                        echo '<tr>
                                            <td>' . htmlspecialchars($row['item_name'] ?? '-') . '</td>
                                            <td>' . htmlspecialchars($row['item_code'] ?? '-') . '</td>
                                            <td>' . intval($row['stock_in']) . '</td>
                                            <td>' . intval($row['stock_out']) . '</td>
                                            <td><strong>' . intval($row['current_stock']) . '</strong></td>
                                            <td>' . intval($row['reorder_level']) . '</td>
                                            <td><span class="label ' . $status_class . '">' . $status_text . '</span></td>
                                            <td>' . ($row['status_date'] ? date('d/M/Y', strtotime($row['status_date'])) : '-') . '</td>
                                            <td>
                                                <a href="editstock.php?id=' . $row['stock_id'] . '" class="btn btn-info btn-xs"><i class="fa fa-edit"></i> Edit</a>
                                                <a href="stockhistory.php?id=' . $row['stock_id'] . '" class="btn btn-success btn-xs"><i class="fa fa-history"></i> History</a>
                                            </td>
                                        </tr>';
                                        }
                                    } else {
                                        echo '<tr><td colspan="9" class="text-center">No stock records found</td></tr>';
                                    }
                                } else {
                                    echo '<tr><td colspan="9" class="text-center">No <strong>items</strong> in this table</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
