<?php
include 'includes/conn.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
// Allow Super Admin (1), Principal (2), HR Admin Director (9)
if ($user_level === 0 || !in_array($user_level, [1,2,9], true)) {
  header('Location: login.php');
  exit;
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Staff Members</title>
  <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'includes/header.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">

        <div class="col-lg-12">
          <section class="panel">
            <header class="panel-heading">
              Administrative Staff Members
            </header>
            <div class="panel-body">
              <table class="display table  table-striped" id="dynamic-table">
                <thead>
                  <tr>
                    <th>Image</th>
                    <th>Full Names</th>
                    <th>Designation</th>
                    <th>Gender</th>
                    <th>Phone</th>
                    <?php if (isset($_SESSION['schoolsyslevel']) && $_SESSION['schoolsyslevel'] == 1) { ?>
                      <th>Action</th>
                    <?php } ?>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $getstaff = mysqli_query($con, "SELECT * FROM staff WHERE status=1");
                  if ($getstaff) {
                    while ($row = mysqli_fetch_assoc($getstaff)) {
                      $staff_id = (int)($row['staff_id'] ?? 0);
                      $fullname = $row['fullname'] ?? '';
                      $phone = $row['phone'] ?? '';
                      $email = $row['email'] ?? '';
                      $gender = $row['gender'] ?? '';
                      $design = $row['designation'] ?? '';
                      $status = (int)($row['status'] ?? 0);
                      $ext = $row['ext'] ?? '';
                  ?>

                    <tr class="gradeA">
                      <td>
                        <?php if (empty($ext)) { ?>
                          <img src="images/avatar.png" width="80" alt="avatar">
                        <?php } else { ?>
                          <img src="<?php echo htmlspecialchars('images/nonteaching/thumbs/' . md5($staff_id) . '.' . $ext . '?' . time()); ?>" width="80" alt="<?php echo htmlspecialchars($fullname); ?>">
                        <?php } ?>
                      </td>
                      <td><?php echo htmlspecialchars($fullname); ?></td>
                      <td><?php echo htmlspecialchars($design); ?></td>
                      <td><?php echo htmlspecialchars($gender); ?></td>
                      <td><?php echo htmlspecialchars($phone); ?></td>
                      <?php if (isset($_SESSION['schoolsyslevel']) && $_SESSION['schoolsyslevel'] == 1) { ?>
                        <td>
                          <a href="edit_staff?id=<?php echo $staff_id; ?>" class="btn btn-warning btn-xs"><i class="fa fa-edit"></i>Edit</a>
                          <a href="hidestaff?id=<?php echo $staff_id; ?>" class="btn btn-danger btn-xs" onclick="return confirm_delete<?php echo $staff_id; ?>()"><i class="fa fa-times"></i> Remove</a>
                          <script type="text/javascript">
                            function confirm_delete<?php echo $staff_id; ?>() {
                              return confirm('You are about To Remove this Teacher. Are you sure you want to proceed?');
                            }
                          </script>
                        </td>
                      <?php } ?>

                    </tr>
                  <?php }
                  }
                  ?>
                </tbody>
              </table>
            </div>
        </div>

      </div>