-- ============================================================================
-- SAMPLE DATA FOR FAMILY DISCOUNT & ACCOUNTING TABLES
-- Safe to rerun: uses INSERT IGNORE to avoid duplicates
-- Adjust IDs to match your environment (student_id, term_id, class_id)
-- ============================================================================

-- Families
INSERT IGNORE INTO families (family_id, family_name, primary_contact_name, primary_contact_phone, primary_contact_email, total_students, discount_eligible_count, status)
VALUES
  (101, 'The Okello Family', 'Grace Okello', '0700123456', 'grace.okello@example.com', 3, 3, 1),
  (102, 'The Mwangi Family', 'Peter Mwangi', '0711223344', 'peter.mwangi@example.com', 2, 2, 1),
  (103, 'The Achieng Family', 'Linet Achieng', '0722334455', 'linet.achieng@example.com', 1, 1, 1);

-- Term dates (adjust term_id to your financialterms table)
INSERT IGNORE INTO term_important_dates (term_id, term_start_date, term_end_date, half_term_date, late_penalty_start_date, early_payment_deadline, status)
VALUES
  (1, '2025-01-10', '2025-04-05', '2025-02-21', '2025-02-28', '2025-01-09', 1),
  (2, '2025-05-06', '2025-08-02', '2025-06-20', '2025-06-27', '2025-05-05', 1),
  (3, '2025-09-01', '2025-12-05', '2025-10-17', '2025-10-24', '2025-08-31', 1);

-- Student fee calculations (adjust student_id, class_id to match your data)
INSERT IGNORE INTO student_fee_calculations (
    calculation_id, student_id, term_id, class_id, base_fee_amount,
    sibling_discount_percentage, sibling_discount_amount,
    early_payment_discount, late_payment_penalty, other_discounts,
    total_discounts, total_penalties, final_fee_amount, total_paid,
    balance, overpayment, payment_status, is_nursery_student,
    is_new_student, family_id, sibling_position, status
) VALUES
  (201, 1, 1, 1, 50000, 0,     0,   2500,    0,    0,   2500, 0, 47500, 20000, 27500, 0, 'Partial', 0, 0, 101, 1, 1),
  (202, 2, 1, 1, 50000, 10.00, 5000, 0,       0,    0,   5000, 0, 45000, 45000,     0, 0, 'Paid',    0, 0, 101, 2, 1),
  (203, 3, 1, 2, 52000, 20.00, 10400,0,       0,    0,  10400, 0, 41600, 50000,     0, 8400, 'Overpaid',0,0,101,3,1),
  (204, 4, 1, 1, 50000, 10.00, 5000, 0,       0,    0,   5000, 0, 45000, 10000, 35000, 0, 'Partial', 0, 1, 102, 2,1),
  (205, 5, 1, 3, 48000,  0,     0,   0,     2400,   0,   2400,2400, 48000,  5000, 43000,0, 'Unpaid',  0, 0, 103, 1,1);

-- Payment adjustments (link to above students/terms)
INSERT IGNORE INTO payment_adjustments (
    adjustment_id, student_id, term_id, adjustment_type, percentage, amount,
    base_fee_amount, adjusted_amount, reason, payment_date,
    term_start_date, half_term_date, is_new_student, applied_by, status
) VALUES
  (301, 1, 1, 'Early Payment Discount', 5.00, 2500, 50000, 47500, 'Paid before term start', '2025-01-05', '2025-01-10', '2025-02-21', 0, 1, 1),
  (302, 3, 1, 'Sibling Discount',      20.00,10400, 52000, 41600, '3rd child discount',      NULL,        '2025-01-10', '2025-02-21', 0, 1, 1),
  (303, 5, 1, 'Late Payment Penalty',   5.00, 2400, 48000, 50400, 'Paid after half-term + 1 week', '2025-03-10', '2025-01-10', '2025-02-21', 0, 1, 1);

-- Payment bank details (example mappings to bank_accounts/payment_methods)
-- Adjust bank_account_id/payment_method_id to match your environment
INSERT IGNORE INTO payment_bank_details (
    payment_bank_id, feespayment_id, student_id, bank_account_id, bank_transaction_id,
    payment_method_id, transaction_reference, payer_name, payer_phone,
    payment_date, amount, reconciled, reconciled_by, status
) VALUES
  (401, 1001, 1, 1, NULL, 1, 'BT-REF-001', 'Grace Okello', '0700123456', '2025-01-05', 20000, 0, NULL, 1),
  (402, 1002, 2, 1, NULL, 3, 'CASH-002',  'Grace Okello', '0700123456', '2025-01-12', 45000, 0, NULL, 1),
  (403, 1003, 3, 2, NULL, 4, 'MPESA-003', 'Grace Okello', '0700123456', '2025-01-15', 50000, 0, NULL, 1),
  (404, 1004, 4, 1, NULL, 2, 'CHK-004',   'Peter Mwangi', '0711223344', '2025-02-01', 10000, 0, NULL, 1),
  (405, 1005, 5, 1, NULL, 4, 'MPESA-005', 'Linet Achieng','0722334455', '2025-03-10',  5000, 0, NULL, 1);

-- Optional: seed a few bank accounts if empty
INSERT IGNORE INTO bank_accounts (bank_account_id, bank_name, account_number, account_holder, branch, currency, account_type, balance, status)
VALUES
  (1, 'Equity Bank', '1234567890', 'The King\'s School', 'Nairobi Main', 'KES', 'Current', 1500000, 1),
  (2, 'KCB Bank',    '9876543210', 'The King\'s School', 'Westlands',   'KES', 'Current',  800000, 1);

-- Optional: seed payment methods if missing (non-conflicting with existing codes)
INSERT IGNORE INTO payment_methods (payment_method_id, method_name, method_code, description, status) VALUES
  (101, 'Mobile Money (Alt)', 'MOMO_ALT', 'Alt M-Pesa channel', 1),
  (102, 'POS Card',           'POS_CARD', 'POS card swipe',     1);

-- ============================================================================
-- END OF SAMPLE DATA
-- ============================================================================
