<?php
/**
 * Migrate staffattendance.date from INT timestamp to DATE format
 */

$con = mysqli_connect('localhost', 'root', '', 'school_sys_db');

if (mysqli_connect_errno()) {
    die('Connection failed: ' . mysqli_connect_error() . PHP_EOL);
}

echo 'Connected to database...' . PHP_EOL;

try {
    // Check if table exists
    $result = mysqli_query($con, "SHOW TABLES LIKE 'staffattendance'");
    if (mysqli_num_rows($result) == 0) {
        echo 'staffattendance table does not exist. Skipping.' . PHP_EOL;
        exit(0);
    }
    
    // Step 1: Create backup column (if not exists)
    echo 'Step 1: Checking backup column...' . PHP_EOL;
    $result = mysqli_query($con, "SHOW COLUMNS FROM staffattendance LIKE 'date_backup'");
    if (mysqli_num_rows($result) == 0) {
        echo '  - Creating backup column...' . PHP_EOL;
        if (!mysqli_query($con, 'ALTER TABLE staffattendance ADD COLUMN date_backup INT(11) AFTER date')) {
            throw new Exception('Error creating backup: ' . mysqli_error($con));
        }
        echo '  - Backup column created' . PHP_EOL;
    } else {
        echo '  - Backup column already exists' . PHP_EOL;
    }
    
    // Step 2: Copy to backup
    echo 'Step 2: Copying data to backup...' . PHP_EOL;
    mysqli_query($con, 'UPDATE staffattendance SET date_backup = date WHERE date_backup IS NULL OR date_backup = 0');
    echo '  - Data copied: ' . mysqli_affected_rows($con) . ' rows' . PHP_EOL;
    
    // Step 3: Create new DATE column (if not exists)
    echo 'Step 3: Checking new DATE column...' . PHP_EOL;
    $result = mysqli_query($con, "SHOW COLUMNS FROM staffattendance LIKE 'date_new'");
    if (mysqli_num_rows($result) == 0) {
        echo '  - Creating new DATE column...' . PHP_EOL;
        if (!mysqli_query($con, 'ALTER TABLE staffattendance ADD COLUMN date_new DATE AFTER date')) {
            throw new Exception('Error creating date_new: ' . mysqli_error($con));
        }
        echo '  - DATE column created' . PHP_EOL;
    } else {
        echo '  - date_new column already exists' . PHP_EOL;
    }
    
    // Step 4: Convert timestamps
    echo 'Step 4: Converting timestamps to dates...' . PHP_EOL;
    mysqli_query($con, 'UPDATE staffattendance SET date_new = FROM_UNIXTIME(date_backup, "%Y-%m-%d") WHERE date_backup > 0');
    echo '  - Rows converted: ' . mysqli_affected_rows($con) . PHP_EOL;
    
    // Step 5: Drop old column (check if date_new exists first)
    echo 'Step 5: Checking if ready to drop old column...' . PHP_EOL;
    $result = mysqli_query($con, "SHOW COLUMNS FROM staffattendance LIKE 'date'");
    $has_old_date = mysqli_num_rows($result) > 0;
    $result = mysqli_query($con, "SHOW COLUMNS FROM staffattendance LIKE 'date_new'");
    $has_new_date = mysqli_num_rows($result) > 0;
    
    if ($has_old_date && $has_new_date) {
        echo '  - Dropping old date column...' . PHP_EOL;
        if (!mysqli_query($con, 'ALTER TABLE staffattendance DROP COLUMN date')) {
            throw new Exception('Error dropping old date: ' . mysqli_error($con));
        }
        echo '  - Old column dropped' . PHP_EOL;
    } else {
        echo '  - Old date column already processed' . PHP_EOL;
    }
    
    // Step 6: Rename new column
    echo 'Step 6: Renaming date_new to date...' . PHP_EOL;
    if (!mysqli_query($con, 'ALTER TABLE staffattendance CHANGE COLUMN date_new date DATE NOT NULL')) {
        throw new Exception('Error: ' . mysqli_error($con));
    }
    echo '  - Column renamed' . PHP_EOL;
    
    echo PHP_EOL . '✓ Migration complete!' . PHP_EOL . PHP_EOL;
    
    // Verify
    echo 'Verifying conversion (first 5 rows):' . PHP_EOL;
    $verify = mysqli_query($con, 'SELECT date, date_backup, FROM_UNIXTIME(date_backup, "%Y-%m-%d") as converted FROM staffattendance LIMIT 5');
    if ($verify && mysqli_num_rows($verify) > 0) {
        while ($row = mysqli_fetch_assoc($verify)) {
            echo '  Date: ' . $row['date'] . ' | Backup: ' . $row['date_backup'] . ' | Converted: ' . $row['converted'] . PHP_EOL;
        }
    } else {
        echo '  - No data to verify' . PHP_EOL;
    }
    
    echo PHP_EOL . 'After verification, you can drop the backup column with:' . PHP_EOL;
    echo '  ALTER TABLE staffattendance DROP COLUMN date_backup;' . PHP_EOL;
    
} catch (Exception $e) {
    echo PHP_EOL . '✗ Migration failed: ' . $e->getMessage() . PHP_EOL;
    exit(1);
}

mysqli_close($con);
