-- Fix existing marks that have rank_id stored instead of rank value
-- This updates the marks.rank column to contain the actual rank value from the ranks table

-- First, check which marks need updating (rank values that match rank_id from ranks table)
-- Run this to see what will be updated:
-- SELECT m.mark_id, m.marks, m.rank AS current_rank, r.rank AS correct_rank, m.student_id
-- FROM marks m
-- INNER JOIN ranks r ON m.rank = r.rank_id
-- WHERE m.rank IN (SELECT rank_id FROM ranks WHERE status = 1)
-- LIMIT 20;

-- Update marks to use correct rank values
UPDATE marks m
INNER JOIN ranks r ON m.rank = r.rank_id
SET m.rank = r.rank
WHERE m.rank IN (SELECT rank_id FROM ranks WHERE status = 1)
  AND CAST(m.rank AS UNSIGNED) < 20;  -- Safety check: only update if rank is small number (likely an ID)

-- After running this, verify the fix:
-- SELECT m.mark_id, m.marks, m.rank, s.fullname
-- FROM marks m
-- INNER JOIN students s ON m.student_id = s.student_id
-- WHERE m.term_id = 11 AND m.class_id = 2 AND m.subject_id = 3
-- LIMIT 10;

