SET FOREIGN_KEY_CHECKS=0;

-- Timetable: class schedule entries (one row per timeslot)
CREATE TABLE IF NOT EXISTS `timetables` (
  `timetable_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `class_id` INT UNSIGNED NOT NULL,
  `stream_id` INT UNSIGNED DEFAULT 0,
  `day_of_week` TINYINT UNSIGNED NOT NULL COMMENT '1=Monday..7=Sunday',
  `start_time` TIME NOT NULL,
  `end_time` TIME NOT NULL,
  `subject_id` INT UNSIGNED DEFAULT NULL,
  `teacher_id` INT UNSIGNED DEFAULT NULL,
  `room` VARCHAR(100) DEFAULT NULL,
  `term_id` INT UNSIGNED DEFAULT NULL,
  `status` TINYINT(1) NOT NULL DEFAULT 1,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`timetable_id`),
  INDEX `idx_timetable_class` (`class_id`,`stream_id`),
  INDEX `idx_timetable_day` (`day_of_week`),
  INDEX `idx_timetable_term` (`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Weekly plans: teacher weekly lesson plans per class/subject
CREATE TABLE IF NOT EXISTS `weekly_plans` (
  `plan_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `teacher_id` INT UNSIGNED NOT NULL,
  `class_id` INT UNSIGNED NOT NULL,
  `subject_id` INT UNSIGNED DEFAULT NULL,
  `week_start` DATE NOT NULL,
  `week_end` DATE NOT NULL,
  `term_id` INT UNSIGNED DEFAULT NULL,
  `content` TEXT DEFAULT NULL,
  `attachments` TEXT DEFAULT NULL COMMENT 'JSON array of filenames or attachment metadata',
  `status` TINYINT(1) NOT NULL DEFAULT 1,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`plan_id`),
  UNIQUE KEY `unq_week_plan` (`teacher_id`,`class_id`,`subject_id`,`week_start`),
  INDEX `idx_week_plan_class` (`class_id`),
  INDEX `idx_week_plan_teacher` (`teacher_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Long term plans: higher-level planning for a term or academic year
CREATE TABLE IF NOT EXISTS `longterm_plans` (
  `ltp_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `teacher_id` INT UNSIGNED DEFAULT NULL,
  `class_id` INT UNSIGNED DEFAULT NULL,
  `subject_id` INT UNSIGNED DEFAULT NULL,
  `title` VARCHAR(255) DEFAULT NULL,
  `description` TEXT DEFAULT NULL,
  `term_id` INT UNSIGNED DEFAULT NULL,
  `start_date` DATE DEFAULT NULL,
  `end_date` DATE DEFAULT NULL,
  `status` TINYINT(1) NOT NULL DEFAULT 1,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ltp_id`),
  INDEX `idx_ltp_class` (`class_id`),
  INDEX `idx_ltp_teacher` (`teacher_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Midterm plans: focused plans for a midterm period
CREATE TABLE IF NOT EXISTS `midterm_plans` (
  `midterm_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `teacher_id` INT UNSIGNED DEFAULT NULL,
  `class_id` INT UNSIGNED DEFAULT NULL,
  `subject_id` INT UNSIGNED DEFAULT NULL,
  `title` VARCHAR(255) DEFAULT NULL,
  `content` TEXT DEFAULT NULL,
  `term_id` INT UNSIGNED DEFAULT NULL,
  `start_date` DATE DEFAULT NULL,
  `end_date` DATE DEFAULT NULL,
  `status` TINYINT(1) NOT NULL DEFAULT 1,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`midterm_id`),
  INDEX `idx_midterm_class` (`class_id`),
  INDEX `idx_midterm_teacher` (`teacher_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Teacher attendance: daily attendance records for teachers
CREATE TABLE IF NOT EXISTS `teacher_attendance` (
  `attendance_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `teacher_id` INT UNSIGNED NOT NULL,
  `attendance_date` DATE NOT NULL,
  `status` ENUM('present','absent','leave','sick') NOT NULL DEFAULT 'present',
  `in_time` TIME DEFAULT NULL,
  `out_time` TIME DEFAULT NULL,
  `notes` TEXT DEFAULT NULL,
  `recorded_by` INT UNSIGNED DEFAULT NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `unq_teacher_date` (`teacher_id`,`attendance_date`),
  INDEX `idx_teacher_date` (`teacher_id`,`attendance_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Marks: student assessment entries (supports multiple assessments/papers)
CREATE TABLE IF NOT EXISTS `marks` (
  `mark_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `student_id` INT UNSIGNED NOT NULL,
  `class_id` INT UNSIGNED NOT NULL,
  `subject_id` INT UNSIGNED NOT NULL,
  `term_id` INT UNSIGNED NOT NULL,
  `assessment` TINYINT UNSIGNED NOT NULL DEFAULT 2 COMMENT '1=classwork,2=exam, etc',
  `paper_id` INT UNSIGNED DEFAULT NULL,
  `marks` DECIMAL(6,2) DEFAULT NULL,
  `rank` INT UNSIGNED DEFAULT NULL COMMENT 'max marks or full score',
  `effort_id` INT UNSIGNED DEFAULT NULL,
  `status` TINYINT(1) NOT NULL DEFAULT 1,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`mark_id`),
  UNIQUE KEY `unq_student_subject_term_assessment_paper` (`student_id`,`subject_id`,`term_id`,`assessment`,`paper_id`),
  INDEX `idx_marks_student` (`student_id`),
  INDEX `idx_marks_class` (`class_id`),
  INDEX `idx_marks_subject` (`subject_id`),
  INDEX `idx_marks_term` (`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

SET FOREIGN_KEY_CHECKS=1;

-- Compatibility table for older code that expects `weeklyplans` (legacy schema)
CREATE TABLE IF NOT EXISTS `weeklyplans` (
  `weeklyplan_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `class_sub_id` INT UNSIGNED NOT NULL,
  `teacher_id` INT UNSIGNED NOT NULL,
  `startdate` BIGINT UNSIGNED NOT NULL COMMENT 'UNIX timestamp (legacy)',
  `enddate` BIGINT UNSIGNED NOT NULL COMMENT 'UNIX timestamp (legacy)',
  `bookpages` TEXT DEFAULT NULL,
  `periodsperweek` INT UNSIGNED DEFAULT 0,
  `year` VARCHAR(10) DEFAULT NULL,
  `term` INT UNSIGNED DEFAULT NULL,
  `weeklyplandoc` VARCHAR(255) DEFAULT NULL,
  `timestamp` VARCHAR(50) DEFAULT NULL,
  `status` TINYINT(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`weeklyplan_id`),
  INDEX `idx_weeklyplans_classsub` (`class_sub_id`),
  INDEX `idx_weeklyplans_teacher` (`teacher_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

