-- CREATE TABLE for substitutions (safe schema, no foreign key constraints to avoid migration issues)
CREATE TABLE IF NOT EXISTS `substitutions` (
  `substitution_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `date` DATE NOT NULL,
  `starttime` TIME DEFAULT NULL,
  `endtime` TIME DEFAULT NULL,
  `class_id` INT UNSIGNED DEFAULT NULL,
  `stream_id` INT UNSIGNED DEFAULT NULL,
  `class_sub_id` INT UNSIGNED DEFAULT NULL,
  `original_teacher_id` INT UNSIGNED DEFAULT NULL,
  `substitute_teacher_id` INT UNSIGNED DEFAULT NULL,
  `created_by` INT UNSIGNED DEFAULT NULL,
  `status` TINYINT(1) NOT NULL DEFAULT 1,
  `notes` TEXT,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`substitution_id`),
  KEY (`class_id`),
  KEY (`stream_id`),
  KEY (`class_sub_id`),
  KEY (`original_teacher_id`),
  KEY (`substitute_teacher_id`)
  ,KEY (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
