CREATE TABLE IF NOT EXISTS `salary` (
  `salary_id` INT(11) NOT NULL AUTO_INCREMENT,
  `employee_id` INT(11) NOT NULL,
  `type` TINYINT(1) NOT NULL DEFAULT 1, -- 1 = staff, 0 = guard
  `salary` DECIMAL(15,2) DEFAULT 0.00,
  `bonus` DECIMAL(15,2) DEFAULT 0.00,
  `deduction` DECIMAL(15,2) DEFAULT 0.00,
  `nssf` DECIMAL(15,2) DEFAULT 0.00,
  `payee` DECIMAL(15,2) DEFAULT 0.00,
  `lapf` DECIMAL(15,2) DEFAULT 0.00,
  `loan` DECIMAL(15,2) DEFAULT 0.00,
  `welfare` DECIMAL(15,2) DEFAULT 0.00,
  `year` INT(4) DEFAULT NULL,
  `month` INT(2) DEFAULT NULL,
  `date` INT(11) DEFAULT NULL, -- unix timestamp used by code
  `status` TINYINT(2) DEFAULT 1,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`salary_id`),
  INDEX `idx_employee` (`employee_id`),
  INDEX `idx_period` (`month`,`year`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;