-- 1) Preview rows that look numeric (9-10 digit UNIX timestamps)
SELECT weeklyplan_id, startdate, FROM_UNIXTIME(startdate) AS start_human, enddate, FROM_UNIXTIME(enddate) AS end_human
FROM weeklyplans
WHERE (startdate REGEXP '^[0-9]{9,10}$' OR enddate REGEXP '^[0-9]{9,10}$')
LIMIT 100;

-- 2) More conservative preview (any numeric string)
SELECT weeklyplan_id, startdate, FROM_UNIXTIME(startdate) AS start_human, enddate, FROM_UNIXTIME(enddate) AS end_human
FROM weeklyplans
WHERE (startdate REGEXP '^[0-9]+$' OR enddate REGEXP '^[0-9]+$')
LIMIT 100;

-- 3) If the preview looks correct, convert numeric UNIX timestamps to YYYY-MM-DD strings (use the conservative 9-10 digit filter).
-- Run these inside a transaction if your storage engine supports it (InnoDB): START TRANSACTION; ... COMMIT;

START TRANSACTION;
UPDATE weeklyplans
SET startdate = FROM_UNIXTIME(startdate, '%Y-%m-%d')
WHERE startdate REGEXP '^[0-9]{9,10}$';

UPDATE weeklyplans
SET enddate = FROM_UNIXTIME(enddate, '%Y-%m-%d')
WHERE enddate REGEXP '^[0-9]{9,10}$';
COMMIT;

-- 4) Quick sanity check after conversion
SELECT COUNT(*) AS total_rows, 
SUM(startdate REGEXP '^[0-9]{4}-[0-9]{2}-[0-9]{2}$') AS startdate_converted,
SUM(enddate REGEXP '^[0-9]{4}-[0-9]{2}-[0-9]{2}$') AS enddate_converted
FROM weeklyplans;

