-- Convert teacherattendance.date from timestamp to DATE format
-- IMPORTANT: Run these commands one at a time and verify each step!

-- Step 1: Create a temporary backup column
ALTER TABLE teacherattendance ADD COLUMN date_backup INT(11) AFTER date;

-- Step 2: Copy existing timestamp values to backup
UPDATE teacherattendance SET date_backup = date;

-- Step 3: Add a new temporary DATE column
ALTER TABLE teacherattendance ADD COLUMN date_new DATE AFTER date;

-- Step 4: Convert timestamps to DATE format in the new column
UPDATE teacherattendance SET date_new = FROM_UNIXTIME(date_backup, '%Y-%m-%d') WHERE date_backup > 0;

-- Step 5: Drop the old INT date column
ALTER TABLE teacherattendance DROP COLUMN date;

-- Step 6: Rename the new DATE column to 'date'
ALTER TABLE teacherattendance CHANGE COLUMN date_new date DATE NOT NULL;

-- Step 7: Verify the conversion worked
-- SELECT date, date_backup, FROM_UNIXTIME(date_backup, '%Y-%m-%d') as converted FROM teacherattendance LIMIT 10;

-- Step 8: After verification, you can drop the backup column:
-- ALTER TABLE teacherattendance DROP COLUMN date_backup;

-- Note: Keep the backup column until you've verified everything works correctly!
