-- Add `salary` columns to `staff` and `guards` tables (safe defaults)
-- Run this in your `kingschool` database. If your MySQL version supports
-- `ADD COLUMN IF NOT EXISTS` (MySQL 8.0.16+), the statements below will work.

ALTER TABLE `staff` ADD COLUMN IF NOT EXISTS `salary` DECIMAL(10,2) NOT NULL DEFAULT 0;
ALTER TABLE `guards` ADD COLUMN IF NOT EXISTS `salary` DECIMAL(10,2) NOT NULL DEFAULT 0;

-- If your MySQL version does not support `IF NOT EXISTS` for columns,
-- run the following logic in a client (example shown for manual steps):
-- 1) Check INFORMATION_SCHEMA for the column existence:
-- SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
--   WHERE TABLE_SCHEMA = 'kingschool' AND TABLE_NAME = 'staff' AND COLUMN_NAME = 'salary';
-- 2) If count is 0, run:
-- ALTER TABLE `staff` ADD COLUMN `salary` DECIMAL(10,2) NOT NULL DEFAULT 0;
-- Repeat for `guards`.

-- Optional: seed example values (uncomment to run)
-- UPDATE `staff` SET `salary` = 0 WHERE `salary` IS NULL;
-- UPDATE `guards` SET `salary` = 0 WHERE `salary` IS NULL;
