<?php
include 'includes/conn.php';

// Normalize session role level
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);

// Check authorization - same as addsalary.php
if ($user_level === 0 || !in_array($user_level, [1,2,3,8,9,10], true)) {
  header('Location:login.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Select Staff for Salary Payment</title>
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
  <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
</head>
<body class="sticky-header">
  <section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
      <div class="row">
        <div class="col-lg-12">
          <section class="panel">
            <header class="panel-heading">
              Select Staff Member for Salary Payment
            </header>
            <div class="panel-body">
              <div class="alert alert-info">
                <strong>Info:</strong> Click "Add Salary Payment" next to a staff member to record their salary payment.
              </div>
              <table class="display table table-striped" id="dynamic-table">
                <thead>
                  <tr>
                    <th>Staff ID</th>
                    <th>Full Name</th>
                    <th>Role</th>
                    <th>Salary</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  // Defensive checks: detect `staffroles`, `role_id`, `designation`, and `salary` to avoid fatal SQL errors
                  $role_table_exists = false;
                  $tblCheck = @mysqli_query($con, "SHOW TABLES LIKE 'staffroles'");
                  if ($tblCheck && mysqli_num_rows($tblCheck) > 0) {
                    $role_table_exists = true;
                  }

                  $staff_salary_col_exists = false;
                  $colCheck = @mysqli_query($con, "SHOW COLUMNS FROM `staff` LIKE 'salary'");
                  if ($colCheck && mysqli_num_rows($colCheck) > 0) {
                    $staff_salary_col_exists = true;
                  }

                  // Detect whether staff has a numeric role_id to join to staffroles
                  $staff_has_role_id = false;
                  $rcol = @mysqli_query($con, "SHOW COLUMNS FROM `staff` LIKE 'role_id'");
                  if ($rcol && mysqli_num_rows($rcol) > 0) {
                    $staff_has_role_id = true;
                  }

                  // Detect whether staff has a designation text column we can use as role
                  $designation_exists = false;
                  $dcol = @mysqli_query($con, "SHOW COLUMNS FROM `staff` LIKE 'designation'");
                  if ($dcol && mysqli_num_rows($dcol) > 0) {
                    $designation_exists = true;
                  }

                  if ($role_table_exists && $staff_has_role_id) {
                    // Join staffroles to get role name
                    if ($staff_salary_col_exists) {
                      $query = "SELECT s.staff_id, s.fullname, s.salary, sr.role \n                                FROM staff s \n                                LEFT JOIN staffroles sr ON s.role_id = sr.staffrole_id \n                                WHERE s.status = 1 \n                                ORDER BY s.fullname";
                    } else {
                      $query = "SELECT s.staff_id, s.fullname, NULL as salary, sr.role \n                                FROM staff s \n                                LEFT JOIN staffroles sr ON s.role_id = sr.staffrole_id \n                                WHERE s.status = 1 \n                                ORDER BY s.fullname";
                    }
                  } else {
                    // Fallback to using staff.designation if available, otherwise NULL role
                    if ($designation_exists) {
                      if ($staff_salary_col_exists) {
                        $query = "SELECT staff_id, fullname, salary, designation as role FROM staff WHERE status = 1 ORDER BY fullname";
                      } else {
                        $query = "SELECT staff_id, fullname, NULL as salary, designation as role FROM staff WHERE status = 1 ORDER BY fullname";
                      }
                    } else {
                      if ($staff_salary_col_exists) {
                        $query = "SELECT staff_id, fullname, salary, NULL as role FROM staff WHERE status = 1 ORDER BY fullname";
                      } else {
                        $query = "SELECT staff_id, fullname, NULL as salary, NULL as role FROM staff WHERE status = 1 ORDER BY fullname";
                      }
                    }
                  }

                  $result = mysqli_query($con, $query);

                  if ($result && mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_assoc($result)) {
                      $staff_id = (int)($row['staff_id'] ?? 0);
                      $fullname = htmlspecialchars($row['fullname'] ?? '');
                      $role = $row['role'] ?? null;
                      $role = ($role === null || $role === '') ? 'N/A' : htmlspecialchars($role);
                      // normalize salary value even if column missing
                      $salary = number_format((float)($row['salary'] ?? 0));
                  ?>
                    <tr>
                      <td><?php echo $staff_id; ?></td>
                      <td><?php echo $fullname; ?></td>
                      <td><?php echo $role; ?></td>
                      <td><?php echo $salary; ?></td>
                      <td>
                        <a href="addsalary.php?ty=1&id=<?php echo $staff_id; ?>" class="btn btn-primary btn-xs">
                          <i class="fa fa-plus"></i> Add Salary Payment
                        </a>
                      </td>
                    </tr>
                  <?php 
                    }
                  } else {
                    echo '<tr><td></td><td class="text-center">No staff members found</td><td></td><td></td><td></td></tr>';
                  }
                  ?>
                </tbody>
              </table>
            </div>
          </section>
          
          <section class="panel">
            <header class="panel-heading">
              Select Guard for Salary Payment
            </header>
            <div class="panel-body">
              <table class="display table table-striped" id="guards-table">
                <thead>
                  <tr>
                    <th>Guard ID</th>
                    <th>Full Name</th>
                    <th>Salary</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  // Defensive check for guards salary column
                  $guard_salary_col_exists = false;
                  $gcolCheck = @mysqli_query($con, "SHOW COLUMNS FROM `guards` LIKE 'salary'");
                  if ($gcolCheck && mysqli_num_rows($gcolCheck) > 0) {
                    $guard_salary_col_exists = true;
                  }

                  if ($guard_salary_col_exists) {
                    $gquery = "SELECT guard_id, fullname, salary FROM guards WHERE status = 1 ORDER BY fullname";
                  } else {
                    $gquery = "SELECT guard_id, fullname, NULL as salary FROM guards WHERE status = 1 ORDER BY fullname";
                  }

                  $result = mysqli_query($con, $gquery);

                  if ($result && mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_assoc($result)) {
                      $guard_id = (int)($row['guard_id'] ?? 0);
                      $fullname = htmlspecialchars($row['fullname'] ?? '');
                      $salary = number_format((float)($row['salary'] ?? 0));
                  ?>
                    <tr>
                      <td><?php echo $guard_id; ?></td>
                      <td><?php echo $fullname; ?></td>
                      <td><?php echo $salary; ?></td>
                      <td>
                        <a href="addsalary.php?ty=2&id=<?php echo $guard_id; ?>" class="btn btn-primary btn-xs">
                          <i class="fa fa-plus"></i> Add Salary Payment
                        </a>
                      </td>
                    </tr>
                  <?php 
                    }
                  } else {
                    echo '<tr><td></td><td class="text-center">No guards found</td><td></td><td></td></tr>';
                  }
                  ?>
                </tbody>
              </table>
            </div>
          </section>
        </div>
      </div>
    </section>
  </section>

  <script src="js/jquery-1.11.3.min.js"></script>
  <script type="text/javascript" src="js/data-tables/jquery.dataTables.js"></script>
  <script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
  <script>
    $(document).ready(function() {
      $('#dynamic-table').dataTable();
      $('#guards-table').dataTable();
    });
  </script>
</body>
</html>
