<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsyslevel']) || !in_array((int)$_SESSION['schoolsyslevel'], [1,2], true)) {
  header('Location: login.php');
  exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  header('Location: classcategories.php');
  exit;
}

$getcat = mysqli_query($con, "SELECT * FROM classcategories WHERE classcategory_id=" . $id . " LIMIT 1");
$catRow = $getcat ? mysqli_fetch_assoc($getcat) : null;
if (!$catRow) {
  header('Location: classcategories.php');
  exit;
}
$classcat_id = (int) ($catRow['classcategory_id'] ?? 0);
$classcat = $catRow['classcategory'] ?? '';
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title><?php echo $classcat; ?></title>
  <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
  <link href="css/chosen/chosen.css" rel="stylesheet">
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'includes/header.php'; ?>

    <section class="wrapper">
      <div class="row">
        <div class="col-lg-5">
          <section class="panel">
            <header class="panel-heading">
              Add Class
            </header>
            <div class="panel-body">
              <?php
              if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['class'])) {
                $class = trim((string)($_POST['class'] ?? ''));
                $class_teacher = isset($_POST['class_teacher']) ? (int)$_POST['class_teacher'] : 0;
                $errors = [];

                if ($class === '') {
                  $errors[] = 'Enter All Fields To Proceed';
                }

                // check duplicate
                $checkStmt = mysqli_prepare($con, "SELECT 1 FROM classes WHERE class = ? LIMIT 1");
                if ($checkStmt) {
                  mysqli_stmt_bind_param($checkStmt, 's', $class);
                  mysqli_stmt_execute($checkStmt);
                  mysqli_stmt_store_result($checkStmt);
                  if (mysqli_stmt_num_rows($checkStmt) > 0) {
                    $errors[] = 'Class Name Already Exists';
                  }
                  mysqli_stmt_close($checkStmt);
                }

                if (!empty($errors)) {
                  foreach ($errors as $error) {
                    echo '<div class="alert alert-danger">' . htmlspecialchars($error) . '</div>';
                  }
                } else {
                  $insertStmt = mysqli_prepare($con, "INSERT INTO classes (class, category_id, creator, status) VALUES (?, ?, ?, 1)");
                  if ($insertStmt) {
                    $creator = $_SESSION['schoolsys'] ?? '';
                    mysqli_stmt_bind_param($insertStmt, 'sis', $class, $id, $creator);
                    if (mysqli_stmt_execute($insertStmt)) {
                      $class_id = (int) mysqli_insert_id($con);
                      // update teacher if provided
                      if ($class_teacher > 0) {
                        $upd = mysqli_prepare($con, "UPDATE teachers SET class_id = ?, classteacher = 'yes' WHERE teacher_id = ?");
                        if ($upd) {
                          mysqli_stmt_bind_param($upd, 'ii', $class_id, $class_teacher);
                          mysqli_stmt_execute($upd);
                          mysqli_stmt_close($upd);
                        }
                      }
                      echo '<div class="alert alert-success"><i class="fa fa-check"></i>Class successfully added</div>';
                    }
                    mysqli_stmt_close($insertStmt);
                  }
                }
              }

              ?>
              <form method="post" class="form" action='' name="form" enctype="multipart/form-data">
                <div class="form-group"><label class="control-label">Class</label>
                  <input type="text" class="form-control" name='class' placeholder="Enter Class Name" required='required'>
                </div>
                <div class="form-group"><label class="control-label">* Class Teacher </label>
                  <select data-placeholder="Choose class..." name="class_teacher" class="chosen-select" style="width:100%;" tabindex="2">
                    <option value="">Select Class...</option>
                    <?php
                    $getclass = mysqli_query($con, "SELECT teacher_id,fullname FROM teachers WHERE status=1");
                    if ($getclass) {
                      while ($row2 = mysqli_fetch_assoc($getclass)) {
                        $classname = $row2['fullname'] ?? '';
                        $class_id = (int) ($row2['teacher_id'] ?? 0);

                    ?>
                      <option value="<?php echo $class_id; ?>"><?php echo htmlspecialchars($classname); ?></option>
                    <?php }
                    }
                    ?>
                  </select>
                </div>
                <div class="form-group">
                  <button class="btn btn-primary" name="submit" type="submit">Add Class</button>
                </div>
              </form>
                    </div>
          </section>
        </div>
        <div class="col-lg-7">
          <section class="panel">
            <header class="panel-heading">
              <?php echo $classcat; ?>
            </header>
            <div class="panel-body">
              <table class="display table  table-striped">
                <thead>
                  <tr>
                    <th>Class</th>
                    <th>Streams</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $getclasses = mysqli_query($con, "SELECT class_id,class FROM classes WHERE status=1 AND category_id=" . $id);
                  if ($getclasses) {
                    while ($row = mysqli_fetch_assoc($getclasses)) {
                      $class_id = (int) ($row['class_id'] ?? 0);
                      $class = $row['class'] ?? '';
                      $streams = mysqli_query($con, "SELECT 1 FROM streams WHERE class_id=" . $class_id);
                  ?>
                    <tr class="gradeA">
                      <td><?php echo htmlspecialchars($class); ?></td>
                      <td><?php echo $streams ? mysqli_num_rows($streams) : 0; ?></td>

                      <td>
                        <?php if (isset($_SESSION['schoolsyslevel']) && (int)$_SESSION['schoolsyslevel'] === 1) { ?>
                          <a href="editclass?id=<?php echo $class_id; ?>" class="btn btn-xs btn-success"><i class="fa fa-edit"></i> Edit </a>
                          <a href="streams?id=<?php echo $class_id; ?>" class="btn btn-xs btn-primary"><i class="fa fa-building-o"></i> Streams</a>
                          <a href="hideclass?id=<?php echo $class_id; ?>" class="btn btn-xs btn-danger" onclick="return confirm_delete<?php echo $class_id; ?>()"><i class="fa fa-trash-o"></i>Remove</a>
                        <?php } ?>
                        <a href="class?id=<?php echo $class_id; ?>" class="btn btn-xs btn-info"><i class="fa fa-group"></i> Students</a>
                      </td>
                      <script type="text/javascript">
                        function confirm_delete<?php echo $class_id; ?>() {
                          return confirm(<?php echo json_encode('You are about To Remove this Item. Are you sure you want to proceed?'); ?>);
                        }
                      </script>
                    </tr>
                  <?php }
                  }
                  ?>
                </tbody>
              </table>
            </div>
          </section>
        </div>

      </div>


      </div>
      <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
  </section>

  <!-- Placed js at the end of the document so the pages load faster -->
  <script src="js/jquery-1.10.2.min.js"></script>
  <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="js/jquery-migrate-1.2.1.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/modernizr.min.js"></script>
  <script src="js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
  <script src="js/dynamic_table_init.js"></script>
  <!--common scripts for all pages-->
  <script src="js/scripts.js"></script>
  <script src="js/chosen/chosen.jquery.js"></script>
  <script>
    var config = {
      '.chosen-select': {},
      '.chosen-select-deselect': {
        allow_single_deselect: true
      },
      '.chosen-select-no-single': {
        disable_search_threshold: 10
      },
      '.chosen-select-no-results': {
        no_results_text: 'Oops, nothing found!'
      },
      '.chosen-select-width': {
        width: "95%"
      }
    }
    for (var selector in config) {
      $(selector).chosen(config[selector]);
    }
  </script>
</body>

</html>