<?php
include __DIR__ . '/../includes/conn.php';

$sql = "CREATE TABLE IF NOT EXISTS `salary` (
  `salary_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `employee_id` INT NOT NULL,
  `type` TINYINT NOT NULL DEFAULT 1,
  `year` INT NOT NULL,
  `month` VARCHAR(20) NOT NULL,
  `date` DATE NOT NULL,
  `salary` DECIMAL(10,2) NOT NULL DEFAULT 0,
  `bonus` DECIMAL(10,2) NOT NULL DEFAULT 0,
  `deduction` DECIMAL(10,2) NOT NULL DEFAULT 0,
  `nssf` DECIMAL(10,2) NOT NULL DEFAULT 0,
  `lapf` DECIMAL(10,2) NOT NULL DEFAULT 0,
  `loan` DECIMAL(10,2) NOT NULL DEFAULT 0,
  `welfare` DECIMAL(10,2) NOT NULL DEFAULT 0,
  `payee` INT NOT NULL DEFAULT 0,
  `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`salary_id`),
  INDEX (`employee_id`),
  INDEX (`year`,`month`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

if (mysqli_query($con, $sql)) {
    echo "salary table created or already exists.\n";
} else {
    echo "Error creating salary table: " . mysqli_error($con) . "\n";
    exit(1);
}

$q = @mysqli_query($con, 'SHOW CREATE TABLE salary');
if ($q && mysqli_num_rows($q) > 0) {
    $row = mysqli_fetch_assoc($q);
    echo "\n--- CREATE TABLE salary ---\n";
    echo ($row['Create Table'] ?? json_encode($row)) . "\n";
} else {
    echo "Unable to retrieve salary CREATE TABLE: " . mysqli_error($con) . "\n";
}

// Confirm select prepared works (duplicate check emulation)
$dup = @mysqli_prepare($con, "SELECT 1 FROM salary WHERE year = ? AND month = ? AND employee_id = ? AND type = ? LIMIT 1");
if ($dup) {
    echo "\nPrepared SELECT on salary succeeded.\n";
    mysqli_stmt_close($dup);
} else {
    echo "\nPrepared SELECT on salary failed: " . mysqli_error($con) . "\n";
}

?>