<?php
// Minimal script to create `income` table if it doesn't exist.
// Safe to run multiple times.
include __DIR__ . '/../includes/conn.php';
try {
    $create = "CREATE TABLE IF NOT EXISTS `income` (
      `income_id` int(11) NOT NULL AUTO_INCREMENT,
      `source` varchar(255) DEFAULT NULL,
      `amount` decimal(12,2) DEFAULT '0.00',
      `date` varchar(50) DEFAULT NULL,
      `account_id` int(11) DEFAULT NULL,
      `description` text,
      `status` tinyint(1) DEFAULT '1',
      `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
      PRIMARY KEY (`income_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";

    if (mysqli_query($con, $create)) {
        echo "income table created or already exists." . PHP_EOL;
        $res = mysqli_query($con, "SHOW CREATE TABLE `income`");
        if ($res) {
            $r = mysqli_fetch_assoc($res);
            echo $r['Create Table'] . PHP_EOL;
        }
    } else {
        echo "Failed to create income table: " . mysqli_error($con) . PHP_EOL;
    }
} catch (Exception $e) {
    echo 'Exception: ' . $e->getMessage() . PHP_EOL;
}

?>
