<?php
include __DIR__ . '/../includes/conn.php';

$sql = "CREATE TABLE IF NOT EXISTS `guards` (
  `guard_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `fullname` VARCHAR(191) NOT NULL,
  `salary` DECIMAL(10,2) NOT NULL DEFAULT 0,
  `status` TINYINT(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`guard_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

if (mysqli_query($con, $sql)) {
    echo "guards table created or already exists.\n";
} else {
    echo "Error creating guards table: " . mysqli_error($con) . "\n";
    exit(1);
}

$q = @mysqli_query($con, 'SHOW CREATE TABLE guards');
if ($q && mysqli_num_rows($q) > 0) {
    $row = mysqli_fetch_assoc($q);
    echo "\n--- CREATE TABLE guards ---\n";
    echo ($row['Create Table'] ?? json_encode($row)) . "\n";
} else {
    echo "Unable to retrieve guards CREATE TABLE: " . mysqli_error($con) . "\n";
}

// Show sample rows (0 rows expected initially)
$r = @mysqli_query($con, 'SELECT guard_id, fullname, salary, status FROM guards LIMIT 5');
if ($r) {
    echo "\n--- Sample rows ---\n";
    while ($a = mysqli_fetch_assoc($r)) {
        echo json_encode($a) . "\n";
    }
} else {
    echo "Failed to select from guards: " . mysqli_error($con) . "\n";
}

?>