<?php
// Create minimal `expenses` table if it doesn't exist.
include __DIR__ . '/../includes/conn.php';
try {
    $create = "CREATE TABLE IF NOT EXISTS `expenses` (
      `expense_id` int(11) NOT NULL AUTO_INCREMENT,
      `expense` varchar(255) DEFAULT NULL,
      `amount` decimal(12,2) DEFAULT '0.00',
      `date` varchar(50) DEFAULT NULL,
      `status` tinyint(1) DEFAULT '1',
      `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
      PRIMARY KEY (`expense_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";

    if (mysqli_query($con, $create)) {
        echo "expenses table created or already exists." . PHP_EOL;
        $res = mysqli_query($con, "SHOW CREATE TABLE `expenses`");
        if ($res) {
            $r = mysqli_fetch_assoc($res);
            echo $r['Create Table'] . PHP_EOL;
        }
    } else {
        echo "Failed to create expenses table: " . mysqli_error($con) . PHP_EOL;
    }
} catch (Exception $e) {
    echo 'Exception: ' . $e->getMessage() . PHP_EOL;
}

?>
