<?php
include 'includes/conn.php';
// Allow Super Admin (1), Principal (2), Accounts Management (3), Finance Manager (8), Accountant (10)
if (!isset($_SESSION['schoolsyslevel']) || !in_array((int)$_SESSION['schoolsyslevel'], [1,2,3,8,10], true)) {
  header('Location: login.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>School Fees</title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>
        <section class="wrapper">
             <div class="row">        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                  School Fees
                    </header>
                          <div class="panel-body">
  <?php
  $fees = mysqli_query($con, "SELECT * FROM schoolfees WHERE status=1");
  // Determine which column holds the year/term in `schoolfees` (some schemas use term_id)
  $year_col = 'year';
  $cols = mysqli_query($con, "SHOW COLUMNS FROM schoolfees");
  if ($cols) {
      $available = [];
      while ($c = mysqli_fetch_assoc($cols)) { $available[] = $c['Field']; }
      $candidates = ['year','term_year','academic_year','fee_year','financial_year','year_id','term_id'];
      foreach ($candidates as $cand) { if (in_array($cand, $available, true)) { $year_col = $cand; break; } }
  }

  if ($fees && mysqli_num_rows($fees) > 0) {
 ?>
        <table  class="display table  table-striped" id="dynamic-table">
                    <thead>
                    <tr>
                           <th>Year</th> 
                        <th>Class</th>                          
                        <th>Amount</th>      
                            <?php 
                             if($_SESSION['schoolsyslevel']==3){
                                 ?>  
                        <th>Action</th>
                             <?php } ?>
                    </tr>
                    </thead>
                    <tbody>
              <?php
                while($row = mysqli_fetch_assoc($fees)){
                $schoolfees_id = (int) ($row['schoolfees_id'] ?? 0);
                // Determine display value for year/term based on discovered column
                $year = '';
                if (isset($row[$year_col])) {
                  $year_val = $row[$year_col];
                  if ($year_col === 'term_id') {
                    // lookup human readable term
                    $term_q = mysqli_query($con, "SELECT term, year FROM financialterms WHERE financialterm_id=" . (int)$year_val . " LIMIT 1");
                    if ($term_q && mysqli_num_rows($term_q) > 0) {
                      $tr = mysqli_fetch_assoc($term_q);
                      $year = trim(($tr['term'] ?? '') . ' ' . ($tr['year'] ?? ''));
                    } else {
                      $year = (string)$year_val;
                    }
                  } else {
                    $year = (string)$year_val;
                  }
                }
  $amount = $row['amount'] ?? '';
  $class_id = (int) ($row['class_id'] ?? 0);
    $class = '';
    if ($class_id > 0) {
        $getclass = mysqli_query($con, "SELECT class FROM classes WHERE class_id=" . $class_id . " LIMIT 1");
        if ($getclass) {
            $row2 = mysqli_fetch_assoc($getclass);
            $class = $row2['class'] ?? '';
        }
    }
                  ?>

                    <tr class="gradeA">
                    <td><?php echo htmlspecialchars($year); ?></td>
                    <td><?php echo htmlspecialchars($class); ?></td>
                        <td><?php echo htmlspecialchars($amount); ?></td>
                  <?php 
                             if (isset($_SESSION['schoolsyslevel']) && (int)$_SESSION['schoolsyslevel'] === 3) {
                                 ?>      
                                                                                         
  <td>        
                      <a href="editfees?id=<?php echo $schoolfees_id; ?>"  class="btn btn-info  btn-xs">Edit <i class="fa fa-edit"></i></a>
                        <a href="hidefees?id=<?php echo $schoolfees_id; ?>"  class="btn btn-danger  btn-xs" onclick="return confirm_delete<?php echo $schoolfees_id;?>()">Delete <i class="fa fa-trash-o"></i></a>
                                
                                                         <script type="text/javascript">
function confirm_delete<?php echo $schoolfees_id; ?>() {
  return confirm(<?php echo json_encode('You are about To Remove this item. Are you sure you want to proceed?'); ?>);
}
</script>                 
  </td>
       <?php } ?> 
                    </tr>
                 <?php }?>
                    </tbody>
                                    </table>
           <?php } else { ?>
            <div class="alert alert-info">
              <h4>No active school fees configured</h4>
              <p>There are currently no active fee records for the school. You can add fee entries so they appear here.</p>
              <?php if (isset($_SESSION['schoolsyslevel']) && in_array((int)$_SESSION['schoolsyslevel'], [1,2,3,8,10], true)) { ?>
                <a href="addschoolfees.php" class="btn btn-primary">Add School Fee</a>
              <?php } ?>
            </div>
          <?php } ?>
                          </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>

</body>
</html>
