<?php
include 'includes/conn.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
// Allowed roles: Super Admin(1), Principal/Admin(2), Accounts Management(3), Finance Manager(8), HR Admin Director(9), Accountant(10)
$allowed_roles = [1,2,3,8,9,10];
if ($user_level === 0 || !in_array($user_level, $allowed_roles, true)) {
  header('Location: login.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Salary Payments</title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-12">
                      <section class="panel">
                                <header class="panel-heading">
                                  Salary Payments
                                </header>
                          <div class="panel-body">
                <?php
                        // Defensive: ensure the `salary` table exists before querying to avoid fatal errors
                        $salaries = false;
                        $tblCheck = @mysqli_query($con, "SHOW TABLES LIKE 'salary'");
                        if ($tblCheck && mysqli_num_rows($tblCheck) > 0) {
                          // Determine if `status` column exists on salary table
                          $status_col = false;
                          $colCheck = @mysqli_query($con, "SHOW COLUMNS FROM `salary` LIKE 'status'");
                          if ($colCheck && mysqli_num_rows($colCheck) > 0) {
                            $status_col = true;
                          }

                          $query = $status_col ? "SELECT * FROM salary WHERE status=1" : "SELECT * FROM salary";
                          $salaries = @mysqli_query($con, $query);
                          if ($salaries === false) {
                            error_log('Salary query failed: ' . mysqli_error($con));
                          }
                        } else {
                          echo '<div class="alert alert-warning">Payroll table not found. The payroll module appears not to be installed or the database schema is missing the <code>salary</code> table.</div>';
                        }

                        if ($salaries && mysqli_num_rows($salaries) > 0) {

             ?>
                      <table  class="display table  table-striped" id="dynamic-table">
                   <thead>
                                        <tr>
                                              <th>Full Names</th>
                                              <th>Basic</th>
                                            <th>Allowance</th>
                                                <th>NSSF</th>
                                                <th>LAPF</th>
                                                <th>PAYEE</th>
                                                <th>Social Welfare</th>
                                                <th>Loan</th>
                                                <th>Others</th>
                                                <th>Net</th>
                                                <th>Action</th>
                                        </tr>
                                    </thead>
                    <tbody>
              <?php 
                                   
                                        while ($row = mysqli_fetch_assoc($salaries)) {
                                            $salary_id = (int) ($row['salary_id'] ?? 0);
                                            $employee_id = (int) ($row['employee_id'] ?? 0);
                                            $year = $row['year'] ?? '';
                                            $month = $row['month'] ?? '';
                                            $date = $row['date'] ?? '';
                                            $allowance = $row['bonus'] ?? 0;
                                            $type = (int) ($row['type'] ?? 0);
                                            $salary = $row['salary'] ?? 0;
                                            $nssf = $row['nssf'] ?? 0;
                                            $payee = $row['payee'] ?? 0;
                                            $lapf = $row['lapf'] ?? 0;
                                            $loan = $row['loan'] ?? 0;
                                            $welfare = $row['welfare'] ?? 0;
                                            $deductions = $row['deduction'] ?? 0;
                                         $gross = $salary + $allowance;
                                         $totaldeductions = $lapf + $nssf + $loan + $welfare + $deductions + $payee;
                                         $net = $gross - $totaldeductions;
                                         $fullname = $guardname = '';
                                         $staffrole = '';
                                         if ($type === 1) {
                                          // Defensive: detect whether staff table has role_id or designation
                                          $staff_has_role_id = false;
                                          $rcol = @mysqli_query($con, "SHOW COLUMNS FROM `staff` LIKE 'role_id'");
                                          if ($rcol && mysqli_num_rows($rcol) > 0) {
                                            $staff_has_role_id = true;
                                          }
                                          $designation_exists = false;
                                          $dcol = @mysqli_query($con, "SHOW COLUMNS FROM `staff` LIKE 'designation'");
                                          if ($dcol && mysqli_num_rows($dcol) > 0) {
                                            $designation_exists = true;
                                          }

                                          if ($staff_has_role_id) {
                                            $getstaff = mysqli_query($con, "SELECT staff_id,fullname,role_id FROM staff WHERE staff_id=" . $employee_id . " LIMIT 1");
                                          } elseif ($designation_exists) {
                                            $getstaff = mysqli_query($con, "SELECT staff_id,fullname,designation AS role FROM staff WHERE staff_id=" . $employee_id . " LIMIT 1");
                                          } else {
                                            $getstaff = mysqli_query($con, "SELECT staff_id,fullname,NULL AS role FROM staff WHERE staff_id=" . $employee_id . " LIMIT 1");
                                          }

                                          if ($getstaff) {
                                            $row1 = mysqli_fetch_assoc($getstaff);
                                            $staff_id = (int) ($row1['staff_id'] ?? 0);
                                            $fullname = $row1['fullname'] ?? '';
                                            if ($staff_has_role_id) {
                                              $role_id = (int) ($row1['role_id'] ?? 0);
                                              if ($role_id > 0) {
                                                $allroles = mysqli_query($con, "SELECT role FROM staffroles WHERE staffrole_id=" . $role_id . " LIMIT 1");
                                                if ($allroles) {
                                                  $row2 = mysqli_fetch_assoc($allroles);
                                                  $staffrole = $row2['role'] ?? '';
                                                }
                                              }
                                            } else {
                                              $staffrole = $row1['role'] ?? '';
                                            }
                                          }
                                         } else {
                                           $getguard = mysqli_query($con, "SELECT fullname FROM guards WHERE guard_id=" . $employee_id . " LIMIT 1");
                                           if ($getguard) {
                                             $row3 = mysqli_fetch_assoc($getguard);
                                             $guardname = $row3['fullname'] ?? '';
                                           }
                                         }
                                        ?>               
                     <tr class="gradeA">
                        <?php if ($type === 1) { ?>               
                      <td><?php echo htmlspecialchars($fullname . ' (' . $staffrole . ')'); ?></td>
                                            <?php } else { ?>
                       <td><?php echo htmlspecialchars($guardname . ' (Guard)'); ?></td>
                                              <?php } ?>
                       <td><?php echo number_format((float)$salary); ?></td>                                        
                               <td><?php echo htmlspecialchars((string)$allowance); ?></td>                                        
                               <td><?php echo htmlspecialchars((string)$nssf); ?></td>                                        
                               <td><?php echo htmlspecialchars((string)$lapf); ?></td>                                        
                               <td><?php echo htmlspecialchars((string)$payee); ?></td>                                        
                               <td><?php echo htmlspecialchars((string)$welfare); ?></td>                                        
                               <td><?php echo htmlspecialchars((string)$loan); ?></td>                                        
                               <td><?php echo htmlspecialchars((string)$deductions); ?></td>                                        
                               <td><?php echo number_format((float)$net); ?></td>                                        
                               <td>                                 
                                 <?php 
                                 $current_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
                                 // Allow edit action to finance/account roles
                                 if (in_array($current_level, $allowed_roles, true)) {
                                 ?>
                                   <a href="editsalary?id=<?php echo $salary_id; ?>&emp=<?php echo $employee_id; ?>&ty=<?php echo $type; ?>" class="btn btn-success btn-xs"> <i class="fa fa-edit"></i> Edit</a>    
                                 <?php } ?>
                                   <a href="salaryinvoice?id=<?php echo $salary_id; ?>" class="btn btn-primary btn-xs"> <i class="fa fa-edit"></i> Invoice</a>                               
                      </td>
                                        </tr>
                 <?php }?>
                    </tbody>
                                    </table>
 <?php } else { ?>
  <div class="alert alert-info">No salary payments available.</div>
 <?php }?>
                          </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>

</body>
</html>
