<?php 
include 'includes/conn.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
// Allow Super Admin (1), Principal (2), Finance/Admin (3), Finance Manager (8), HR Admin Director (9), Accountant (10)
if ($user_level === 0 || !in_array($user_level, [1,2,3,8,9,10], true)) {
    header('Location: login.php');
    exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    header('Location: salarypayments.php');
    exit;
}
if (!isset($timenow)) {
    $timenow = time();
}
?>
<!DOCTYPE html>
<html>

<head>
<style type="text/css" media="print">
@page {
    size: auto;   /* auto is the initial value */
    margin: 0;  /* this affects the margin in the printer settings */
}
</style>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

   <title>Salary Invoice</title>

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

</head>

<body class="white-bg" style="background:#fff;">
                <div class="wrapper wrapper-content p-xl">
           <div class="ibox-content p-xl">
                            <div class="row">
                                <div class="col-sm-2"><img src="images/logo.png" class="img img-responsive"></div>
                                <div class="col-sm-4">
<!--                                                                       <address>
                                                                           <h3></h3>
                                        <strong>Nyamanoro Baptist</strong><br>
                                                              District here<br>
                                        Region here, Tanzania<br>
                                        <strong>P : </strong> 000 000 000<br/>
                                        www.nyamanorobaptist.com<br/>
                                            
                                    </address>-->
                                 
                                </div>

                                <div class="col-sm-6 text-right">
                                    <h4>Invoice No.</h4>
                                    <h4 class="text-navy"><?php echo $id*23; ?></h4>
                                           <address>
                                       
                                          <span><strong>Invoice Date:</strong> <?php echo date('M d,Y',$timenow); ?></span><br/>
                                    </address>
                                     
                                       
                                 
                                </div>
                                
                            </div>

                            <div class="table-responsive m-t">
                              <?php
                            $salaries = mysqli_query($con, "SELECT * FROM salary WHERE salary_id=" . $id . " LIMIT 1");
                            $salary_id = $employee_id = 0;
                            $year = $month = $date = '';
                            $allowance = $type = $salary = $nssf = $payee = $lapf = $loan = $welfare = $deductions = 0;
                            $fullname = $guardname = $staffrole = '';
                            if ($salaries) {
                                 $row = mysqli_fetch_assoc($salaries);
                                 if ($row) {
                                        $salary_id = (int) ($row['salary_id'] ?? 0);
                                        $employee_id = (int) ($row['employee_id'] ?? 0);
                                        $year = $row['year'] ?? '';
                                        $month = $row['month'] ?? '';
                                        $date = $row['date'] ?? '';
                                        $allowance = $row['bonus'] ?? 0;
                                        $type = (int) ($row['type'] ?? 0);
                                        $salary = $row['salary'] ?? 0;
                                        $nssf = $row['nssf'] ?? 0;
                                        $payee = $row['payee'] ?? 0;
                                        $lapf = $row['lapf'] ?? 0;
                                        $loan = $row['loan'] ?? 0;
                                        $welfare = $row['welfare'] ?? 0;
                                        $deductions = $row['deduction'] ?? 0;
                                 }
                            }
                            $gross = $salary + $allowance;
                            $totaldeductions = $lapf + $nssf + $loan + $welfare + $deductions + $payee;
                            $net = $gross - $totaldeductions;
                            if ($type === 1 && $employee_id > 0) {
                                // Defensive: check for role_id or fallback to designation
                                $staff_has_role_id = false;
                                $rcol = @mysqli_query($con, "SHOW COLUMNS FROM `staff` LIKE 'role_id'");
                                if ($rcol && mysqli_num_rows($rcol) > 0) {
                                    $staff_has_role_id = true;
                                }
                                $designation_exists = false;
                                $dcol = @mysqli_query($con, "SHOW COLUMNS FROM `staff` LIKE 'designation'");
                                if ($dcol && mysqli_num_rows($dcol) > 0) {
                                    $designation_exists = true;
                                }

                                if ($staff_has_role_id) {
                                    $getstaff = mysqli_query($con, "SELECT staff_id,fullname,role_id FROM staff WHERE staff_id=" . $employee_id . " LIMIT 1");
                                } elseif ($designation_exists) {
                                    $getstaff = mysqli_query($con, "SELECT staff_id,fullname,designation AS role FROM staff WHERE staff_id=" . $employee_id . " LIMIT 1");
                                } else {
                                    $getstaff = mysqli_query($con, "SELECT staff_id,fullname,NULL AS role FROM staff WHERE staff_id=" . $employee_id . " LIMIT 1");
                                }

                                if ($getstaff) {
                                    $row1 = mysqli_fetch_assoc($getstaff);
                                    $staff_id = (int) ($row1['staff_id'] ?? 0);
                                    $fullname = $row1['fullname'] ?? '';
                                    if ($staff_has_role_id) {
                                        $role_id = (int) ($row1['role_id'] ?? 0);
                                        if ($role_id > 0) {
                                            $allroles = mysqli_query($con, "SELECT role FROM staffroles WHERE staffrole_id=" . $role_id . " LIMIT 1");
                                            if ($allroles) {
                                                $row2 = mysqli_fetch_assoc($allroles);
                                                $staffrole = $row2['role'] ?? '';
                                            }
                                        }
                                    } else {
                                        $staffrole = $row1['role'] ?? '';
                                    }
                                }
                            } elseif ($employee_id > 0) {
                                $getguard = mysqli_query($con, "SELECT fullname FROM guards WHERE guard_id=" . $employee_id . " LIMIT 1");
                                if ($getguard) {
                                    $row3 = mysqli_fetch_assoc($getguard);
                                    $guardname = $row3['fullname'] ?? '';
                                }
                            }
                              ?>
                              <h2 class="text-center" style=" font-weight: bold; text-transform: uppercase;">Monthly Salary Slip</h2>
                                <div class="row" style="margin-bottom:20px">
                                                                             <?php if ($type === 1) { ?>   
                                                                <div class="col-sm-6"><strong>Name :  </strong><span><?php echo htmlspecialchars($fullname); ?></span></div>
                                                                <div class="col-sm-6"><strong>Designation : </strong><span><?php echo htmlspecialchars($staffrole); ?></span></div>
                                                                    <?php } else { ?>
                                                                    <div class="col-sm-6"><strong>Name :  </strong><span><?php echo htmlspecialchars($guardname); ?></span></div>
                                                                    <div class="col-sm-6"><strong>Designation : </strong><span><?php echo 'Guard';?></span></div>
                                                                    <?php } ?>
                                                                <div class="col-sm-6"><strong>Month : </strong><span><?php echo htmlspecialchars($month); ?></span></div>
                                                                <div class="col-sm-6"><strong>Year: </strong><span><?php echo htmlspecialchars($year); ?></span></div>
                            </div>
                             
                                <table class="table invoice-table table-bordered">
                                    <thead>
                                    <tr>
                                        <th>Basic Salary</th>
                                        <th>Allowances</th>
                                                                                                                  
                                    </tr>
                                    </thead>
                                    <tbody>
                                        
                                    <tr>
                                       
                                        <td><?php echo number_format((float)$salary);?></td>
                                       
                                        <td><?php echo number_format((float)$allowance);?></td>
                                       
                                    </tr>
                                   
                                    </tbody>
                                </table>
                            </div><!-- /table-responsive -->

                            <table class="table invoice-total">
                                <tbody>
                                                                <tr>
                                                                 
                                                                
                                    <td><strong>GROSS SALARY :</strong></td>
                                    <td><strong><?php echo number_format($gross); ?></strong></td>
                                </tr>
                                </tbody>
                            </table>
                                  <div class="table-responsive m-t">
                            <h3>Deductions</h3>
                              <table class="table invoice-table table-bordered">
                                    
                                    <tbody>
                                        
                                    <tr>                                    
                                        <td>NSSF</td>
                                        <td><?php echo htmlspecialchars((string)$nssf); ?></td>                                       
                                    </tr>
                                      <tr>                                    
                                        <td>LAPF</td>
                                        <td><?php echo htmlspecialchars((string)$lapf); ?></td>                                       
                                    </tr>
                                     <tr>                                    
                                        <td>P.A.Y.E.E</td>
                                        <td><?php echo htmlspecialchars((string)$payee); ?></td>                                       
                                    </tr>
                                      <tr>                                    
                                        <td>Social Welfare</td>
                                        <td><?php echo htmlspecialchars((string)$welfare); ?></td>                                       
                                    </tr>
                                      <tr>                                    
                                        <td>Loan</td>
                                        <td><?php echo htmlspecialchars((string)$loan); ?></td>                                       
                                    </tr>
                                      <tr>                                    
                                        <td>Others</td>
                                        <td><?php echo htmlspecialchars((string)$deductions); ?></td>                                       
                                    </tr>
                                    </tbody>
                                </table></div>
                             <table class="table invoice-total">
                                <tbody>
                                                                <tr>
                                                                 
                                                                
                                    <td><strong>TOTAL DEDUCTIONS :</strong></td>
                                    <td><strong><?php echo number_format((float)$totaldeductions); ?></strong></td>
                                </tr>
                                 <tr>
                                                                 
                                                                
                                    <td><strong>NET SALARY :</strong></td>
                                    <td><strong><?php echo number_format((float)$net); ?></strong></td>
                                </tr>
                                </tbody>
                            </table>
                            <div class="well m-t">
                                <strong style="font-style: italic">All Rights Reserved</strong>
                            </div>
                        </div>

    </div>
<script src="js/jquery-1.11.3.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>

<!--common scripts for all pages-->
<script src="js/scripts.js"></script>
    <script type="text/javascript">
        window.print();
    </script>

</body>

</html>
