<?php
include 'includes/conn.php';
include 'includes/roles.php';
include 'includes/backup_restore.php';

// Only Super Admin
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if ($user_level != 1) {
    header('Location: login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: systemconfiguration.php');
    exit();
}

if (!isset($_FILES['backup_file']) || $_FILES['backup_file']['error'] !== UPLOAD_ERR_OK) {
    $_SESSION['message'] = 'Error uploading backup file';
    $_SESSION['msg_type'] = 'danger';
    header('Location: backupmanagement.php');
    exit();
}

$upload = $_FILES['backup_file'];
$name = basename($upload['name']);
// allow .sql or .zip
$ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
if (!in_array($ext, ['sql','zip'])) {
    $_SESSION['message'] = 'Unsupported file type';
    $_SESSION['msg_type'] = 'danger';
    header('Location: backupmanagement.php');
    exit();
}

$dst_dir = __DIR__ . DIRECTORY_SEPARATOR . 'backups' . DIRECTORY_SEPARATOR;
if (!is_dir($dst_dir)) mkdir($dst_dir, 0755, true);
$dst = $dst_dir . 'restore_' . time() . '_' . preg_replace('/[^A-Za-z0-9_\.-]/', '_', $name);

if (!move_uploaded_file($upload['tmp_name'], $dst)) {
    $_SESSION['message'] = 'Failed to move uploaded file';
    $_SESSION['msg_type'] = 'danger';
    header('Location: backupmanagement.php');
    exit();
}

$backup = new DatabaseBackup($con);
$result = $backup->restoreBackup($dst);
if ($result['status'] === 'success') {
    $_SESSION['message'] = 'Restore completed. Executed: ' . ($result['executed'] ?? 0) . ', Failed: ' . ($result['failed'] ?? 0);
    $_SESSION['msg_type'] = 'success';
} else {
    $_SESSION['message'] = 'Restore error: ' . ($result['message'] ?? 'Unknown error');
    $_SESSION['msg_type'] = 'danger';
}

header('Location: backupmanagement.php');
exit();
