<?php
include 'includes/conn.php';

if (!isset($_SESSION['schoolsyslevel']) || !in_array((int)$_SESSION['schoolsyslevel'], [1,2,3,6], true)) {
    header('Location:login');
    exit;
}

// Safe query helper
function sq($con, $sql) {
    $res = mysqli_query($con, $sql);
    if ($res === false) {
        // Log full DB error server-side for admin debugging, but do not expose it to users.
        error_log('DB query error: ' . mysqli_error($con) . ' -- SQL: ' . $sql);
        // Return false so caller can handle missing data. Avoid printing DB details to the page.
        return false;
    }
    return $res;
}

$std = isset($_GET['std']) ? mysqli_real_escape_string($con, $_GET['std']) : '';
// term id (if not supplied, auto-resolve to the active/current term)
$tm  = isset($_GET['tm'])  ? mysqli_real_escape_string($con, $_GET['tm'])  : '';
if (empty($tm)) {
    // try to find a term whose date range contains today
    $today = date('Y-m-d');
    $activeTermRes = mysqli_query($con, "SELECT financialterm_id FROM financialterms WHERE startdate <= '$today' AND enddate >= '$today' ORDER BY financialterm_id DESC LIMIT 1");
    if ($activeTermRes && mysqli_num_rows($activeTermRes) > 0) {
        $tm = mysqli_fetch_assoc($activeTermRes)['financialterm_id'];
    } else {
        // fallback: pick latest active term
        $latest = mysqli_query($con, "SELECT financialterm_id FROM financialterms WHERE status=1 ORDER BY financialterm_id DESC LIMIT 1");
        if ($latest && mysqli_num_rows($latest) > 0) $tm = mysqli_fetch_assoc($latest)['financialterm_id'];
    }
}

// Get student's class and class category ID
$student_query = sq($con, "SELECT class_id, fullname, student_id FROM students WHERE student_id = '$std' LIMIT 1");
$student_data = mysqli_fetch_array($student_query);
$student_class_id = $student_data['class_id'];
$fullname = $student_data['fullname'];
$student_id = $student_data['student_id'];
// Get class category ID from the student's class
$class_query = sq($con, "SELECT * FROM classes WHERE class_id = '$student_class_id' LIMIT 1");
$class_data = mysqli_fetch_array($class_query);
$class_id = $class_data['class_id'];
$class = $class_data['class'];
$report_type = $class_data['report_type'];
$aveage_type = $class_data['average_type'];
$category_id = $class_data['category_id'];

// Get class category name
$getcat = sq($con, "SELECT * FROM classcategories WHERE classcategory_id='$category_id'");
$rowc = mysqli_fetch_array($getcat);
$classcategory = $rowc['classcategory'];

// Load term info
$getterm = sq($con, "SELECT ft.*, fy.fyear FROM financialterms ft INNER JOIN financialyears fy ON ft.academic_year=fy.fyear_id WHERE ft.financialterm_id='$tm' LIMIT 1");
$row4 = mysqli_fetch_array($getterm);
$term2 = $row4['term'];
$year = $row4['year'];
$academic_year = $row4['fyear'];
$startdate_4 = $row4['startdate'];
$enddate_4 = $row4['enddate'];
$notice = isset($row4['important_notice']) ? $row4['important_notice'] : '';

// Get principal/headteacher and signatures
$getdirector = sq($con, "SELECT * FROM users WHERE level=2 AND status=1 LIMIT 1");
$rowd = mysqli_fetch_array($getdirector);
$staff_id1 = $rowd['staff_id'];
$getstaff1 = sq($con, "SELECT * FROM staff WHERE staff_id='$staff_id1' LIMIT 1");
$rows1 = mysqli_fetch_array($getstaff1);
$fullname2 = $rows1['fullname'];

$headteacher = sq($con, "SELECT * FROM staff WHERE designation='Head Teacher' AND status=1 LIMIT 1");
$rowh = mysqli_fetch_array($headteacher);
$hsign_ext = $rowh['sign_ext'];
$staff_id2 = $rowh['staff_id'];
$headteachername = $rowh['fullname'];

$pteacher = sq($con, "SELECT * FROM staff WHERE designation='Principal' AND status=1 LIMIT 1");
$rowp = mysqli_fetch_array($pteacher);
$psign_ext = $rowp['sign_ext'];
$staff_id3 = $rowp['staff_id'];
$principalname = $rowp['fullname'];

// Load grading config (custom or default)
// Load grading config (custom for the class category). If none found, fall back to built-in defaults.
$grades = [];
$grades_query = sq($con, "SELECT grade_letter, grade_modifier, mark_range FROM grade_config WHERE classcategory_id = '{$class_data['category_id']}' ORDER BY grade_letter DESC, grade_modifier DESC");
if ($grades_query && mysqli_num_rows($grades_query) > 0) {
    while ($g = mysqli_fetch_assoc($grades_query)) {
        $label = $g['grade_letter'] . ($g['grade_modifier'] ?? '');
        $range = trim($g['mark_range']);
        // normalize display: remove percent signs and fix spacing
        $r = str_replace('%', '', $range);
        $r = preg_replace('/\s*-\s*/', '-', $r);
        $r = $r . '%';
        $grades[] = array('label' => $label, 'range' => $r);
    }
} else {
    // default grading map (kept as sensible defaults)
    $grades = array(
        array('label' => 'A*', 'range' => '86-100%'),
        array('label' => 'A',  'range' => '81-85%'),
        array('label' => 'B+', 'range' => '76-80%'),
        array('label' => 'B',  'range' => '71-75%'),
        array('label' => 'B-', 'range' => '66-70%'),
        array('label' => 'C+', 'range' => '61-65%'),
        array('label' => 'C',  'range' => '56-60%'),
        array('label' => 'C-', 'range' => '51-55%'),
        array('label' => 'D',  'range' => '41-50%'),
        array('label' => 'E',  'range' => '31-40%'),
        array('label' => 'U',  'range' => '0-30%')
    );
}

/**
 * Helper: find grade label from numeric percentage using $grades map
 */
function find_grade_from_percent($percent, $grades_map) {
    if ($percent === null || $percent === '' || strtoupper($percent) === 'N/A') return 'N/A';
    $p = intval($percent);

    // Detect if $grades_map is an indexed array of ['label'=>..., 'range'=>...]
    $isIndexed = array_keys($grades_map) === range(0, count($grades_map) - 1);

    if ($isIndexed) {
        foreach ($grades_map as $entry) {
            $label = isset($entry['label']) ? $entry['label'] : '';
            $range = isset($entry['range']) ? $entry['range'] : '';
            $range = str_replace('%', '', $range);
            if (strpos($range, '-') !== false) {
                list($min, $max) = explode('-', $range, 2);
                $min = intval(trim($min));
                $max = intval(trim($max));
                // normalize if min > max
                if ($min > $max) {
                    $tmp = $min; $min = $max; $max = $tmp;
                }
                if ($p >= $min && $p <= $max) return $label;
            }
        }
        return 'U';
    }

    // associative map (legacy)
    foreach ($grades_map as $g => $range) {
        $r = str_replace('%', '', $range);
        if (strpos($r, '-') !== false) {
            list($min, $max) = explode('-', $r, 2);
            $min = intval(trim($min));
            $max = intval(trim($max));
            if ($min > $max) { $tmp = $min; $min = $max; $max = $tmp; }
            if ($p >= $min && $p <= $max) return $g;
        }
    }
    return 'U';
}
                

/**
 * Normalize DB-mark using rank — returns rounded integer percent of given maxWeight
 * $rawMark = marks from DB, $rank = max possible (e.g. 50) used to scale, $scaleTo = weight (40 or 60)
 */
function normalize_mark($rawMark, $rank, $scaleTo) {
    if ($rawMark === null || $rawMark === '' || strtoupper($rawMark) === 'N/A') return null;
    if (intval($rank) == 0) return null;
    $raw = floatval($rawMark);
    $rk = floatval($rank);
    $percentOfFull = ($raw / $rk); // 0..1
    $scaled = round($percentOfFull * $scaleTo);
    // Defensive: clamp scaled value to 0..$scaleTo to avoid showing values above the column max
    $scaled = intval($scaled);
    if ($scaled < 0) $scaled = 0;
    if ($scaled > intval($scaleTo)) $scaled = intval($scaleTo);
    return $scaled;
}

// load papers (for multi-paper reports)
$getpapers = sq($con, "SELECT * FROM papers WHERE status='1' ORDER BY paper_id");
$papers = [];
while ($p = mysqli_fetch_array($getpapers)) {
    $papers[] = $p;
}

// get subjects for class
$classmarks = sq($con, "SELECT * FROM class_subjects WHERE class_id='$class_id' ORDER BY subject_id");

$getabsence = sq($con, "SELECT * FROM attendance WHERE term_id='$tm' AND class_id='$class_id'");
$absent = 0; $present = 0; $present2 = 0;
while ($rowt = mysqli_fetch_array($getabsence)) {
    $attendance_id = $rowt['attendance_id'];
    $getabsence2 = sq($con, "SELECT * FROM attendancedetails WHERE status=0 AND student_id='$std' AND attendance_id='$attendance_id'");
    $getpresent = sq($con, "SELECT * FROM attendancedetails WHERE status=1 AND student_id='$std' AND attendance_id='$attendance_id'");
    $getpresent2 = sq($con, "SELECT * FROM attendancedetails WHERE status=2 AND student_id='$std' AND attendance_id='$attendance_id'");
    $absent += ($getabsence2) ? mysqli_num_rows($getabsence2) : 0;
    $present += ($getpresent) ? mysqli_num_rows($getpresent) : 0;
    $present2 += ($getpresent2) ? mysqli_num_rows($getpresent2) : 0;
}
$overall_days = $absent + $present + $present2;

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Progress Report - <?php echo htmlspecialchars($fullname); ?></title>

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Print / PDF A4 settings -->
    <style>
        @page {
            size: A4;
            margin: 20mm;
        }
        html,body{
            font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
            color: #000;
            height: 100%;
            -webkit-print-color-adjust: exact;
        }
        body { 
            margin: 0; 
            padding: 0; 
            background: #fff;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        .report-wrapper {
            position: relative;
            width: 100%;
            min-height: 100%;
            padding-bottom: 90px; /* reduced reserve so footer can move earlier */
            box-sizing: border-box;
        }

        .container {
            /* Add left/right padding to provide consistent margins for screen and print */
            width: 100%;
            box-sizing: border-box;
            padding: 0 20mm; /* matches the @page margin for consistent print output */
            flex: 1;
            display: flex;
            flex-direction: column;
        }

        /* Media-specific fixes: screen uses px-based paddings, print uses mm */
        @media screen {
            .container { padding: 0 20px; max-width: 100%; }
            /* Ensure effort area uses full available width on screen */
            .effort-box { width: 100% !important; max-width: 100% !important; }
            .effort-box .effort-table { width: 100% !important; }
        }

        @media print {
            /* Keep container edges aligned with the @page margin; do not shrink effort box */
            .container { padding-left: 0 !important; padding-right: 0 !important; max-width: 100% !important; }

            /* Make the header visually span the printable area but avoid negative margins here.
               Removing negative margins avoids layout surprises in different browsers/print drivers. */
            .report-header {
                box-sizing: border-box;
                width: 100% !important;
                padding: 0 0 !important;
                display: flex !important;
            }

            /* Effort area must match the subject table width inside the printable area */
            .effort-box { width: 100% !important; max-width: 100% !important; padding: 0 !important; }
            .effort-box .effort-table { width: 100% !important; max-width: 100% !important; }
            /* Compact subject table for print so more rows fit on page 1 */
            .subject-table th, .subject-table td { padding: 4px 6px !important; font-size: 11px !important; }
            /* Compact effort table for print */
            .effort-box .effort-table td { padding: 4px 6px !important; font-size: 11px !important; }
            /* Reduce top/bottom spacing in header and title bar for print */
            .report-header { margin-bottom: 4px !important; }
            .term-bar { padding: 6px 8px !important; margin-top: 6px !important; margin-bottom: 6px !important; font-size: 12px !important; }
        }

        /* Header */
        .report-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            gap: 12px;
            margin-bottom: 8px;
        }
        .header-left {
            flex: 1 1 65%;
        }
        .school-title {
            font-family: "Georgia", "Times New Roman", serif;
            color: #1f67a8;
            font-size: 28px;
            margin: 0 0 2px 0;
            font-weight: 700;
        }
        .school-subtitle {
            color: #6aa14e;
            font-size: 14px;
            margin: 0 0 6px 0;
            font-weight: 600;
        }
        .school-motto {
            font-style: italic;
            color: #333;
            font-size: 12px;
            margin: 0 0 8px 0;
            opacity: 0.95;
        }
    .contact-info p { margin: 0; font-size: 12px; }
    /* Make contact links underlined (email and website) and preserve text color */
    .contact-info a { text-decoration: underline; color: inherit; }
    /* Small Facebook square 'f' icon */
    .fb-link { display: inline-flex; align-items: center; gap:6px; text-decoration: none; color: inherit; }
    .fb-icon { display:inline-block; width:18px; height:18px; background:#1877F2; color:#fff; font-weight:700; text-align:center; line-height:18px; border-radius:3px; font-family: Arial, Helvetica, sans-serif; font-size:12px; }

        .header-right {
            width: 180px;
            text-align: center;
        }
        .school-logo {
            width: 80px;
            height: 80px;
            object-fit: contain;
            border-radius: 50%;
            display: block;
            margin: 0 auto 6px auto;
        }
        .academic-year { font-weight: 700; font-size: 12px; }

        /* Title bar */
        .term-bar {
            background: #d6dce0;
            border: 1px solid #000;
            padding: 8px 12px;
            text-align: center;
            font-weight: 700;
            margin-top: 10px;
            margin-bottom: 10px;
        }

        /* Student info row */
        .student-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 8px;
            font-size: 14px;
        }
        .underline-field {
            border-bottom: 2px solid #000;
            padding-bottom: 4px;
            display: inline-block;
            min-width: 240px;
            margin-left: 6px;
            font-weight: 700;
        }
        .year-field {
            border-bottom: 2px solid #000;
            padding-bottom: 4px;
            min-width: 80px;
            display: inline-block;
            font-weight: 700;
            text-align: center;
        }

        /* Main table */
        .subject-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 8px;
            page-break-inside: auto;
        }
        .subject-table thead { display: table-header-group; }
        .subject-table th, .subject-table td {
            border: 1px solid #000;
            padding: 6px 8px;
            vertical-align: middle;
            font-size: 12px;
        }
        .subject-table thead th {
            background: #2f87c8;
            color: #fff;
            font-weight: 700;
            text-transform: none;
            text-align: center;
        }
        .subject-name { text-align: left; font-weight: 600; }
        .num { text-align: center; }

        /* Grading legend */
        .grading-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 12px;
        }
        .grading-table th, .grading-table td {
            border: 1px solid #000;
            /* ensure vertical lines are visible by explicitly keeping left/right borders */
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            padding: 6px;
            font-size: 12px;
            text-align: center;
        }
        .grading-title {
            background: #c6efce;
            font-weight: 700;
        }

        /* Effort box */
        .effort-box {
            margin-top: 12px;
            margin-bottom: 18px; /* ensure space below effort area so it's not attached to comments */
            padding: 6px;
            width: 100% !important;
            max-width: 100% !important;
            display: block !important;
            clear: both !important;
            float: none !important;
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
           
        }
        /* Effort integrated into the main table: use a grid of rows inside the merged cell.
           A positioned pseudo-element draws a continuous vertical separator between the
           rank column and the description column so the line looks like part of the table. */
        .effort-box { position: relative; }
        /* Effort table: single table with thicker borders and shaded effort rows */
        .effort-box .effort-table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            box-sizing: border-box;
        }
        .effort-box .effort-table td {
            border: 2px solid #000; /* thicker borders */
            padding: 8px 10px;
            vertical-align: top;
            font-size: 12px;
        }
        .effort-box .effort-table thead th.effort-title {
            background-color: #c6efce;
            font-weight: 700;
            text-align: center;
            padding: 8px 10px;
            border: 2px solid #000;
        }
        
        .effort-box .effort-table .effort-num {
            width: 60px; text-align: center; font-weight: 700; white-space: nowrap;
        }
        /* Shade only the effort rows (odd rows) */
        .effort-box .effort-table tr:nth-child(odd) td { background: #fff; }

        /* Tutor comments */
        .comments {
            /* space the comments away from the effort box so they don't touch visually */
            margin-top: 18px;
            border: 2px solid #000;
            padding: 10px;
            min-height: 80px;
            box-sizing: border-box;
            background: #fff;
        }
        .comments h3 {
            margin: 0 0 6px 0;
            padding: 6px;
            background: #c6efce;
            border-bottom: 2px solid #000;
            text-align: center;
        }
        .comments p { margin: 8px 0 0 0; font-size: 13px; }

        /* Attendance box */
        .attendance {
            margin-top: 12px;
            width: 320px;
            border-collapse: collapse;
        }
        .attendance td { border: 1px solid #000; padding: 6px; font-size: 13px; }

        /* Signatures */
        .signatures {
            margin-top: 18px;
            display: block;
        }
        .signatures .sign-row {
            display: flex;
            justify-content: space-between;
            gap: 20px;
            align-items: center;
        }
    .sign-box { width: 48%; text-align: left; }
    /* make signature images inline-level so parent text-align (e.g. right) positions them correctly */
    .sign-box img { width: 120px; height: auto; display: inline-block; margin-top: 6px; }

        /* Important notice */
        .notice {
            margin-top: 18px;
            border: 2px solid #000;
            padding: 8px;
            box-sizing: border-box;
        }
        .notice h4 { margin: 0 0 6px 0; background: #c6efce; padding:6px; font-size:14px; text-align:center; border-bottom:2px solid #000; }
        .notice p { margin: 6px 0 0 0; font-size:13px; }

        /* Report footer (motto and affiliation) */
        .report-footer { 
            text-align: center; 
            font-size: 12px; 
            color: #333; 
            margin-top: auto;
            padding: 6px 0 0 0; /* reduced top padding so footer sits closer to page bottom */
        }
        .report-footer p { margin: 4px 0; }
        @media print {
            .report-wrapper { padding-bottom: 0; position: relative; }
            .report-footer {
                position: absolute;
                left: 0;
                right: 0;
                bottom: auto;
                text-align: center;
                font-size: 12px;
                color: #333;
                margin-top: 0;
                page-break-before: avoid;
            }
            .report-footer { margin-top: -63px !important; }
            .report-footer-hidden { display: none !important; }
            /* Ensure effort box prints fully on page 1 and forces a page break
               so Class Tutor's Comments (and subsequent content) start on page 2. */
            .effort-box { page-break-inside: avoid; page-break-after: always; break-after: page; }
            /* Make sure the comments area starts at top of next page and doesn't keep large top margin */
            .comments { page-break-before: always; break-before: page; margin-top: 0 !important; }
            /* Prevent the effort inner table from splitting when printing */
            .effort-box .effort-table { page-break-inside: avoid; }
        }

        /* Avoid breaking boxes across pages */
        .comments, .notice, .subject-table, .grading-table, .effort-box { page-break-inside: avoid; }
    </style>
</head>
<body>
<div class="report-wrapper">
<div class="container">
    <!-- Header -->
    <header class="report-header" role="banner">
        <div class="header-left">
            <h2 class="school-title">The King's School</h2>
            <div class="school-subtitle">Christian, English Speaking, International School</div>
            <div class="contact-info" aria-label="school contact information">
                <p><strong>BP BOX 1560, Bujumbura, Burundi</strong></p>
                <p>TEL: (+257) 22 27 96 78 / 69 84 04 78</p>
                <p>Email: <a href="mailto:secondary.school@thekingsschool.edu.bl">secondary.school@thekingsschool.edu.bl</a></p>
                <p>Website: <a href="https://www.thekingsschool.edu.bl" target="_blank" rel="noopener">www.thekingsschool.edu.bl</a></p>
                <p><strong><span class="fb-icon">f</span><span> The King's School Burundi</span></strong></a></p>
            </div>
        </div>

        <?php
        // compute a displayable academic year: prefer DB value, else derive from term start/end
        $academic_display = '';
        if (!empty($academic_year)) {
            $academic_display = $academic_year;
        } elseif (!empty($startdate_4) || !empty($enddate_4)) {
            $sd_ts = !empty($startdate_4) ? strtotime($startdate_4) : false;
            $ed_ts = !empty($enddate_4) ? strtotime($enddate_4) : false;
            if ($sd_ts && $ed_ts) {
                $ys = date('Y', $sd_ts);
                $ye = date('Y', $ed_ts);
                $academic_display = ($ys === $ye) ? $ys : ($ys . '-' . $ye);
            } elseif ($ed_ts) {
                $academic_display = date('Y', $ed_ts);
            } elseif ($sd_ts) {
                $academic_display = date('Y', $sd_ts);
            }
        }
        ?>
        <div class="header-right" role="img" aria-label="school logo and academic year">
            <img class="school-logo" src="<?php echo BASE_URL; ?>/images/schoollogo.JPG" alt="The King's School logo">
            <div class="academic-year">ACADEMIC YEAR: <?php echo htmlspecialchars($academic_display); ?></div>
        </div>
    </header>

    <!-- Term title -->
    <div class="term-bar">TERM <?php echo htmlspecialchars($term2); ?> REPORT - <?php echo date('F Y', $enddate_4); ?></div>

    <!-- Student info -->
    <div class="student-row" role="region" aria-label="student information">
        <div><strong>Student Name:</strong> <span class="underline-field"><?php echo htmlspecialchars($fullname); ?></span></div>
        <div><strong>Year:</strong> <span class="year-field"><?php
                // try to strip year from class name like "Form 7B"
                $class3 = $class;
                $parts = preg_split('/\s+/', trim($class3));
                $yearDisplay = end($parts);
                echo htmlspecialchars($yearDisplay);
            ?></span></div>
    </div>

    <!-- Subject table (Classwork/Exam/Cumulative) -->
    <?php if ($classmarks && mysqli_num_rows($classmarks) > 0): ?>
        <table class="subject-table" role="table" aria-label="subject scores">
            <thead>
                <tr>
                    <th style="text-align:left">Subject</th>
                    <th>Classwork /40</th>
                    <th>Exam /60</th>
                    <th>Cumulative %</th>
                    <th>Grade</th>
                    <th>Effort</th>
                    <th>Class average</th>
                </tr>
            </thead>
            <tbody>
            <?php
            // Rewind pointer and iterate subjects
            if ($classmarks) mysqli_data_seek($classmarks, 0);
            while ($row = mysqli_fetch_array($classmarks)) {
                $subject_id = $row['subject_id'];
                $getsubjects = sq($con, "SELECT * FROM subjects WHERE subject_id='$subject_id' LIMIT 1");
                $row3 = mysqli_fetch_array($getsubjects);
                if (!$row3) continue;
                $subject = $row3['subject'];

                // Get classwork (assessment=1) - average multiple continuous assessments scaled to 40
                $cwmark = null;
                $cw_all = sq($con, "SELECT marks, rank FROM marks WHERE class_id='$class_id' AND student_id='$std' AND term_id='$tm' AND subject_id='$subject_id' AND assessment='1' AND status='1'");
                if ($cw_all && mysqli_num_rows($cw_all) > 0) {
                    $normalized_values = [];
                    while ($crow = mysqli_fetch_array($cw_all)) {
                        $cw_raw = $crow['marks'] ?? null;
                        $cw_rank = isset($crow['rank']) ? intval($crow['rank']) : 0;
                        $nm = normalize_mark($cw_raw, $cw_rank, 40);
                        if ($nm !== null) $normalized_values[] = intval($nm);
                    }
                    if (count($normalized_values) > 0) {
                        $cwmark = round(array_sum($normalized_values) / count($normalized_values));
                    }
                }

                // Get exam (assessment=2)
                $exammark = null;
                $effort_id = 0;
                // prefer the latest exam row when multiple entries exist
                $examQuery = sq($con, "SELECT marks, rank, effort_id FROM marks WHERE class_id='$class_id' AND student_id='$std' AND term_id='$tm' AND subject_id='$subject_id' AND assessment='2' AND status='1' ORDER BY mark_id DESC LIMIT 1");
                if ($examQuery && mysqli_num_rows($examQuery) > 0) {
                    $exRow = mysqli_fetch_array($examQuery);
                    $exam_raw = $exRow['marks'];
                    $exam_rank = $exRow['rank'] ? $exRow['rank'] : 0;
                    $effort_id = $exRow['effort_id'];
                    $exammark = normalize_mark($exam_raw, $exam_rank, 60); // scale to 60
                }

                // If both null or exam null — treat as N/A (skip printing row if no exam/classwork found)
                if ($exammark === null && $cwmark === null) {
                    // skip subject (not taken or no marks)
                    continue;
                }

                // Cumulative: sum of cw(0-40) + exam(0-60) => 0..100
                $finalmark = 0;
                if ($cwmark !== null) $finalmark += intval($cwmark);
                if ($exammark !== null) $finalmark += intval($exammark);

                // Grade from $grades map
                $grade_label = ($finalmark === null || $finalmark === 0 && $exammark === null) ? 'N/A' : find_grade_from_percent($finalmark, $grades);

                // Effort display
                $effort_display = '';
                if ($effort_id && $effort_id != 0) {
                    $geteff = sq($con, "SELECT rank FROM effort_types WHERE effort_id='$effort_id' LIMIT 1");
                    if ($geteff && mysqli_num_rows($geteff) > 0) {
                        $effrow = mysqli_fetch_array($geteff);
                        $effort_display = $effrow['rank'];
                    }
                }

                // Class average
                $classavg_display = '';
                if ($aveage_type != 0) {
                    // simpler average: average of normalized exam marks from marks table (assessment 2)
                    $getclassavg = mysqli_query($con, "SELECT marks, rank FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND assessment='2' AND status='1'");
                    $count = 0; $totalPercent = 0;
                    while ($rowavg = mysqli_fetch_array($getclassavg)) {
                        $m = $rowavg['marks'];
                        $rk = $rowavg['rank'] ? $rowavg['rank'] : 0;
                        if ($m === null || strtoupper($m) === 'N/A' || $rk == 0) continue;
                        $percent = round((intval($m) / intval($rk)) * 100);
                        $totalPercent += $percent;
                        $count++;
                    }
                    if ($count > 0) $classavg_display = round($totalPercent / $count);
                } else {
                    // average across students and papers (approximate), using paper 1 grouping
                    $getStudentsQuery = "SELECT student_id FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND assessment='2' AND status='1' AND marks != 'N/A' AND marks !='' and paper_id='1'";
                    $studentsResult = mysqli_query($con, $getStudentsQuery);
                    $totalStudents = mysqli_num_rows($studentsResult);
                    $totalMarks = [];
                    if ($totalStudents > 0) {
                        while ($studentRow = mysqli_fetch_assoc($studentsResult)) {
                            $studentId = $studentRow['student_id'];
                            // compute student's average percent across papers
                            $paperQuery = mysqli_query($con, "SELECT * FROM papers WHERE status='1'");
                            $studentTotalPercent = 0; $paperCount = 0;
                            while ($paperRow = mysqli_fetch_array($paperQuery)) {
                                $paperId = $paperRow['paper_id'];
                                $getMarksQuery = mysqli_query($con, "SELECT marks, rank FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND paper_id='$paperId' AND assessment='2' AND status='1' AND marks != 'N/A' AND marks !='' AND student_id='$studentId'");
                                $marksCount = mysqli_num_rows($getMarksQuery);
                                if ($marksCount > 0) {
                                    $sumThisPaper = 0; $countThisPaper = 0;
                                    while ($mRow = mysqli_fetch_array($getMarksQuery)) {
                                        $markVal = intval($mRow['marks']);
                                        $rank_s = intval($mRow['rank']) ?: 0;
                                        if ($rank_s > 0) {
                                            $sumThisPaper += round($markVal / $rank_s * 100);
                                            $countThisPaper++;
                                        }
                                    }
                                    if ($countThisPaper > 0) {
                                        $studentTotalPercent += round($sumThisPaper / $countThisPaper);
                                        $paperCount++;
                                    }
                                }
                            }
                            if ($paperCount > 0) $totalMarks[] = round($studentTotalPercent / $paperCount);
                        }
                        if (count($totalMarks) > 0) $classavg_display = round(array_sum($totalMarks) / count($totalMarks));
                    }
                }

                // Render row
                ?>
                <tr>
                    <td class="subject-name"><?php echo htmlspecialchars($subject); ?></td>
                    <td class="num"><?php echo ($cwmark !== null) ? $cwmark : ''; ?></td>
                    <td class="num"><?php echo ($exammark !== null) ? $exammark : ''; ?></td>
                    <td class="num"><?php echo ($finalmark !== null) ? $finalmark : 'N/A'; ?></td>
                    <td class="num"><?php echo htmlspecialchars($grade_label); ?></td>
                    <td class="num"><?php echo ($effort_display !== '') ? htmlspecialchars($effort_display) : ''; ?></td>
                    <td class="num"><?php echo ($classavg_display !== '') ? $classavg_display : ''; ?></td>
                </tr>
            <?php } // end while subjects ?>
            </tbody>
        </table>
    <?php else: ?>
        <div style="border:1px solid #000; padding:12px; margin-top:10px;">Oops!! No Marks Added Yet</div>
    <?php endif; ?>

    <!-- Grading legend (dynamic from DB or defaults) -->
    <table class="grading-table" aria-label="grading legend">
        <thead>
            <tr>
                <th class="grading-title" colspan="<?php echo max(1, count($grades)); ?>">Grading</th>
            </tr>
            <tr>
                <?php foreach ($grades as $g): ?>
                    <th><?php echo htmlspecialchars($g['label']); ?></th>
                <?php endforeach; ?>
            </tr>
        </thead>
        <tbody>
            <tr>
                <?php foreach ($grades as $g): ?>
                    <td><?php echo htmlspecialchars($g['range']); ?></td>
                <?php endforeach; ?>
            </tr>
        </tbody>
    </table>

    <!-- N/A note -->
    <div style="text-align:center; margin-top:8px; font-weight:700;">#N/A - Subject not taken or Subject not done. <br> Classwork - Tests/Homeworks/Assignments etc.</div>

    <!-- Effort box (table with header) -->
    <div class="effort-box" role="note" aria-label="effort descriptions">
        <div>
            <?php
            $geteffort = sq($con, "SELECT * FROM effort_types WHERE status='1' ORDER BY rank ASC");
            echo '<table class="effort-table" aria-label="effort descriptions">';
           
            echo '<thead><tr><th class="effort-title" colspan="2">Effort</th></tr></thead>';
            echo '<tbody>';
            while ($rowss = mysqli_fetch_array($geteffort)) {
                $effort_d = $rowss['description'];
                $rank = $rowss['rank'];
                echo '<tr>';
                echo '<td class="effort-num">' . htmlspecialchars(str_pad($rank, 2, ' ', STR_PAD_LEFT)) . '</td>';
                echo '<td class="effort-desc">' . nl2br(htmlspecialchars($effort_d)) . '</td>';
                echo '</tr>';
            }
            echo '</tbody>';
            echo '</table>';
            ?>
        </div>
    </div>

    <!-- Class teacher comments -->
    <div class="comments" id="teacher_comment" aria-labelledby="comments-heading">
        <h3 id="comments-heading">Class Tutor's Comments</h3>
        <div>
            <?php
            $getreports = sq($con, "SELECT * FROM subjecttermreports WHERE class_id='$class_id' AND term_id='$tm' AND student_id='$std' AND status=1 LIMIT 1");
            if (!$getreports || mysqli_num_rows($getreports) == 0) {
                echo '<p>No Comments</p>';
            } else {
                $r = mysqli_fetch_array($getreports);
                // Remove any HTML tags (including <p>, <span style=...>, etc.) then escape and preserve line breaks
                $cleanReport = strip_tags($r['report']);
                echo '<p>' . nl2br(htmlspecialchars($cleanReport)) . '</p>';
            }
            ?>
        </div>
    </div>

    <!-- Attendance -->
    <div style="display:flex; justify-content:center; gap:20px; margin-top:12px; align-items:center;">
        <table class="attendance" aria-label="attendance">
            <tbody>
                <tr>
                    <td>Total days in the Term</td>
                    <td style="text-align:center;"><?php echo intval($overall_days); ?></td>
                </tr>
                <tr>
                    <td>Number of days Late</td>
                    <td style="text-align:center;"><?php echo intval($present2); ?></td>
                </tr>
                <tr>
                    <td>Number of days Absent</td>
                    <td style="text-align:center;"><?php echo intval($absent); ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Signatures -->
    <div class="signatures" aria-label="signatures">
        <div style="text-align:center; font-weight:700; margin-bottom:8px;">Signed by</div>
        <div class="sign-row">
            <div class="sign-box">
                <div><?php echo htmlspecialchars($headteachername); ?></div>
                <?php if (!empty($hsign_ext) && !empty($staff_id2)): ?>
                    <img alt="Head teacher signature" src="<?php echo BASE_URL; ?>/images/nonteaching/<?php echo md5($staff_id2) . '.' . $hsign_ext ?>">
                <?php endif; ?>
                <div style="margin-top:6px;"><strong>Head Teacher</strong></div>
            </div>

            <div class="sign-box" style="text-align:right;">
                <div><?php echo htmlspecialchars($principalname); ?></div>
                <?php if (!empty($psign_ext) && !empty($staff_id3)): ?>
                    <img alt="Principal signature" src="<?php echo BASE_URL; ?>/images/nonteaching/<?php echo md5($staff_id3) . '.' . $psign_ext ?>">
                <?php endif; ?>
                <div style="margin-top:6px;"><strong>Principal</strong></div>
            </div>
        </div>
    </div>

    <!-- Important Notice -->
    <div class="notice" aria-label="important notice">
        <h4>Important Notice!</h4>
        <p><?php echo !empty($notice) ? nl2br(htmlspecialchars($notice)) : 'No Important Notice'; ?></p>
    </div>

    <!-- Report footer (outside report body so it can sit in the actual footer area) -->
</div>

<footer class="report-footer" role="contentinfo" aria-label="School motto and affiliation">
    <p>Training today's students for tomorrow's world</p>
    <p>A part of African Revival Ministries operating in Burundi, DR Congo, Senegal and UK.</p>
</footer>
</div>

<script>
(function(){
    function mmToPx(mm){ return mm * (96/25.4); }
    var pageInnerMm = 297 - (20 * 2);
    var pageInnerPx = mmToPx(pageInnerMm);
    var marginTopPx = mmToPx(20);
    var contentRoot = document.querySelector('.container.report') || document.querySelector('.container') || document.querySelector('.wrapper.wrapper-content') || document.querySelector('.wrapper');
    var layoutRoot = document.querySelector('.report-wrapper') || contentRoot;
    var footer = document.querySelector('.report-footer');
    if (!contentRoot || !footer || !layoutRoot) { window.print(); return; }
    if (window.getComputedStyle(layoutRoot).position === 'static') {
        layoutRoot.style.position = 'relative';
    }
    setTimeout(function(){
        var contentHeight = contentRoot.scrollHeight;
        var footerHeight = footer.offsetHeight || 40;
        var pages = Math.max(1, Math.ceil(contentHeight / pageInnerPx));
        if (pages <= 1) {
            footer.classList.add('report-footer-hidden');
        } else {
            footer.classList.remove('report-footer-hidden');
            var bottomGapPx = mmToPx(12);
            var topPx = marginTopPx + (pageInnerPx * pages) - footerHeight - bottomGapPx;
            footer.style.position = 'absolute';
            footer.style.top = topPx + 'px';
            footer.style.left = '0';
            footer.style.right = '0';
            footer.style.bottom = 'auto';
        }
        // Try to pin the effort box to the bottom of the first printable page
        try {
            var effort = document.querySelector('.effort-box');
            var comments = document.querySelector('.comments');
            if (effort) {
                // measure and compute top so effort sits near bottom of page 1
                var effortHeight = effort.offsetHeight || mmToPx(40);
                var effortGapPx = mmToPx(6);
                var effortTop = marginTopPx + pageInnerPx - effortHeight - effortGapPx;
                // ensure we only move it if it would otherwise be pushed to page > 1
                var effortRect = effort.getBoundingClientRect();
                var rootRect = contentRoot.getBoundingClientRect();
                var effortTopRelative = (effortRect.top - rootRect.top) + contentRoot.scrollTop;
                var effortPageIndex = Math.floor(effortTopRelative / pageInnerPx);
                if (effortPageIndex > 0) {
                    // Reserve space at the end of page 1 for the effort box so subject rows
                    // don't push it to page 2. We do this by adding a margin-bottom to the
                    // subject table equal to effort height + gap (print-only effect).
                    var subj = document.querySelector('.subject-table');
                    if (subj) {
                        try {
                            subj.style.marginBottom = (effortHeight + effortGapPx) + 'px';
                        } catch (e) {
                            // ignore
                        }
                    }

                    effort.style.position = 'absolute';
                    effort.style.top = effortTop + 'px';
                    effort.style.left = '0';
                    effort.style.right = '0';
                    effort.style.bottom = 'auto';

                    // ensure comments begin on next page
                    if (comments) {
                        comments.style.pageBreakBefore = 'always';
                        comments.style.breakBefore = 'page';
                        comments.style.marginTop = '0 !important';
                    }
                }
            }
        } catch (e) {
            console.warn('Effort positioning skipped:', e);
        }

        window.print();
    }, 200);
})();
</script>
</body>
</html>