<?php
include 'includes/conn.php';
if (session_status() === PHP_SESSION_NONE) session_start();
// Restrict access to admins/principals like the other attendance pages
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
    header('Location: login.php');
    exit;
}

// We only need to read session data here; release the session lock so parallel requests aren't blocked
if (session_status() === PHP_SESSION_ACTIVE) {
    @session_write_close();
}

$attendance_id = isset($_GET['attendance']) ? (int) $_GET['attendance'] : (isset($_GET['id']) ? (int) $_GET['id'] : 0);
if ($attendance_id <= 0) {
    echo "<p>Invalid attendance id.</p>";
    exit;
}

// Fetch attendance meta
$stmt = mysqli_prepare($con, "SELECT `teacherattendance_id`,`date`,`time`,`term_id` FROM `teacherattendance` WHERE `teacherattendance_id` = ? LIMIT 1");
if (!$stmt) {
    echo '<p>Unable to prepare query.</p>';
    exit;
}
mysqli_stmt_bind_param($stmt, 'i', $attendance_id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$att = $res ? mysqli_fetch_assoc($res) : null;
mysqli_stmt_close($stmt);
if (!$att) {
    echo '<p>Attendance record not found.</p>';
    exit;
}

$date_str = $att['date'] ?? '';
$time = $att['time'] ?? '';
$autoPrint = isset($_GET['print']) && ($_GET['print'] === '1' || $_GET['print'] === 'true');
$date_display = '';
if (!empty($date_str)) {
    if (is_numeric($date_str)) {
        $date_display = date('d/M/Y', (int)$date_str);
    } else {
        $dt = DateTime::createFromFormat('Y-m-d', $date_str);
        $date_display = $dt ? $dt->format('d/M/Y') : htmlspecialchars($date_str);
    }
}

function get_attendance_list($con, $attendance_id, $status) {
    $sql = "SELECT d.`teacher_id`, d.`details`, t.`fullname`, t.`gender` FROM `teacherattendancedetails` d LEFT JOIN `teachers` t ON d.teacher_id = t.teacher_id WHERE d.teacherattendance_id = ? AND d.status = ? ORDER BY t.fullname";
    $stmt = mysqli_prepare($con, $sql);
    $list = [];
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, 'ii', $attendance_id, $status);
        mysqli_stmt_execute($stmt);
        $res = mysqli_stmt_get_result($stmt);
        if ($res) {
            while ($r = mysqli_fetch_assoc($res)) $list[] = $r;
        }
        mysqli_stmt_close($stmt);
    }
    return $list;
}

$present = get_attendance_list($con, $attendance_id, 1);
$late = get_attendance_list($con, $attendance_id, 2);
$absent = get_attendance_list($con, $attendance_id, 0);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Teacher Attendance - <?php echo $date_display . ' ' . htmlspecialchars($time); ?></title>
    <style>
        body { font-family: Arial, sans-serif; color: #111; }
        h2 { margin-bottom: 4px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 18px; }
        th, td { padding: 6px 8px; border: 1px solid #ccc; text-align: left; }
        .section { margin-bottom: 18px; }
        @media print { .no-print { display:none } }
    </style>
</head>
<body>
    <div style="text-align: center; margin-bottom: 12px;">
        <h2>Teacher Attendance</h2>
        <div><?php echo htmlspecialchars($date_display . ' ' . $time); ?></div>
    </div>

    <div class="section">
        <h3>Present (<?php echo count($present); ?>)</h3>
        <table>
            <thead><tr><th>Fullname</th><th>Details</th></tr></thead>
            <tbody>
            <?php if (count($present) === 0): ?>
                <tr><td colspan="2">-</td></tr>
            <?php else: foreach ($present as $p): ?>
                <tr>
                    <td><?php echo htmlspecialchars($p['fullname'] ?? ''); ?></td>
                    <td><?php echo htmlspecialchars($p['details'] ?? ''); ?></td>
                </tr>
            <?php endforeach; endif; ?>
            </tbody>
        </table>
    </div>

    <div class="section">
        <h3>Late (<?php echo count($late); ?>)</h3>
        <table>
            <thead><tr><th>Fullname</th><th>Details</th></tr></thead>
            <tbody>
            <?php if (count($late) === 0): ?>
                <tr><td colspan="2">-</td></tr>
            <?php else: foreach ($late as $p): ?>
                <tr>
                    <td><?php echo htmlspecialchars($p['fullname'] ?? ''); ?></td>
                    <td><?php echo htmlspecialchars($p['details'] ?? ''); ?></td>
                </tr>
            <?php endforeach; endif; ?>
            </tbody>
        </table>
    </div>

    <div class="section">
        <h3>Absent (<?php echo count($absent); ?>)</h3>
        <table>
            <thead><tr><th>Fullname</th><th>Details</th></tr></thead>
            <tbody>
            <?php if (count($absent) === 0): ?>
                <tr><td colspan="2">-</td></tr>
            <?php else: foreach ($absent as $p): ?>
                <tr>
                    <td><?php echo htmlspecialchars($p['fullname'] ?? ''); ?></td>
                    <td><?php echo htmlspecialchars($p['details'] ?? ''); ?></td>
                </tr>
            <?php endforeach; endif; ?>
            </tbody>
        </table>
    </div>

    <div class="no-print" style="text-align:center; margin-top:18px;">
        <button onclick="window.print();">Print</button>
    </div>

    <script>
        (function(){
            var auto = <?php echo $autoPrint ? 'true' : 'false'; ?>;
            if (auto) {
                // Give the page a short moment to render, then open print dialog
                window.onload = function() {
                    try {
                        window.print();
                        // attempt to close the window after printing (may be blocked by some browsers)
                        setTimeout(function(){ try{ window.close(); }catch(e){} }, 700);
                    } catch (e) {
                        console.warn('Auto-print failed', e);
                    }
                };
            }
        })();
    </script>
</body>
</html>
