<?php
include 'includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
    header('Location:login.php');
    exit;
}
$id = isset($_GET['attendance']) ? (int)$_GET['attendance'] : 0;
if ($id <= 0) {
    die('Invalid attendance ID');
}
$attendance =  mysqli_query($con, "SELECT a.*, c.class FROM attendance a INNER JOIN classes c ON a.class_id = c.class_id WHERE a.status = 1 AND a.attendance_id ='$id'");
if (!$attendance || mysqli_num_rows($attendance) == 0) {
    die('Attendance record not found');
}
$row1 = mysqli_fetch_array($attendance);
$date_raw = $row1['date']; // Y-m-d format
$time = $row1['time'];
$attendance_id = $row1['attendance_id'];
$className = $row1['class'];

// Format date for display
$date_formatted = '';
if (!empty($date_raw)) {
    $date_obj = DateTime::createFromFormat('Y-m-d', $date_raw);
    $date_formatted = $date_obj ? $date_obj->format('d/M/Y') : $date_raw;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="ThemeBucket">
    <link rel="shortcut icon" href="#" type="image/png">

    <title>Attendance for <?php echo htmlspecialchars($date_formatted); ?></title>
    <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body style="background: #fff;">

    <!-- page start-->

    <div class="row">

        <div class="col-lg-10 col-lg-offset-1">

            <header class="panel-heading">
                <h2> Student attendance Report for <?php echo htmlspecialchars($date_formatted . ' ' . $time); ?> </h2>
            </header>
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <span> Attendees for <?php echo htmlspecialchars($date_formatted . ' ' . $time); ?> </span>
                        <span>&nbsp;&nbsp;&nbsp;</span><span>&nbsp;&nbsp;&nbsp;</span>
                        <span>CLASS:<?php $class3 = explode(" ", $className)[1];
                                echo $class3; ?></span>
                    </header>
                    <div class="panel-body">
                        <table class="display table  table-striped">
                            <thead>
                                <tr>
                                    <th>Fullname</th>
                                    <th>Gender</th>


                                </tr>
                            </thead>
                            <tbody>

                                <?php
                                $attendees =  mysqli_query($con, "SELECT * FROM attendancedetails WHERE attendance_id='$id' AND status=1") or die(mysqli_error($con));
                                while ($row1 = mysqli_fetch_array($attendees)) {
                                    $student_id = $row1['student_id'];
                                    $students =  mysqli_query($con, "SELECT * FROM students WHERE  student_id='$student_id'");
                                    $row = mysqli_fetch_array($students);
                                    $regnumber = $row['regnumber'];
                                    $student_id = $row['student_id'];
                                    $fullname = $row['fullname'];
                                    $gender = $row['gender'];

                                ?>
                                    <tr class="gradeA">
                                        <td>
                                            <?php echo $fullname; ?>
                                        </td>
                                        <td>
                                            <?php
                                            echo $gender;
                                            ?></td>


                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        Late for <?php echo htmlspecialchars($date_formatted . ' ' . $time); ?>
                    </header>
                    <div class="panel-body">
                        <table class="display table  table-striped">
                            <thead>
                                <tr>
                                    <th>Fullname</th>
                                    <th>Gender</th>
                                    <th>&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php
                                $attendees_l =  mysqli_query($con, "SELECT * FROM attendancedetails WHERE attendance_id='$id' AND status=2") or die(mysqli_error($con));
                                while ($row1 = mysqli_fetch_array($attendees_l)) {
                                    $student_id = $row1['student_id'];
                                    $details = $row1['details'];
                                    $students =  mysqli_query($con, "SELECT * FROM students WHERE  student_id='$student_id'");
                                    $row = mysqli_fetch_array($students);
                                    $regnumber = $row['regnumber'];
                                    $student_id = $row['student_id'];
                                    $fullname = $row['fullname'];
                                    $gender = $row['gender'];
                                ?>
                                    <tr class="gradeA">
                                        <td>
                                            <?php echo $fullname; ?>
                                        </td>
                                        <td>
                                            <?php
                                            echo $gender;
                                            ?></td>
                                        <td>
                                            <?php
                                            echo $details;
                                            ?></td>

                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
            </div>
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        Absentees for <?php echo htmlspecialchars($date_formatted . ' ' . $time); ?>
                    </header>
                    <div class="panel-body">
                        <table class="display table  table-striped">
                            <thead>
                                <tr>
                                    <th>Fullname</th>
                                    <th>Gender</th>
                                    <th>&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php
                                $attendees =  mysqli_query($con, "SELECT * FROM attendancedetails WHERE attendance_id='$id' AND status=0") or die(mysqli_error($con));
                                while ($row1 = mysqli_fetch_array($attendees)) {
                                    $student_id = $row1['student_id'];
                                    $details = $row1['details'];
                                    $students =  mysqli_query($con, "SELECT * FROM students WHERE  student_id='$student_id'");
                                    $row = mysqli_fetch_array($students);
                                    $regnumber = $row['regnumber'];
                                    $student_id = $row['student_id'];
                                    $fullname = $row['fullname'];
                                    $gender = $row['gender'];

                                ?>
                                    <tr class="gradeA">
                                        <td>
                                            <?php echo $fullname; ?>
                                        </td>

                                        <td>
                                            <?php
                                            echo $gender;
                                            ?></td>
                                        <td>
                                            <?php
                                            echo $details;
                                            ?></td>

                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>

        </div>

    </div>


    </div>

    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->

    <!-- Placed js at the end of the document so the pages load faster -->
    <script src="js/jquery-1.10.2.min.js"></script>
    <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="js/jquery-migrate-1.2.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/modernizr.min.js"></script>
    <script src="js/jquery.nicescroll.js"></script>
    <script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
    <script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
    <script src="js/dynamic_table_init.js"></script>
    <!--common scripts for all pages-->
    <script src="js/scripts.js"></script>
    <script type="text/javascript">
        window.print();
    </script>
</body>

</html>