<?php
include 'includes/conn.php';
include 'includes/roles.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);

if (!canViewFinancialReports($user_level)) {
    header('Location:login.php');
    exit();
}

$start_date = $_GET['start_date'] ?? date('Y-m-01');
$end_date = $_GET['end_date'] ?? date('Y-m-d');
$start_safe = mysqli_real_escape_string($con, $start_date);
$end_safe = mysqli_real_escape_string($con, $end_date);

// Try to detect payroll table/columns
$candidates = [
    'payroll_records' => ['amount' => ['amount','net_pay','gross_pay','amount_paid'], 'date' => ['date','payment_date','created_at']],
    'payroll' => ['amount' => ['amount','net_pay','gross_pay'], 'date' => ['date','payment_date','created_at']],
    'payroll_records' => ['amount' => ['amount','paid_amount'], 'date' => ['date','payment_date','created_at']],
    'payroll_records' => ['amount' => ['amount'], 'date' => ['date']]
];

function table_exists_local($con, $table){
    $t = mysqli_real_escape_string($con, $table);
    $r = @mysqli_query($con, "SHOW TABLES LIKE '".$t."'");
    return $r && mysqli_num_rows($r) > 0;
}

function find_column_local($con, $db, $table, $candidates){
    foreach ($candidates as $col){
        $colEsc = mysqli_real_escape_string($con, $col);
        $q = "SELECT COUNT(*) AS cnt FROM information_schema.COLUMNS WHERE TABLE_SCHEMA='".mysqli_real_escape_string($con,$db)."' AND TABLE_NAME='".mysqli_real_escape_string($con,$table)."' AND COLUMN_NAME='".$colEsc."'";
        $r = @mysqli_query($con, $q);
        if ($r){ $row = mysqli_fetch_assoc($r); if ((int)$row['cnt'] > 0) return $col; }
    }
    return false;
}

$dbNameRes = mysqli_query($con, "SELECT DATABASE() as db");
$dbName = $dbNameRes ? mysqli_fetch_assoc($dbNameRes)['db'] : '';

$payments = [];
$total_payroll = 0.0;

foreach ($candidates as $table => $map) {
    if (!table_exists_local($con, $table)) continue;
    $amountCol = find_column_local($con, $dbName, $table, $map['amount']);
    $dateCol = find_column_local($con, $dbName, $table, $map['date']);
    if (!$amountCol || !$dateCol) continue;

    // detect if date is int (unix) or date/datetime
    $isInt = false;
    $colInfo = @mysqli_query($con, "SHOW COLUMNS FROM `".mysqli_real_escape_string($con,$table)."` LIKE '".mysqli_real_escape_string($con,$dateCol)."'");
    if ($colInfo && ($ci = mysqli_fetch_assoc($colInfo))){ $type = strtolower($ci['Type'] ?? ''); if (strpos($type,'int') !== false) $isInt = true; }

    if ($isInt) {
        $dateExpr = "FROM_UNIXTIME(`".$dateCol."`)";
        $whereDate = "$dateExpr >= '$start_safe' AND $dateExpr <= '$end_safe'";
    } else {
        $dateExpr = "`".$dateCol."`";
        $whereDate = "DATE($dateExpr) >= '$start_safe' AND DATE($dateExpr) <= '$end_safe'";
    }

    $sql = "SELECT `".$amountCol."` AS amount, $dateExpr AS paid_at FROM `".mysqli_real_escape_string($con,$table)."` WHERE $whereDate";
    $r = @mysqli_query($con, $sql);
    if ($r){
        while ($row = mysqli_fetch_assoc($r)){
            $amount = (float) ($row['amount'] ?? 0);
            $date = $row['paid_at'] ?? '';
            if (is_numeric($date)) $date = date('Y-m-d H:i:s',(int)$date);
            $payments[] = ['amount' => $amount, 'date' => $date, 'source' => $table];
            $total_payroll += $amount;
        }
        break;
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Payroll Report</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-money"></i> Payroll Report: <?php echo htmlspecialchars($start_date); ?> — <?php echo htmlspecialchars($end_date); ?></h4>
                    </header>
                    <div class="panel-body">
                        <div class="row margin-bottom-20">
                            <div class="col-md-4">
                                <strong>Total Payroll Paid:</strong>
                                <h3 class="text-danger"><?php echo number_format($total_payroll,2); ?></h3>
                            </div>
                            <div class="col-md-8 text-right">
                                <a href="financialreports.php?start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>" class="btn btn-default">Back to Reports</a>
                            </div>
                        </div>

                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                    <th>Source</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($payments)) { ?>
                                    <tr><td colspan="4">No payroll records found for the selected period.</td></tr>
                                <?php } else { $i=1; foreach ($payments as $p) { ?>
                                    <tr>
                                        <td><?php echo $i++; ?></td>
                                        <td><?php echo number_format($p['amount'],2); ?></td>
                                        <td><?php echo htmlspecialchars($p['date']); ?></td>
                                        <td><?php echo htmlspecialchars($p['source']); ?></td>
                                    </tr>
                                <?php } } ?>
                            </tbody>
                        </table>

                    </div>
                </section>
            </div>
        </div>
    </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
