<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!hasFinancialAccess($_SESSION['schoolsyslevel'])) { header('Location:login.php'); exit; }

$payable_id = isset($_GET['payable_id']) ? (int)$_GET['payable_id'] : 0;
if ($payable_id <= 0) { header('Location: accountspayable.php'); exit; }

$neededTables = ['accounts_payable','payment_schedule'];
foreach ($neededTables as $tbl) {
    $check = mysqli_query($con, "SHOW TABLES LIKE '$tbl'");
    if (!$check || mysqli_num_rows($check) === 0) { die("$tbl table not found. Run create_accounting_tables.sql"); }
}

$payableQ = mysqli_query($con, "SELECT * FROM accounts_payable WHERE payable_id=$payable_id LIMIT 1");
$payable = mysqli_fetch_assoc($payableQ);
if (!$payable) { header('Location: accountspayable.php'); exit; }

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    if (!hasFullFinancialPermissions($_SESSION['schoolsyslevel'])) { $error = 'Not authorized to add schedule entries.'; }
    else {
        $payment_number = (int)($_POST['payment_number'] ?? 0);
        $scheduled_date = mysqli_real_escape_string($con, $_POST['scheduled_date'] ?? date('Y-m-d'));
        $amount_due = floatval($_POST['amount_due'] ?? 0);
        $payment_method_id = (int)($_POST['payment_method_id'] ?? 0);

        if ($payment_number <= 0) { $error = 'Payment number is required.'; }
        elseif ($amount_due <= 0) { $error = 'Amount due must be greater than zero.'; }
        else {
            $ins = mysqli_query($con, "INSERT INTO payment_schedule (payable_id, payment_number, scheduled_date, amount_due, payment_method_id, status) VALUES ($payable_id, $payment_number, '$scheduled_date', $amount_due, $payment_method_id, 'Pending')");
            if ($ins) { $message = 'Schedule entry added.'; }
            else { $error = 'Insert failed: ' . mysqli_error($con); }
        }
    }
}

$scheduleRes = mysqli_query($con, "SELECT ps.*, pm.method_name FROM payment_schedule ps LEFT JOIN payment_methods pm ON ps.payment_method_id = pm.payment_method_id WHERE ps.payable_id = $payable_id ORDER BY ps.payment_number ASC");

$methods = mysqli_query($con, "SELECT payment_method_id, method_name FROM payment_methods WHERE status=1 ORDER BY method_name");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Payment Schedule</title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
  <link rel="stylesheet" href="js/advanced-datatable/css/demo_page.css" />
  <link rel="stylesheet" href="js/advanced-datatable/css/demo_table.css" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-12">
        <section class="panel">
          <header class="panel-heading">
            <h4 class="panel-title"><i class="fa fa-calendar"></i> Payment Schedule for <?php echo htmlspecialchars($payable['invoice_number']); ?></h4>
            <div style="margin-top:8px;">
              <a href="accountspayable.php" class="btn btn-default btn-sm">Back</a>
            </div>
          </header>
          <div class="panel-body">
            <?php if ($message) echo '<div class="alert alert-success">' . htmlspecialchars($message) . '</div>'; ?>
            <?php if ($error) echo '<div class="alert alert-danger">' . htmlspecialchars($error) . '</div>'; ?>

            <div class="adv-table">
              <table class="display table table-striped" id="dynamic-table">
                <thead>
                  <tr>
                    <th>Payment #</th>
                    <th>Scheduled Date</th>
                    <th>Amount Due</th>
                    <th>Amount Paid</th>
                    <th>Payment Date</th>
                    <th>Method</th>
                    <th>Status</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if ($scheduleRes && mysqli_num_rows($scheduleRes) > 0) {
                    while ($s = mysqli_fetch_assoc($scheduleRes)) {
                      echo '<tr>' .
                        '<td>' . (int)$s['payment_number'] . '</td>' .
                        '<td>' . htmlspecialchars($s['scheduled_date']) . '</td>' .
                        '<td>' . number_format($s['amount_due'],2) . '</td>' .
                        '<td>' . number_format($s['amount_paid'] ?? 0,2) . '</td>' .
                        '<td>' . htmlspecialchars($s['payment_date'] ?? '-') . '</td>' .
                        '<td>' . htmlspecialchars($s['method_name'] ?? '-') . '</td>' .
                        '<td>' . htmlspecialchars($s['status']) . '</td>' .
                        '<td>' . (hasFullFinancialPermissions($_SESSION['schoolsyslevel']) ? '<a href="editpaymentschedule.php?id=' . $s['schedule_id'] . '" class="btn btn-info btn-xs">Edit</a> <a href="deletepaymentschedule.php?id=' . $s['schedule_id'] . '" class="btn btn-danger btn-xs" onclick="return confirm(\'Are you sure?\')">Delete</a>' : '-') . '</td>' .
                        '</tr>';
                    }
                  } else {
                    echo '<tr><td colspan="8" class="text-center">No schedule entries found</td></tr>';
                  } ?>
                </tbody>
              </table>
            </div>

            <?php if (hasFullFinancialPermissions($_SESSION['schoolsyslevel'])): ?>
            <hr>
            <h4>Add Schedule Entry</h4>
            <form method="post" class="form-inline">
              <input type="hidden" name="action" value="add">
              <div class="form-group">
                <label>Payment #</label>
                <input type="number" name="payment_number" class="form-control" required style="width:100px; margin-right:8px;">
              </div>
              <div class="form-group">
                <label>Scheduled Date</label>
                <input type="date" name="scheduled_date" value="<?php echo date('Y-m-d'); ?>" class="form-control" style="margin-right:8px;">
              </div>
              <div class="form-group">
                <label>Amount</label>
                <input type="number" step="0.01" name="amount_due" class="form-control" required style="width:120px; margin-right:8px;">
              </div>
              <div class="form-group">
                <label>Method</label>
                <select name="payment_method_id" class="form-control" style="margin-right:8px;">
                  <option value="0">--</option>
                  <?php while ($m = mysqli_fetch_assoc($methods)) { echo '<option value="' . (int)$m['payment_method_id'] . '">' . htmlspecialchars($m['method_name']) . '</option>'; } ?>
                </select>
              </div>
              <button type="submit" class="btn btn-primary">Add</button>
            </form>
            <?php endif; ?>

          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
</body>
</html>
