<?php
session_start();
include 'includes/conn.php';
include 'includes/roles.php';

// Only Super Admin can manage tax brackets
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if ($user_level !== 1) {
    header('Location: index.php');
    exit;
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        if ($_POST['action'] === 'add') {
            $bracket_name = mysqli_real_escape_string($con, $_POST['bracket_name'] ?? '');
            $min_amount = (float) ($_POST['min_amount'] ?? 0);
            $max_amount = !empty($_POST['max_amount']) ? (float) $_POST['max_amount'] : NULL;
            $rate = (float) ($_POST['rate'] ?? 0);
            $effective_date = mysqli_real_escape_string($con, $_POST['effective_date'] ?? date('Y-m-d'));
            $notes = mysqli_real_escape_string($con, $_POST['notes'] ?? '');

            $max_sql = $max_amount !== NULL ? "'$max_amount'" : "NULL";
            // Ensure created_by is always an integer (fallback to 0)
            $created_by = (int) ($_SESSION['schooladminsyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
            $insert = "INSERT INTO paye_tax_brackets (bracket_name, min_amount, max_amount, rate, effective_date, notes, created_by) ";
            $insert .= "VALUES ('$bracket_name', $min_amount, $max_sql, $rate, '$effective_date', '$notes', $created_by)";
            
            if (mysqli_query($con, $insert)) {
                $_SESSION['message'] = 'Tax bracket added successfully';
            } else {
                $_SESSION['error'] = 'Error adding tax bracket: ' . mysqli_error($con);
            }
            header('Location: payetaxbrackets.php');
            exit;
        } elseif ($_POST['action'] === 'edit') {
            $bracket_id = (int) ($_POST['bracket_id'] ?? 0);
            $bracket_name = mysqli_real_escape_string($con, $_POST['bracket_name'] ?? '');
            $min_amount = (float) ($_POST['min_amount'] ?? 0);
            $max_amount = !empty($_POST['max_amount']) ? (float) $_POST['max_amount'] : NULL;
            $rate = (float) ($_POST['rate'] ?? 0);
            $effective_date = mysqli_real_escape_string($con, $_POST['effective_date'] ?? date('Y-m-d'));
            $notes = mysqli_real_escape_string($con, $_POST['notes'] ?? '');
            $status = (int) ($_POST['status'] ?? 1);
            
            $max_sql = $max_amount !== NULL ? "'$max_amount'" : "NULL";
            $update = "UPDATE paye_tax_brackets SET 
                       bracket_name='$bracket_name', min_amount=$min_amount, max_amount=$max_sql, 
                       rate=$rate, effective_date='$effective_date', notes='$notes', status=$status 
                       WHERE bracket_id=$bracket_id";
            
            if (mysqli_query($con, $update)) {
                $_SESSION['message'] = 'Tax bracket updated successfully';
            } else {
                $_SESSION['error'] = 'Error updating tax bracket: ' . mysqli_error($con);
            }
            header('Location: payetaxbrackets.php');
            exit;
        } elseif ($_POST['action'] === 'delete') {
            $bracket_id = (int) ($_POST['bracket_id'] ?? 0);
            $delete = "UPDATE paye_tax_brackets SET status=0 WHERE bracket_id=$bracket_id";
            
            if (mysqli_query($con, $delete)) {
                $_SESSION['message'] = 'Tax bracket deactivated successfully';
            } else {
                $_SESSION['error'] = 'Error deactivating tax bracket: ' . mysqli_error($con);
            }
            header('Location: payetaxbrackets.php');
            exit;
        }
    }
}

// Fetch one latest active tax bracket per bracket_name to avoid duplicate display
$query = "SELECT p.* FROM paye_tax_brackets p 
          WHERE p.bracket_id IN (
              SELECT MAX(bracket_id) FROM paye_tax_brackets WHERE status=1 GROUP BY bracket_name
          )
          ORDER BY p.min_amount ASC";
$result = mysqli_query($con, $query);
?>
<!DOCTYPE html>
<html>
<head>
    <?php include 'includes/htmlhead.php'; ?>
    <title>PAYE Tax Brackets - School Manager</title>
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    
    <section class="wrapper">
        <section class="section">
            <div class="row">
                <div class="col-lg-12">
                    <section class="panel">
                        <header class="panel-heading">
                            <h4 class="panel-title"><i class="fa fa-calculator"></i> Kenya PAYE Tax Brackets Management</h4>
                        </header>
                        
                        <div class="panel-body">
                            <?php if (isset($_SESSION['message'])): ?>
                                <div class="alert alert-success alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    <?php echo htmlspecialchars($_SESSION['message']); unset($_SESSION['message']); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (isset($_SESSION['error'])): ?>
                                <div class="alert alert-danger alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    <?php echo htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?>
                                </div>
                            <?php endif; ?>
                            
                            <div class="alert alert-info">
                                <strong>Note:</strong> These are PAYE tax brackets. Update these when the relevant authority announces new rates. The system will automatically use the active brackets with the most recent effective date for payroll calculations.
                            </div>
                            
                            <button type="button" class="btn btn-primary btn-sm margin-bottom-10" data-toggle="modal" data-target="#addBracketModal">
                                <i class="fa fa-plus"></i> Add New Tax Bracket
                            </button>
                            
                            <div class="table-responsive">
                                <table class="table table-striped table-hover" id="taxBracketsTable">
                                    <thead>
                                        <tr>
                                            <th>Bracket Name</th>
                                            <th>Min Amount (BIF)</th>
                                            <th>Max Amount (BIF)</th>
                                            <th>Rate (%)</th>
                                            <th>Effective Date</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if ($result && mysqli_num_rows($result) > 0): ?>
                                            <?php while ($row = mysqli_fetch_assoc($result)): ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars($row['bracket_name']); ?></td>
                                                    <td><?php echo number_format($row['min_amount'], 2); ?></td>
                                                    <td><?php echo $row['max_amount'] !== NULL ? number_format($row['max_amount'], 2) : 'No Limit'; ?></td>
                                                    <td><?php echo number_format($row['rate'], 2); ?>%</td>
                                                    <td><?php echo date('M d, Y', strtotime($row['effective_date'])); ?></td>
                                                    <td>
                                                        <?php if ($row['status'] == 1): ?>
                                                            <span class="label label-success">Active</span>
                                                        <?php else: ?>
                                                            <span class="label label-default">Inactive</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-info btn-xs" onclick='editBracket(<?php echo json_encode($row, JSON_HEX_TAG|JSON_HEX_APOS|JSON_HEX_QUOT); ?>)'>
                                                            <i class="fa fa-edit"></i> Edit
                                                        </button>
                                                        <?php if ($row['status'] == 1): ?>
                                                            <form method="POST" style="display:inline;" onsubmit="return confirm('Deactivate this tax bracket?');">
                                                                <input type="hidden" name="action" value="delete">
                                                                <input type="hidden" name="bracket_id" value="<?php echo $row['bracket_id']; ?>">
                                                                <button type="submit" class="btn btn-danger btn-xs">
                                                                    <i class="fa fa-ban"></i> Deactivate
                                                                </button>
                                                            </form>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endwhile; ?>
                                        <?php else: ?>
                                            <tr><td colspan="7" class="text-center">No tax brackets found. Please add the current tax rates.</td></tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </section>
    </section>
    
    <!-- Add Tax Bracket Modal -->
    <div class="modal fade" id="addBracketModal" tabindex="-1" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Add New Tax Bracket</h4>
                </div>
                <form method="POST">
                    <input type="hidden" name="action" value="add">
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Bracket Name *</label>
                           <input type="text" name="bracket_name" class="form-control" placeholder="e.g., Band 1: Up to BIF 24,000" required>
                        </div>
                        <div class="form-group">
                           <label>Minimum Amount (BIF) *</label>
                           <input type="number" name="min_amount" class="form-control" step="0.01" min="0" placeholder="0.00" required>
                        </div>
                        <div class="form-group">
                           <label>Maximum Amount (BIF) <small>(leave empty for no limit)</small></label>
                           <input type="number" name="max_amount" class="form-control" step="0.01" min="0" placeholder="Leave empty for unlimited">
                        </div>
                        <div class="form-group">
                            <label>Tax Rate (%) *</label>
                            <input type="number" name="rate" class="form-control" step="0.01" min="0" max="100" placeholder="10.00" required>
                        </div>
                        <div class="form-group">
                            <label>Effective Date *</label>
                            <input type="date" name="effective_date" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
                        </div>
                        <div class="form-group">
                            <label>Notes</label>
                            <textarea name="notes" class="form-control" rows="2" placeholder="Additional information"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save Tax Bracket</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Edit Bracket Modal -->
    <div class="modal fade" id="editBracketModal" tabindex="-1" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Edit Tax Bracket</h4>
                </div>
                <form method="POST">
                    <input type="hidden" name="action" value="edit">
                    <input type="hidden" name="bracket_id" id="edit_bracket_id">
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Bracket Name *</label>
                            <input type="text" name="bracket_name" id="edit_bracket_name" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label>Minimum Amount (BIF) *</label>
                               <input type="number" name="min_amount" id="edit_min_amount" class="form-control" step="0.01" min="0" required>
                        </div>
                        <div class="form-group">
                               <label>Maximum Amount (BIF)</label>
                               <input type="number" name="max_amount" id="edit_max_amount" class="form-control" step="0.01" min="0">
                        </div>
                        <div class="form-group">
                            <label>Tax Rate (%) *</label>
                            <input type="number" name="rate" id="edit_rate" class="form-control" step="0.01" min="0" max="100" required>
                        </div>
                        <div class="form-group">
                            <label>Effective Date *</label>
                            <input type="date" name="effective_date" id="edit_effective_date" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label>Status</label>
                            <select name="status" id="edit_status" class="form-control">
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Notes</label>
                            <textarea name="notes" id="edit_notes" class="form-control" rows="2"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Update Tax Bracket</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
    
    <?php include 'includes/footer.php'; ?>
    <script src="js/jquery-1.11.3.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <!-- Removed missing/unused scripts to avoid 404s: dcjqaccordion, scrollTo, slimScroll -->
    <script src="js/jquery.nicescroll.js"></script>
    <script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
    <script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
    
    <script>
    $(document).ready(function() {
        var $table = $('#taxBracketsTable');
        // Ensure each tbody row has same number of cells as the header to avoid DataTables errors
        var headerCount = $table.find('thead th').length;
        $table.find('tbody tr').each(function() {
            var $cells = $(this).children('td, th');
            var diff = headerCount - $cells.length;
            for (var i = 0; i < diff; i++) {
                $(this).append('<td></td>');
            }
        });

        $table.DataTable({
            "order": [[4, "desc"]],
            "columnDefs": [
                { "orderable": false, "targets": -1 },
                { "searchable": false, "targets": -1 }
            ]
        });
    });
    
    function editBracket(bracket) {
        $('#edit_bracket_id').val(bracket.bracket_id);
        $('#edit_bracket_name').val(bracket.bracket_name);
        $('#edit_min_amount').val(bracket.min_amount);
        $('#edit_max_amount').val(bracket.max_amount || '');
        $('#edit_rate').val(bracket.rate);
        $('#edit_effective_date').val(bracket.effective_date);
        $('#edit_status').val(bracket.status);
        $('#edit_notes').val(bracket.notes || '');
        $('#editBracketModal').modal('show');
    }
    </script>
</body>
</html>
