<?php
session_start();
include 'includes/conn.php';
include 'includes/roles.php';
include 'includes/paye_calculator.php';

$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if ($user_level !== 1 && !hasFinancialAccess($user_level)) {
    header('Location: index.php');
    exit;
}

$calculation = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['calculate'])) {
    $grossSalary = !empty($_POST['gross_salary']) ? (float) $_POST['gross_salary'] : 0;
    $nssf = !empty($_POST['nssf']) ? (float) $_POST['nssf'] : 0;
    $nhif = !empty($_POST['nhif']) ? (float) $_POST['nhif'] : 0;
    $housingLevy = !empty($_POST['housing_levy']) ? (float) $_POST['housing_levy'] : 0;
    
    $calculation = calculateNetSalary($grossSalary, $nssf, $con, $nhif, $housingLevy);
}

$taxBrackets = getActiveTaxBrackets($con);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="ThemeBucket">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>PAYE Calculator - School Manager</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
    <style>
        .calc-result { background: #f9f9f9; border: 2px solid #5bc0de; padding: 20px; border-radius: 5px; }
        .calc-summary { font-size: 18px; margin-bottom: 15px; }
        .breakdown-table { margin-top: 15px; }
        .tax-bracket-info { background: #fff3cd; border-left: 4px solid #ffc107; padding: 10px; margin-bottom: 20px; }
    </style>
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    
    <section class="wrapper">
        <section class="section">
            <div class="row">
                <div class="col-lg-8 col-lg-offset-2">
                    <section class="panel">
                        <header class="panel-heading">
                            <h4 class="panel-title"><i class="fa fa-calculator"></i> PAYE Tax Calculator (2025)</h4>
                        </header>
                        
                        <div class="panel-body">
                            <div class="tax-bracket-info">
                                <h5><i class="fa fa-info-circle"></i> Current Tax Brackets:</h5>
                                <ul>
                                    <?php foreach ($taxBrackets as $bracket): ?>
                                    <li>
                                        <strong><?php echo htmlspecialchars($bracket['bracket_name']); ?>:</strong>
                                        BIF <?php echo number_format($bracket['min_amount'], 2); ?> 
                                        <?php if ($bracket['max_amount']): ?>
                                            - BIF <?php echo number_format($bracket['max_amount'], 2) ?>
                                        <?php else: ?>
                                            and above
                                        <?php endif; ?>
                                        = <?php echo $bracket['rate']; ?>% tax
                                    </li>
                                    <?php endforeach; ?>
                                </ul>
                                <small class="text-muted">
                                    <i class="fa fa-wrench"></i> Tax brackets can be updated by Super Admin in 
                                    <a href="payetaxbrackets.php">PAYE Tax Brackets Management</a>
                                </small>
                            </div>
                            
                            <form method="POST" class="form-horizontal">
                                <h4>Enter Salary Details:</h4>
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Gross Salary (BIF) *</label>
                                    <div class="col-sm-8">
                                        <input type="number" name="gross_salary" class="form-control" step="0.01" min="0" required 
                                               value="<?php echo isset($_POST['gross_salary']) ? htmlspecialchars($_POST['gross_salary']) : ''; ?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">NSSF Contribution (BIF)</label>
                                    <div class="col-sm-8">
                                        <input type="number" name="nssf" class="form-control" step="0.01" min="0"
                                               value="<?php echo isset($_POST['nssf']) ? htmlspecialchars($_POST['nssf']) : '0'; ?>">
                                        <small class="text-muted">National Social Security Fund (pre-tax deduction)</small>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">NHIF Contribution (BIF)</label>
                                    <div class="col-sm-8">
                                        <input type="number" name="nhif" class="form-control" step="0.01" min="0"
                                               value="<?php echo isset($_POST['nhif']) ? htmlspecialchars($_POST['nhif']) : '0'; ?>">
                                        <small class="text-muted">National Hospital Insurance Fund (post-tax deduction)</small>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Housing Levy (BIF)</label>
                                    <div class="col-sm-8">
                                        <input type="number" name="housing_levy" class="form-control" step="0.01" min="0"
                                               value="<?php echo isset($_POST['housing_levy']) ? htmlspecialchars($_POST['housing_levy']) : '0'; ?>">
                                        <small class="text-muted">Affordable Housing Levy (typically 1.5% of gross)</small>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="col-sm-offset-4 col-sm-8">
                                        <button type="submit" name="calculate" class="btn btn-primary btn-lg">
                                            <i class="fa fa-calculator"></i> Calculate PAYE & Net Salary
                                        </button>
                                    </div>
                                </div>
                            </form>
                            
                            <?php if ($calculation): ?>
                            <hr>
                            <div class="calc-result">
                                <h4><i class="fa fa-check-circle text-success"></i> Calculation Results:</h4>
                                
                                <?php if ($calculation['error']): ?>
                                    <div class="alert alert-danger">
                                        <strong>Error:</strong> <?php echo htmlspecialchars($calculation['error']); ?>
                                    </div>
                                <?php else: ?>
                                    <div class="calc-summary">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <p><strong>Gross Salary:</strong> BIF <?php echo number_format($calculation['gross_salary'], 2); ?></p>
                                                <p><strong>NSSF:</strong> - BIF <?php echo number_format($calculation['nssf'], 2); ?></p>
                                                <p><strong>Taxable Income:</strong> BIF <?php echo number_format($calculation['taxable_income'], 2); ?></p>
                                                <p><strong>PAYE Tax:</strong> - BIF <?php echo number_format($calculation['paye'], 2); ?></p>
                                                <p><strong>NHIF:</strong> - BIF <?php echo number_format($calculation['nhif'], 2); ?></p>
                                                <p><strong>Housing Levy:</strong> - BIF <?php echo number_format($calculation['housing_levy'], 2); ?></p>
                                            </div>
                                            <div class="col-md-6 text-right">
                                                <div style="background:#5cb85c;color:white;padding:20px;border-radius:5px;">
                                                    <h3 style="margin:0;">NET SALARY</h3>
                                                    <h2 style="margin:10px 0;">BIF <?php echo number_format($calculation['net_salary'], 2); ?></h2>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <?php if (!empty($calculation['paye_breakdown'])): ?>
                                    <div class="breakdown-table">
                                        <h5>PAYE Breakdown by Tax Bracket:</h5>
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Tax Bracket</th>
                                                    <th>Rate</th>
                                                    <th>Taxable Amount</th>
                                                    <th>Tax</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($calculation['paye_breakdown'] as $band): ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars($band['bracket_name']); ?></td>
                                                    <td><?php echo $band['rate']; ?>%</td>
                                                    <td>BIF <?php echo number_format($band['taxable_amount'], 2); ?></td>
                                                    <td>BIF <?php echo number_format($band['tax'], 2); ?></td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th colspan="3" class="text-right">Total PAYE:</th>
                                                    <th>BIF <?php echo number_format($calculation['paye'], 2); ?></th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </section>
                </div>
            </div>
        </section>
    </section>
</section>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>
