<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsys']) || (int)$_SESSION['schoolsyslevel'] !== 1) {
  header('Location: login.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Manage Important Notices | School Manager</title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>

<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>

  <section class="wrapper">
    <div class="row">
      <div class="col-lg-12">
        <section class="panel">
          <header class="panel-heading">
            Manage Important Notices
            <span class="tools pull-right">
              <a class="btn btn-success btn-sm" href="addnotice.php"><i class="fa fa-plus"></i> Add New Notice</a>
            </span>
          </header>
          <div class="panel-body">
            <table class="display table table-striped" id="dynamic-table">
              <thead>
                <tr>
                  <th style="width: 10%;">Term</th>
                  <th style="width: 15%;">Academic Year</th>
                  <th style="width: 45%;">Important Notice</th>
                  <th style="width: 10%;">Status</th>
                  <th style="width: 20%;">Action</th>
                </tr>
              </thead>
              <tbody>
                <?php
                $stmt = mysqli_prepare($con, "SELECT financialterm_id, term, year, academic_year, important_notice, status FROM financialterms ORDER BY academic_year DESC, term DESC");
                if ($stmt) {
                  mysqli_stmt_execute($stmt);
                  $result = mysqli_stmt_get_result($stmt);
                  
                  while ($row = mysqli_fetch_assoc($result)) {
                    $id = (int)$row['financialterm_id'];
                    $term = (int)$row['term'];
                    $year = $row['year'] ?? '';
                    $acad_year = $row['academic_year'] ?? '';
                    $notice = $row['important_notice'] ?? '';
                    $status = (int)$row['status'];
                    
                    // Truncate notice for display
                    $notice_preview = strlen($notice) > 100 ? substr($notice, 0, 100) . '...' : $notice;
                    $status_badge = $status == 1 ? '<span class="badge badge-success">Active</span>' : '<span class="badge badge-default">Inactive</span>';
                ?>
                <tr>
                  <td>Term <?php echo $term; ?></td>
                  <td><?php echo htmlspecialchars($acad_year); ?></td>
                  <td><?php echo !empty($notice) ? htmlspecialchars($notice_preview) : '<em class="text-muted">No notice set</em>'; ?></td>
                  <td><?php echo $status_badge; ?></td>
                  <td>
                    <a href="viewnotice.php?id=<?php echo $id; ?>" class="btn btn-info btn-xs" title="View"><i class="fa fa-eye"></i> View</a>
                    <a href="editnotice.php?id=<?php echo $id; ?>" class="btn btn-primary btn-xs" title="Edit"><i class="fa fa-edit"></i> Edit</a>
                    <a href="deletenotice.php?id=<?php echo $id; ?>" class="btn btn-danger btn-xs" onclick="return confirm('Are you sure you want to delete this notice?');" title="Delete"><i class="fa fa-trash"></i> Delete</a>
                  </td>
                </tr>
                <?php
                  }
                  mysqli_stmt_close($stmt);
                } else {
                  echo '<tr><td colspan="5" class="text-center text-danger">Error loading notices</td></tr>';
                }
                ?>
              </tbody>
            </table>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>

<script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>
</html>
