<?php
include 'includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
   header('Location:login.php');
   exit;
}
?>
<!DOCTYPE html>
<html>

<head>

   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">

   <title>View Marks-School Manager</title>
   <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
   <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
   <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
   <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
   <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
   <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
   <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
   <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
   <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
   <!--common-->

   <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
   <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
   <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->

   <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="sticky-header">
   <section>
      <?php include 'includes/header.php'; ?>

      <section class="wrapper">
         <!-- page start-->

         <div class="row">

            <div class="col-lg-8">
               <section class="panel">
                  <header class="panel-heading">
                     Assessment Details
                  </header>
                  <div class="panel-body">
                     <?php
                     $class_id = $_GET['class'];
                     $as = $_GET['as'];
                     $term = $_GET['term'];
                     $getclasses =  mysqli_query($con, "SELECT * FROM classes WHERE class_id='$class_id'");
                     $row2 =  mysqli_fetch_array($getclasses);
                     $class2 = $row2['class'];
                     $category_id = $row2['category_id'];
                     $getterm =  mysqli_query($con, "SELECT  * FROM financialterms WHERE financialterm_id='$term'");
                     $row4 =  mysqli_fetch_array($getterm);
                     $term2 = $row4['term'];
                     $year = $row4['year'];
                     $gettypes = mysqli_query($con, "SELECT * FROM assessmenttypes WHERE assessmenttype_id='$as'");
                     $row = mysqli_fetch_array($gettypes);
                     $type_id = $row['assessmenttype_id'];
                     $assessment = $row['assessmenttype'];
                     ?>
                     <table class="display table  table-striped" id="dynamic-table">
                        <tbody>

                           <tr class="gradeA">
                              <th>Assessment</th>
                              <td><?php echo $assessment; ?></td>
                           </tr>
                           <tr class="gradeA">
                              <th>Class</th>
                              <td><?php echo $class2; ?></td>
                           </tr>

                           <tr class="gradeA">
                              <th> Term</th>
                              <td><?php echo $term2 . ' ' . $year; ?></td>
                           </tr>

                        </tbody>
                     </table>


                  </div>
               </section>
            </div>
            <div class="col-lg-12 col-md-auto">
               <section class="panel">
                  <header class="panel-heading">
                     Student Marks
                  </header>
                  <div class="panel-body">

                     <?php
                     // Show one column per subject: aggregate marks per student+subject and scale to 40/60
                     $subjects_res = mysqli_query($con, "SELECT * FROM subjects WHERE status=1 ORDER BY subject");
                     $subjects = [];
                     if ($subjects_res) {
                        while ($sr = mysqli_fetch_assoc($subjects_res)) {
                           $subjects[] = $sr;
                        }
                     }

                     // get assessment name
                     $atype_res = mysqli_query($con, "SELECT assessmenttype FROM assessmenttypes WHERE assessmenttype_id='$as' LIMIT 1");
                     $assessment_name = '';
                     if ($atype_res && mysqli_num_rows($atype_res) > 0) {
                        $arow = mysqli_fetch_assoc($atype_res);
                        $assessment_name = $arow['assessmenttype'];
                     }
                     $is_exam = false;
                     if (!empty($assessment_name)) {
                        $assessment_lower = strtolower($assessment_name);
                        $is_exam = (strpos($assessment_lower, 'exam') !== false);
                     }
                     $target_max = $is_exam ? 60.0 : 40.0;

                     // fetch students in class
                     $students_res = mysqli_query($con, "SELECT * FROM students WHERE class_id='$class_id' ORDER BY fullname");
                     if ($students_res && mysqli_num_rows($students_res) > 0 && !empty($subjects)) {
                     ?>
                        <div style="overflow-x:auto;">
                           <table class="table table-striped table-bordered table-hover dataTables-example" style="width:100%">
                              <thead>
                                 <tr>
                                    <th>Student</th>
                                    <?php foreach ($subjects as $sub) { ?><th><?php echo htmlspecialchars($sub['subject'], ENT_QUOTES); ?></th><?php } ?>
                                 </tr>
                              </thead>
                              <tbody>
                                 <?php
                                 while ($st = mysqli_fetch_assoc($students_res)) {
                                    $sid = $st['student_id'];
                                    $fullname = $st['fullname'];
                                 ?>
                                    <tr class="gradeA">
                                       <td><?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></td>
                                       <?php
                                       foreach ($subjects as $sub) {
                                          $subject_id = $sub['subject_id'];
                                          $q = mysqli_query($con, "SELECT SUM(marks) AS totalmarks, SUM(rank) AS totalranks FROM marks WHERE class_id='$class_id' AND student_id='$sid' AND term_id='$term' AND subject_id='$subject_id' AND assessment='$as' AND status=1");
                                          $tmarks = 0.0; $tranks = 0.0;
                                          if ($q && mysqli_num_rows($q) > 0) {
                                             $rr = mysqli_fetch_assoc($q);
                                             $tmarks = is_numeric($rr['totalmarks']) ? (float)$rr['totalmarks'] : 0.0;
                                             $tranks = is_numeric($rr['totalranks']) ? (float)$rr['totalranks'] : 0.0;
                                          }
                                          if ($tranks <= 0) { $tranks = ($tmarks > 0) ? $tmarks : 0.0; }
                                          if ($tranks > 0) {
                                             $scaled = ($tmarks / $tranks) * $target_max;
                                             $scaled_fmt = number_format($scaled, 1);
                                             echo '<td>' . htmlspecialchars($scaled_fmt . '/' . intval($target_max), ENT_QUOTES) . '</td>';
                                          } else {
                                             echo '<td>-</td>';
                                          }
                                       }
                                       ?>
                                    </tr>
                                 <?php } ?>
                              </tbody>
                           </table>
                        </div>
                     <?php } else { ?>
                        <div class="alert alert-danger">Oops!! No Marks Added Yet</div>
                     <?php } ?>

                  </div>
               </section>
            </div>

         </div>
         </div>

         </div>


         </div>
         <!-- page end-->
      </section>
      <!--body wrapper end-->

      <!--footer section start-->

      <!--footer section end-->


      </div>
      <!-- main content end-->
   </section>
   <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
   <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
   <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
   <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
   <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
   <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
   <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
   <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
   <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
   <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
   <!--common scripts for all pages-->
   <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
   <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
   <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
   <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>

</body>

</html>