<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }

// Only users who can approve payments may mark payable as paid
if (!canApprovePayments($_SESSION['schoolsyslevel'])) {
    header('Location:login.php');
    exit;
}

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
    header('Location: accountspayable.php');
    exit;
}

// Fetch payable
$stmt = mysqli_prepare($con, "SELECT payable_id, amount, amount_paid, status FROM accounts_payable WHERE payable_id = ? LIMIT 1");
if (!$stmt) { header('Location: accountspayable.php'); exit; }
mysqli_stmt_bind_param($stmt, 'i', $id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$payable = mysqli_fetch_assoc($res);
mysqli_stmt_close($stmt);

if (!$payable) {
    header('Location: accountspayable.php');
    exit;
}

// Only allow marking paid when status is Approved (defensive)
if ($payable['status'] !== 'Approved') {
    $_SESSION['message'] = 'Only approved payables can be marked as paid.';
    $_SESSION['msg_type'] = 'warning';
    header('Location: accountspayable.php');
    exit;
}

// Mark as paid: set amount_paid = amount and status = 'Paid'
$update = mysqli_prepare($con, "UPDATE accounts_payable SET amount_paid = ?, status = 'Paid', updated_at = CURRENT_TIMESTAMP WHERE payable_id = ?");
if ($update) {
    $amount = (float)$payable['amount'];
    mysqli_stmt_bind_param($update, 'di', $amount, $id);
    if (mysqli_stmt_execute($update)) {
        mysqli_stmt_close($update);
        $_SESSION['message'] = 'Payable marked as Paid.';
        $_SESSION['msg_type'] = 'success';
        header('Location: accountspayable.php?msg=paid');
        exit;
    }
    mysqli_stmt_close($update);
}

$_SESSION['message'] = 'Failed to mark payable as paid: ' . mysqli_error($con);
$_SESSION['msg_type'] = 'danger';
header('Location: accountspayable.php');
exit;
