@echo off
REM Maintenance Mode Toggle Script for Windows
REM Usage: maintenance.bat [on|off|status]

if "%1"=="" (
    echo Usage: maintenance.bat [on^|off^|status]
    echo.
    echo Commands:
    echo   on      - Enable maintenance mode
    echo   off     - Disable maintenance mode
    echo   status  - Check maintenance mode status
    exit /b 1
)

if "%1"=="on" (
    echo Enabling maintenance mode...
    echo We are currently performing scheduled maintenance. We'll be back shortly! > .maintenance
    if exist .maintenance (
        echo [SUCCESS] Maintenance mode is now ENABLED
        echo Users will see the maintenance page when accessing the system.
    ) else (
        echo [ERROR] Failed to enable maintenance mode
    )
    exit /b 0
)

if "%1"=="off" (
    echo Disabling maintenance mode...
    if exist .maintenance (
        del .maintenance
        echo [SUCCESS] Maintenance mode is now DISABLED
        echo The system is now accessible to all users.
    ) else (
        echo [INFO] Maintenance mode is already disabled
    )
    exit /b 0
)

if "%1"=="status" (
    if exist .maintenance (
        echo [STATUS] Maintenance mode is ENABLED
        echo Message:
        type .maintenance
    ) else (
        echo [STATUS] Maintenance mode is DISABLED
        echo The system is running normally.
    )
    exit /b 0
)

echo Invalid command: %1
echo Use: maintenance.bat [on^|off^|status]
exit /b 1

