<?php
/**
 * Enable Maintenance Mode
 * 
 * This script enables maintenance mode by creating a .maintenance file.
 * Only authorized administrators should have access to this script.
 * 
 * Usage: Simply visit this page in your browser or run via command line
 */

session_start();

// Security: Check if user is logged in as admin (optional - comment out if not needed)
// Uncomment the following lines to require admin authentication
/*
if (!isset($_SESSION['schoolsys']) || !isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    die('Unauthorized access. Admin privileges required.');
}
*/

// Get the project root directory
$root_dir = __DIR__;
$maintenance_file = $root_dir . '/.maintenance';

// Default maintenance message
$default_message = "We are currently performing scheduled maintenance. We'll be back shortly!";

// Check if a custom message was provided
$custom_message = isset($_POST['message']) ? trim($_POST['message']) : '';
$message = !empty($custom_message) ? $custom_message : $default_message;

// Create the maintenance file
if (file_put_contents($maintenance_file, $message)) {
    // Set bypass session for current admin user
    $_SESSION['maintenance_bypass'] = true;
    
    $success = true;
    $result_message = "✅ Maintenance mode has been ENABLED successfully!";
} else {
    $success = false;
    $result_message = "❌ Failed to enable maintenance mode. Check file permissions.";
}

// If accessed via browser, show a result page
if (php_sapi_name() !== 'cli') {
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Maintenance Mode Control</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 600px;
            width: 100%;
            padding: 40px;
        }
        h1 {
            color: #333;
            margin-bottom: 20px;
            font-size: 28px;
        }
        .result {
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
            font-size: 18px;
        }
        .success {
            background: #d1fae5;
            color: #065f46;
            border: 2px solid #10b981;
        }
        .error {
            background: #fee2e2;
            color: #991b1b;
            border: 2px solid #ef4444;
        }
        .form-group {
            margin: 20px 0;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #374151;
            font-weight: 600;
        }
        textarea {
            width: 100%;
            padding: 12px;
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            font-size: 14px;
            font-family: inherit;
            resize: vertical;
        }
        button {
            background: #667eea;
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s;
            margin-right: 10px;
        }
        button:hover {
            background: #5568d3;
        }
        .btn-secondary {
            background: #6b7280;
        }
        .btn-secondary:hover {
            background: #4b5563;
        }
        .btn-danger {
            background: #ef4444;
        }
        .btn-danger:hover {
            background: #dc2626;
        }
        .info {
            background: #f3f4f6;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            color: #4b5563;
            font-size: 14px;
        }
        .actions {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e5e7eb;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 Maintenance Mode Control</h1>
        
        <?php if (isset($result_message)): ?>
            <div class="result <?php echo $success ? 'success' : 'error'; ?>">
                <?php echo $result_message; ?>
            </div>
        <?php endif; ?>

        <?php if ($success): ?>
            <div class="info">
                <p><strong>Status:</strong> The system is now in maintenance mode.</p>
                <p><strong>Your access:</strong> You can still access the system as you have bypass privileges.</p>
                <p><strong>Message shown to users:</strong> "<?php echo htmlspecialchars($message); ?>"</p>
            </div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="form-group">
                <label for="message">Custom Maintenance Message:</label>
                <textarea name="message" id="message" rows="4" placeholder="Enter a custom message to display to users (optional)"><?php echo isset($custom_message) ? htmlspecialchars($custom_message) : ''; ?></textarea>
            </div>
            <button type="submit">🔒 Enable Maintenance Mode</button>
        </form>

        <div class="actions">
            <h3 style="margin-bottom: 15px; color: #374151;">Quick Actions:</h3>
            <a href="maintenance-off.php"><button type="button" class="btn-danger">✅ Disable Maintenance Mode</button></a>
            <a href="index.php"><button type="button" class="btn-secondary">🏠 Back to Home</button></a>
        </div>
    </div>
</body>
</html>
<?php
} else {
    // CLI output
    echo $result_message . "\n";
    if ($success) {
        echo "Message: $message\n";
    }
}
?>

