<?php
/**
 * Disable Maintenance Mode
 * 
 * This script disables maintenance mode by removing the .maintenance file.
 * Only authorized administrators should have access to this script.
 * 
 * Usage: Simply visit this page in your browser or run via command line
 */

session_start();

// Security: Check if user is logged in as admin (optional - comment out if not needed)
// Uncomment the following lines to require admin authentication
/*
if (!isset($_SESSION['schoolsys']) || !isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    die('Unauthorized access. Admin privileges required.');
}
*/

// Get the project root directory
$root_dir = __DIR__;
$maintenance_file = $root_dir . '/.maintenance';

// Check if maintenance mode is currently enabled
if (!file_exists($maintenance_file)) {
    $already_disabled = true;
    $result_message = "ℹ️ Maintenance mode is already disabled.";
} else {
    // Remove the maintenance file
    if (unlink($maintenance_file)) {
        // Remove bypass session
        unset($_SESSION['maintenance_bypass']);
        
        $success = true;
        $result_message = "✅ Maintenance mode has been DISABLED successfully!";
    } else {
        $success = false;
        $result_message = "❌ Failed to disable maintenance mode. Check file permissions.";
    }
}

// If accessed via browser, show a result page
if (php_sapi_name() !== 'cli') {
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Maintenance Mode Control</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 600px;
            width: 100%;
            padding: 40px;
            text-align: center;
        }
        h1 {
            color: #333;
            margin-bottom: 20px;
            font-size: 28px;
        }
        .result {
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
            font-size: 18px;
        }
        .success {
            background: #d1fae5;
            color: #065f46;
            border: 2px solid #10b981;
        }
        .error {
            background: #fee2e2;
            color: #991b1b;
            border: 2px solid #ef4444;
        }
        .info-result {
            background: #dbeafe;
            color: #1e40af;
            border: 2px solid #3b82f6;
        }
        button {
            background: #667eea;
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s;
            margin: 10px 5px;
        }
        button:hover {
            background: #5568d3;
        }
        .btn-success {
            background: #10b981;
        }
        .btn-success:hover {
            background: #059669;
        }
        .info {
            background: #f3f4f6;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            color: #4b5563;
            font-size: 14px;
            text-align: left;
        }
        .icon {
            font-size: 60px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="icon">✅</div>
        <h1>Maintenance Mode Control</h1>
        
        <?php if (isset($already_disabled)): ?>
            <div class="result info-result">
                <?php echo $result_message; ?>
            </div>
        <?php elseif (isset($success) && $success): ?>
            <div class="result success">
                <?php echo $result_message; ?>
            </div>
            <div class="info">
                <p><strong>Status:</strong> The system is now accessible to all users.</p>
                <p><strong>Note:</strong> Users will be able to access the system immediately.</p>
            </div>
        <?php else: ?>
            <div class="result error">
                <?php echo $result_message; ?>
            </div>
        <?php endif; ?>

        <div style="margin-top: 30px;">
            <a href="index.php"><button type="button" class="btn-success">🏠 Back to Home</button></a>
            <a href="maintenance-on.php"><button type="button">🔒 Enable Maintenance Mode</button></a>
        </div>
    </div>
</body>
</html>
<?php
} else {
    // CLI output
    echo $result_message . "\n";
}
?>

