<?php
// Print-friendly list of lunch fees payments for a term
include 'includes/conn.php';
// Start session is handled in conn.php

$termId = isset($_GET['term']) ? (int)$_GET['term'] : 0;
if ($termId <= 0) {
    echo 'Invalid term specified.';
    exit;
}

$terms = mysqli_query($con, "SELECT * FROM financialterms WHERE financialterm_id='" . $termId . "' LIMIT 1");
$termRow = $terms ? mysqli_fetch_assoc($terms) : null;
$termLabel = $termRow ? ('Term ' . ($termRow['term'] ?? '') . ' ' . ($termRow['year'] ?? '')) : 'Term';

$payments = mysqli_query($con, "SELECT * FROM lunchfeespayments WHERE status=1 AND term_id='" . $termId . "' ORDER BY timestamp DESC");

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Print - Lunch Fees Payments (<?php echo htmlspecialchars($termLabel); ?>)</title>
    <style>
        body{font-family: Arial, Helvetica, sans-serif;}
        table{width:100%;border-collapse:collapse}
        th,td{border:1px solid #ccc;padding:6px;text-align:left}
        .no-print{display:none}
        @media print{ .no-print{display:none} }
    </style>
</head>
<body>
    <h2>Lunch Fees Payments - <?php echo htmlspecialchars($termLabel); ?></h2>
    <?php if ($payments && mysqli_num_rows($payments) > 0): ?>
        <table>
            <thead>
                <tr>
                    <th>Full Name</th>
                    <th>Class</th>
                    <th>Payment Date</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = mysqli_fetch_assoc($payments)):
                    $student_id = (int)($row['student_id'] ?? 0);
                    $ts = (int)($row['timestamp'] ?? 0);
                    $sRes = mysqli_query($con, "SELECT fullname,class_id,stream_id FROM students WHERE status=1 AND student_id='" . $student_id . "' LIMIT 1");
                    $s = $sRes ? mysqli_fetch_assoc($sRes) : null;
                    $fullname = $s['fullname'] ?? '-';
                    $class = '-';
                    if ($s && !empty($s['class_id'])) {
                        $cRes = mysqli_query($con, "SELECT class,level FROM classes WHERE class_id='" . (int)$s['class_id'] . "' LIMIT 1");
                        $crow = $cRes ? mysqli_fetch_assoc($cRes) : null;
                        if ($crow) $class = trim(($crow['class'] ?? '') . '');
                    }
                ?>
                <tr>
                    <td><?php echo htmlspecialchars($fullname); ?></td>
                    <td><?php echo htmlspecialchars($class); ?></td>
                    <td><?php echo $ts ? date('d/M/Y', $ts) : '-'; ?></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>No lunch fee payments found for this term.</p>
    <?php endif; ?>

    <p class="no-print"><button onclick="window.print();">Print</button></p>
</body>
</html>
