<?php
include '../includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (($_SESSION['schoolsyslevel'] != 4)) {
    header('Location:../login.php');
    exit;
}

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
    echo '<div class="alert alert-danger">Invalid request.</div>';
    exit;
}
// fetch plan with prepared statement and fallback
$plan = null;
$pstmt = mysqli_prepare($con, "SELECT long_term_id, teacher_id, class_sub_id, term, file_path FROM longterm_plans WHERE long_term_id = ? AND status = 1 LIMIT 1");
if ($pstmt) {
    mysqli_stmt_bind_param($pstmt, 'i', $id);
    mysqli_stmt_execute($pstmt);
    $pres = mysqli_stmt_get_result($pstmt);
    if ($pres && mysqli_num_rows($pres) > 0) {
        $plan = mysqli_fetch_assoc($pres);
    }
    mysqli_stmt_close($pstmt);
}
if (!$plan) {
    $escaped_id = mysqli_real_escape_string($con, (string)$id);
    $sql = "SELECT long_term_id, teacher_id, class_sub_id, term, file_path FROM longterm_plans WHERE long_term_id = '$escaped_id' AND status = 1 LIMIT 1";
    $res = mysqli_query($con, $sql);
    if ($res && mysqli_num_rows($res) > 0) {
        $plan = mysqli_fetch_assoc($res);
    }
}
if (!$plan) {
    echo '<div class="alert alert-warning">Long-term plan not found.</div>';
    exit;
}

// normalize fields
$weeklyplan_id = isset($plan['long_term_id']) ? (int)$plan['long_term_id'] : 0;
$teacher_id = isset($plan['teacher_id']) ? (int)$plan['teacher_id'] : 0;
$class_sub_id = isset($plan['class_sub_id']) ? (int)$plan['class_sub_id'] : 0;
$term_value = isset($plan['term']) ? (int)$plan['term'] : 0;
$file_path = $plan['file_path'] ?? '';

// fetch class_subjects
$class_id = 0;
$subject_id = 0;
$cs = mysqli_prepare($con, "SELECT class_id, subject_id FROM class_subjects WHERE class_sub_id = ? LIMIT 1");
if ($cs) {
    mysqli_stmt_bind_param($cs, 'i', $class_sub_id);
    mysqli_stmt_execute($cs);
    $csr = mysqli_stmt_get_result($cs);
    if ($csr && mysqli_num_rows($csr) > 0) {
        $csrow = mysqli_fetch_assoc($csr);
        $class_id = isset($csrow['class_id']) ? (int)$csrow['class_id'] : 0;
        $subject_id = isset($csrow['subject_id']) ? (int)$csrow['subject_id'] : 0;
    }
    mysqli_stmt_close($cs);
}

// fetch class
$class = '';
$category_id = 0;
if ($class_id) {
    $cstmt = mysqli_prepare($con, "SELECT class, category_id FROM classes WHERE class_id = ? LIMIT 1");
    if ($cstmt) {
        mysqli_stmt_bind_param($cstmt, 'i', $class_id);
        mysqli_stmt_execute($cstmt);
        $cres = mysqli_stmt_get_result($cstmt);
        if ($cres && mysqli_num_rows($cres) > 0) {
            $crow = mysqli_fetch_assoc($cres);
            $class = $crow['class'] ?? '';
            $category_id = isset($crow['category_id']) ? (int)$crow['category_id'] : 0;
        }
        mysqli_stmt_close($cstmt);
    }
}

// fetch subject
$subject = '';
if ($subject_id) {
    $sstmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1");
    if ($sstmt) {
        mysqli_stmt_bind_param($sstmt, 'i', $subject_id);
        mysqli_stmt_execute($sstmt);
        $sres = mysqli_stmt_get_result($sstmt);
        if ($sres && mysqli_num_rows($sres) > 0) {
            $srow = mysqli_fetch_assoc($sres);
            $subject = $srow['subject'] ?? '';
        }
        mysqli_stmt_close($sstmt);
    }
}

// fetch financial term
$term = '';
$year = '';
if ($term_value) {
    $tstmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE status = 1 AND financialterm_id = ? LIMIT 1");
    if ($tstmt) {
        mysqli_stmt_bind_param($tstmt, 'i', $term_value);
        mysqli_stmt_execute($tstmt);
        $tres = mysqli_stmt_get_result($tstmt);
        if ($tres && mysqli_num_rows($tres) > 0) {
            $trow = mysqli_fetch_assoc($tres);
            $term = $trow['term'] ?? '';
            $year = $trow['year'] ?? '';
        }
        mysqli_stmt_close($tstmt);
    }
}
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Subject Longterm Lesson Plans School Manager</title>
    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
    <link href="css/chosen/chosen.css" rel="stylesheet">
</head>

<body class="sticky-header">

    <section>
    <?php include 'header.php'; ?>
        <!--body wrapper start-->
        <div class="wrapper">
            <div class="row">

                <div class="col-lg-6">
                    <!-- <a href="longtermplanprint?id=<?php echo $id; ?>" class="btn btn-danger" target="_blank" style="margin-bottom: 10px">Print Longterm Lesson Plan</a> -->
                    <?php
                    $weeklyplans = mysqli_query($con, "SELECT * FROM longterm_plans WHERE  long_term_id='$id'  AND status=1");
                    $row = mysqli_fetch_array($weeklyplans);
                    $weeklyplan_id = $row['long_term_id'];
                    $teacher_id = $row['teacher_id'];
                    $class_sub_id = $row['class_sub_id'];
                    $term_value = $row['term'];
                    $class_subjects = mysqli_query($con, "SELECT * FROM class_subjects WHERE  class_sub_id='$class_sub_id'");
                    $row1 = mysqli_fetch_array($class_subjects);
                    $class_id = $row1['class_id'];
                    $subject_id = $row1['subject_id'];
                    $getclasses =  mysqli_query($con, "SELECT * FROM classes WHERE class_id='$class_id'");
                    $row2 =  mysqli_fetch_array($getclasses);
                    $class = $row2['class'];
                    $category_id = $row2['category_id'];
                    $getsubjects =  mysqli_query($con, "SELECT * FROM subjects WHERE subject_id='$subject_id'");
                    $row3 =  mysqli_fetch_array($getsubjects);
                    $subject = $row3['subject'];
                    $terms =  mysqli_query($con, "SELECT  * FROM financialterms WHERE status=1 and financialterm_id ='$term_value'");
                    $row2 = mysqli_fetch_array($terms);
                    $term = $row2['term'];
                    $year = $row2['year'];

                    ?>
                    <section class="panel">
                        <header class="panel-heading">
                            <?php echo $subject . ':' . $class . ' Mid Term Plan'; ?>
                        </header>
                        <div class="panel-body">
                            <table class="display table  table-striped" id="dynamic-table">

                                <tbody>
                                    <tr class="gradeA">
                                        <th> Subject</th>
                                        <td><?php echo $subject;            ?></td>
                                    </tr>
                                    <tr class="gradeA">
                                        <th> Term</th>
                                        <td><?php echo $term;            ?></td>
                                    </tr>
                                    <tr class="gradeA">
                                        <th> Year</th>
                                        <td><?php echo $year;            ?></td>
                                    </tr>

                                </tbody>
                            </table>

                        </div>
                    </section>

                </div>
                <div class="col-lg-6">

                </div>

            </div>

            <!-- Long Term Plan Document Section -->
            <?php if (!empty($file_path)): 
                $file_exists = file_exists($file_path);
            ?>
            <div class="row">
                <div class="col-lg-10">
                    <section class="panel">
                        <header class="panel-heading">
                            Long Term Plan Document
                        </header>
                        <div class="panel-body">
                            <p><strong>File Path:</strong> <?php echo htmlspecialchars($file_path); ?></p>
                            <p><strong>Status:</strong> <?php echo $file_exists ? '<span style="color: green;">File exists</span>' : '<span style="color: red;">File not found on server</span>'; ?></p>
                            
                            <?php if ($file_exists): ?>
                                <div style="margin-top: 15px;">
                                    <a href="<?php echo htmlspecialchars($file_path); ?>" target="_blank" class="btn btn-primary">
                                        <i class="fa fa-external-link"></i> Open in New Tab
                                    </a>
                                    <a href="<?php echo htmlspecialchars($file_path); ?>" download class="btn btn-success">
                                        <i class="fa fa-download"></i> Download
                                    </a>
                                </div>
                                <div style="margin-top: 20px; width: 100%; height: 600px; border: 1px solid #ddd;">
                                    <iframe src="<?php echo htmlspecialchars($file_path); ?>" style="width: 100%; height: 100%; border: none;"></iframe>
                                </div>
                            <?php else: ?>
                                <div class="alert alert-warning" style="margin-top: 15px;">
                                    <i class="fa fa-exclamation-triangle"></i> The document file is registered in the database but cannot be found on the server. Please contact the administrator.
                                </div>
                            <?php endif; ?>
                        </div>
                    </section>
                </div>
            </div>
            <?php endif; ?>

            <div class="row">

                <div class="col-lg-10">
                    <!-- <h2>Weekly Plan</h2> -->
                    <section class="panel">
                        <header class="panel-heading">
                            Longterm Lesson Plan
                        </header>
                        <div class="panel-body">
                            <table class="display table  table-striped" id="dynamic-table">

                                <tbody>
                                    <?php
                                    $lessonplans =  mysqli_query($con, "SELECT * FROM  longterm_plans_details WHERE long_term_id='$id' AND status=1 ORDER BY plan_id asc") or die(mysqli_error($con));
                                    while ($row = mysqli_fetch_array($lessonplans)) {
                                        $month = $row['month'];
                                        $title = $row['title'];
                                        $summary = $row['summary'];

                                    ?>

                                        <tr class="gradeA">
                                            <th><?php echo getMonthName($month); ?></th>
                                            <td><?php echo $title; ?></td>
                                            <td><?php echo $summary; ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </section>
                </div>

            </div>

        </div>
        <!-- main content end-->
    </section>
    <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
    <!--common scripts for all pages-->
    <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
    <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>

</body>

</html>