function fnFormatDetails ( oTable, nTr )
{
    var aData = oTable.fnGetData( nTr );
    var sOut = '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">';
    sOut += '<tr><td>Rendering engine:</td><td>'+aData[1]+' '+aData[4]+'</td></tr>';
    sOut += '<tr><td>Link to source:</td><td>Could provide a link here</td></tr>';
    sOut += '<tr><td>Extra info:</td><td>And any further details here (images etc)</td></tr>';
    sOut += '</table>';

    return sOut;
}

$(document).ready(function() {

    // Only initialize if table exists
    if ($('#dynamic-table').length) {
        // Avoid calling DataTables twice on the same table
        if (!$.fn.dataTable.isDataTable('#dynamic-table')) {
            var cols = $('#dynamic-table thead th').length;
            var sortIndex = cols >= 5 ? 4 : 0;
            // Build an explicit columns array with defaultContent and data:null
            // so DataTables won't request missing parameters when row data is
            // provided as an object or has fewer columns than the header.
            var colsDef = [];
            for (var c = 0; c < cols; c++) {
                colsDef.push({ "data": null, "defaultContent": "" });
            }

            // Prefer logging errors to avoid alert popups that break UX
            if ($.fn.dataTable && $.fn.dataTable.ext) {
                $.fn.dataTable.ext.errMode = 'console';
            }

            $('#dynamic-table').dataTable( {
                "aaSorting": [[ sortIndex, "desc" ]],
                "columns": colsDef,
                // Keep a global fallback too
                "columnDefs": [ { "defaultContent": "", "targets": "_all" } ]
            } );
        }
    }

    // Diagnostic: check each row has same number of TDs as header THs
    // This helps identify server-side rendering mistakes that cause
    // DataTables to complain about unknown parameters.
    if ($('#dynamic-table').length) {
        try {
            var expectedCols = $('#dynamic-table thead th').length;
            $('#dynamic-table tbody tr').each(function(idx) {
                var tdCount = $(this).children('td').length;
                if (tdCount !== expectedCols) {
                    console.error('Row cells mismatch in #dynamic-table at row', idx, 'expected', expectedCols, 'but found', tdCount, 'rowHTML:', $(this).prop('outerHTML'));
                }
            });
        } catch (e) {
            console.warn('Diagnostic check failed for #dynamic-table:', e);
        }
    }

    /*
     * Insert a 'details' column to the table
     */
    var nCloneTh = document.createElement( 'th' );
    var nCloneTd = document.createElement( 'td' );
    nCloneTd.innerHTML = '<img src="images/details_open.png">';
    nCloneTd.className = "center";

    if ($('#hidden-table-info').length) {
        $('#hidden-table-info thead tr').each( function () {
            this.insertBefore( nCloneTh, this.childNodes[0] );
        } );

        $('#hidden-table-info tbody tr').each( function () {
            this.insertBefore(  nCloneTd.cloneNode( true ), this.childNodes[0] );
        } );
    }

    /*
     * Initialse DataTables, with no sorting on the 'details' column
     */
    var oTable = null;
    if ($('#hidden-table-info').length) {
        oTable = $('#hidden-table-info').dataTable( {
            "aoColumnDefs": [
                { "bSortable": false, "aTargets": [ 0 ] }
            ],
            "aaSorting": [[1, 'asc']]
        });
    }

    /* Add event listener for opening and closing details
     * Note that the indicator for showing which row is open is not controlled by DataTables,
     * rather it is done here
     */
    if (oTable) {
        $(document).on('click','#hidden-table-info tbody td img',function () {
            var nTr = $(this).parents('tr')[0];
            if ( oTable.fnIsOpen(nTr) )
            {
                /* This row is already open - close it */
                this.src = "images/details_open.png";
                oTable.fnClose( nTr );
            }
            else
            {
                /* Open this row */
                this.src = "images/details_close.png";
                oTable.fnOpen( nTr, fnFormatDetails(oTable, nTr), 'details' );
            }
        } );
    }
} );