<?php
include 'includes/conn.php';
if (!isset($_SESSION)) {
    session_start();
}
$timenow = isset($timenow) ? $timenow : time();

// Helper to fetch system configuration values (falls back to null)
function getConfigValue($con, $key) {
    $key = mysqli_real_escape_string($con, $key);
    $res = mysqli_query($con, "SELECT config_value FROM system_configuration WHERE config_key='" . $key . "' LIMIT 1");
    if ($res && mysqli_num_rows($res) > 0) {
        $r = mysqli_fetch_assoc($res);
        return $r['config_value'];
    }
    return null;
}
$allowed = array(1,2,3,8,10);
if (!isset($_SESSION['schoolsyslevel']) || !in_array((int)$_SESSION['schoolsyslevel'], $allowed)) {
    header('Location: login.php');
    exit;
}

$std = isset($_GET['std']) ? (int)$_GET['std'] : 0;
$term = isset($_GET['term']) ? htmlspecialchars($_GET['term'], ENT_QUOTES) : '';
$year = isset($_GET['year']) ? htmlspecialchars($_GET['year'], ENT_QUOTES) : '';
$class = isset($_GET['class']) ? (int)$_GET['class'] : 0;
$timenow = isset($timenow) ? $timenow : time();
?>
<!DOCTYPE html>
<html>

<head>
    <style type="text/css" media="print">
        @page {
            size: auto;
            /* auto is the initial value */
            margin: 0;
            /* this affects the margin in the printer settings */
        }
        /* Reduce logo size specifically for print */
        .invoice-logo-img {
            max-width: 80px !important;
            height: auto !important;
        }
    </style>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Fees Invoice</title>
    <link href="assets/stylesheets/bootstrap.min.css" rel="stylesheet">
    <link href="assets/stylesheets/animate.css" rel="stylesheet">
    <link href="assets/stylesheets/style.css" rel="stylesheet">


    <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="white-bg">
    <div class="wrapper wrapper-content p-xl">
        <div class="ibox-content p-xl">
            <div class="row">
                <div class="col-sm-2"><img src="images/schoollogo.JPG" class="img img-responsive invoice-logo-img"></div>
                <?php
                // Load school contact info from system configuration if available
                $school_addr = getConfigValue($con, 'school_address') ?: '6 Avenue Rukonwe, Kabondo,';
                $school_city = getConfigValue($con, 'school_city') ?: 'Bujumbura,Burundi';
                $school_po = getConfigValue($con, 'school_po_box') ?: 'P.O. Box 6356';
                $school_phone = getConfigValue($con, 'school_phone') ?: '';
                $school_website = getConfigValue($con, 'school_website') ?: '';
                ?>
                <div class="col-sm-4">
                    <address>
                        <?php echo htmlspecialchars($school_addr); ?><br>
                        <?php echo htmlspecialchars($school_city); ?><br>
                        <?php echo htmlspecialchars($school_po); ?>
                        <?php if ($school_phone): ?><br>Phone: <?php echo htmlspecialchars($school_phone); ?><?php endif; ?>
                        <?php if ($school_website): ?><br><?php echo htmlspecialchars($school_website); ?><?php endif; ?>
                    </address>
                </div>

                <div class="col-sm-6 text-right">
                    <h4>Invoice No.</h4>
                    <h4 class="text-navy"><?php echo $timenow; ?></h4>
                    <address>

                        <span><strong>Print Date:</strong> <?php echo date('M d,Y', $timenow); ?></span><br />
                    </address>

                </div>

            </div>

            <div class="table-responsive m-t">
                <?php
                $students =  mysqli_query($con, "SELECT * FROM students WHERE status=1 AND student_id='" . (int)$std . "'");
                $row = $students ? mysqli_fetch_array($students) : null;
                if (!$row) {
                    echo '<div class="alert alert-danger">Student not found</div>';
                    exit;
                }
                $regnumber = $row['regnumber'] ?? '';
                $fullname = $row['fullname'] ?? '';

                $getclass =  mysqli_query($con, "SELECT * FROM classes WHERE class_id='" . (int)$class . "'");
                $row2 = $getclass ? mysqli_fetch_array($getclass) : null;
                $classname = $row2['class'] ?? '';
                ?>
                <h2 class="text-center" style=" font-weight: bold; text-transform: uppercase;">Fees Invoice</h2>
                <div class="row" style="margin-bottom:20px">
                    <div class="col-sm-6"><strong>Term : </strong><span><?php echo $term; ?></span></div>
                    <div class="col-sm-6"><strong>Year : </strong><span><?php echo $year; ?></span></div>
                    <div class="col-sm-6"><strong>Name : </strong><span><?php echo $fullname; ?></span></div>
                    <div class="col-sm-6"><strong>Class : </strong><span><?php echo $classname; ?></span></div>
                </div>

                <table class="table table-striped table-bordered table-hover dataTables-example">
                    <thead>
                        <tr>
                            <th>Fees</th>

                            <th>Amount</th>

                        </tr>
                    </thead>
                    <tbody>
                        <tr class="gradeA">
                            <td>Lunch Fees</td>
                            <td><?php
                                $lunchfees =  mysqli_query($con, "SELECT  * FROM lunchfees WHERE class_id='" . (int)$class . "' AND status=1");
                                $roww = $lunchfees ? mysqli_fetch_array($lunchfees) : null;
                                $amount = isset($roww['amount']) ? (float)$roww['amount'] : 0.0;
                                echo number_format($amount); ?></td>
                        </tr>
                        <tr class="gradeA">
                            <td>School Fees</td>
                            <td><?php
                                // Determine a safe ORDER BY column for schoolfees (some schemas may not have `year`)
                                $year_col = null;
                                $cols = mysqli_query($con, "SHOW COLUMNS FROM schoolfees");
                                if ($cols) {
                                    while ($c = mysqli_fetch_array($cols)) {
                                        $cname = $c['Field'] ?? '';
                                        if ($cname === 'year') {
                                            $year_col = 'year';
                                            break;
                                        }
                                        if ($cname === 'term_id' && !$year_col) {
                                            $year_col = 'term_id';
                                        }
                                    }
                                }
                                $order_by = $year_col ? $year_col . " DESC" : "schoolfees_id DESC";
                                $schoolfees =  mysqli_query($con, "SELECT  * FROM schoolfees WHERE status=1 AND class_id='" . (int)$class . "' ORDER BY " . $order_by);
                                $row1 = $schoolfees ? mysqli_fetch_array($schoolfees) : null;
                                $feesamount = isset($row1['amount']) ? (float)$row1['amount'] : 0.0;
                                echo number_format($feesamount); ?></td>
                        </tr>
                    </tbody>
                </table>

            </div><!-- /table-responsive -->



            <div class="well m-t">
                <strong style="font-style: italic">School System</strong>
            </div>
        </div>

    </div>

    <!-- Mainly scripts -->
    <script src="js/jquery-1.10.2.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>

    <script type="text/javascript">
        window.print();
    </script>

</body>

</html>