<?php
include 'includes/conn.php';
include 'includes/roles.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);

if (!canViewFinancialReports($user_level)) {
    header('Location:login.php');
    exit();
}

$start_date = $_GET['start_date'] ?? date('Y-m-01');
$end_date = $_GET['end_date'] ?? date('Y-m-d');

$start_safe = mysqli_real_escape_string($con, $start_date);
$end_safe = mysqli_real_escape_string($con, $end_date);

// Helper to try multiple queries until one succeeds
function try_queries($con, $queries) {
    foreach ($queries as $q) {
        $r = @mysqli_query($con, $q);
        if ($r) {
            $row = mysqli_fetch_assoc($r);
            return $row['total'] ?? 0;
        }
    }
    return 0;
}

// Income: fee collections — try accounts_receivable.amount_paid, feespayments.amount, feespayment.amount
$income_qs = [
    "SELECT COALESCE(SUM(amount_paid),0) as total FROM accounts_receivable WHERE status IN ('Paid','Partial') AND DATE(updated_at) >= '$start_safe' AND DATE(updated_at) <= '$end_safe'",
    "SELECT COALESCE(SUM(amount),0) as total FROM feespayments WHERE status=1 AND DATE(created_at) >= '$start_safe' AND DATE(created_at) <= '$end_safe'",
    "SELECT COALESCE(SUM(amount),0) as total FROM feespayment WHERE status=1 AND DATE(created_at) >= '$start_safe' AND DATE(created_at) <= '$end_safe'"
];
$income_total = (float) try_queries($con, $income_qs);

// Expenses: try expenses.amount (date stored as unix timestamp) and expense tables
$expenses_qs = [
    "SELECT COALESCE(SUM(amount),0) as total FROM expenses WHERE status=1 AND FROM_UNIXTIME(`date`) >= '$start_safe' AND FROM_UNIXTIME(`date`) <= '$end_safe'",
    "SELECT COALESCE(SUM(amount),0) as total FROM expense_transactions WHERE status=1 AND DATE(transaction_date) >= '$start_safe' AND DATE(transaction_date) <= '$end_safe'",
    "SELECT COALESCE(SUM(amount),0) as total FROM expense WHERE status=1 AND DATE(created_at) >= '$start_safe' AND DATE(created_at) <= '$end_safe'"
];
$expenses_total = (float) try_queries($con, $expenses_qs);

// Gross profit = income - expenses (for now no COGS)
$net_profit = $income_total - $expenses_total;

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Income Statement</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-10 col-lg-offset-1">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-line-chart"></i> Income Statement: <?php echo htmlspecialchars($start_date); ?> — <?php echo htmlspecialchars($end_date); ?></h4>
                    </header>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Total Income</h5>
                                <div class="well">
                                    <h3 class="text-success"><?php echo number_format($income_total,2); ?></h3>
                                    <p>Includes fee collections and receipts</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h5>Total Expenses</h5>
                                <div class="well">
                                    <h3 class="text-danger"><?php echo number_format($expenses_total,2); ?></h3>
                                    <p>Operational & other expenses</p>
                                </div>
                            </div>
                        </div>

                        <div class="row margin-top-20">
                            <div class="col-md-12">
                                <h4>Net Profit</h4>
                                <div class="well">
                                    <h2><?php echo number_format($net_profit,2); ?> <?php echo $net_profit >= 0 ? '<span class="label label-success">Profit</span>' : '<span class="label label-danger">Loss</span>'; ?></h2>
                                </div>
                            </div>
                        </div>

                        <p>
                            <a href="financialreports.php?start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>" class="btn btn-default">Back to Reports</a>
                        </p>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
