<?php
function create_thumb($directory, $image, $destination) {
  $image_file = $image;
  $image = $directory.$image;
  if (file_exists($image)) {
    $source_size = getimagesize($image);

    if ($source_size !== false) {

      $thumb_width = 250;
      $thumb_height = 250;

   // create source image with safe fallbacks
   $source = false;
   $data = @file_get_contents($image);
   switch($source_size['mime']) {
     case 'image/jpeg':
       if (function_exists('imagecreatefromjpeg')) {
        $source = @imagecreatefromjpeg($image);
       }
     break;
     case 'image/png':
       if (function_exists('imagecreatefrompng')) {
        $source = @imagecreatefrompng($image);
       }
     break;
     case 'image/gif':
       if (function_exists('imagecreatefromgif')) {
        $source = @imagecreatefromgif($image);
       }
     break;
   }
   if (!$source && function_exists('imagecreatefromstring') && $data !== false) {
    $source = @imagecreatefromstring($data);
   }
   if (!$source) {
    // cannot create source image; bail out gracefully
    return false;
   }

      $source_aspect = round(($source_size[0] / $source_size[1]), 1);
      $thumb_aspect = round(($thumb_width / $thumb_height), 1);

      if ($source_aspect < $thumb_aspect) {
        $new_size = array($thumb_width, ($thumb_width / $source_size[0]) * $source_size[1]);
        $source_pos = array(0, ($new_size[1] - $thumb_height) / 2);
      } else if ($source_aspect > $thumb_aspect) {
        $new_size = array(($thumb_width / $source_size[1]) * $source_size[0], $thumb_height);
        $source_pos = array(($new_size[0] - $thumb_width) / 2, 0);
      } else {
        $new_size = array($thumb_width, $thumb_height);
        $source_pos = array(0, 0);
      }

      if ($new_size[0] < 1) $new_size[0] = 1;
      if ($new_size[1] < 1) $new_size[1] = 1;

    $thumb = imagecreatetruecolor($thumb_width, $thumb_height);
    // preserve transparency for PNG and GIF
    if (in_array($source_size['mime'], ['image/png','image/gif'])) {
      imagecolortransparent($thumb, imagecolorallocatealpha($thumb, 0, 0, 0, 127));
      imagealphablending($thumb, false);
      imagesavealpha($thumb, true);
    }
    imagecopyresampled($thumb, $source, 0, 0, $source_pos[0], $source_pos[1], $new_size[0], $new_size[1], $source_size[0], $source_size[1]);

   $ok = false;
   switch($source_size['mime']) {
     case 'image/jpeg':
       if (function_exists('imagejpeg')) $ok = imagejpeg($thumb, $destination.$image_file);
     break;
     case 'image/png':
       if (function_exists('imagepng')) $ok = imagepng($thumb, $destination.$image_file);
     break;
     case 'image/gif':
       if (function_exists('imagegif')) $ok = imagegif($thumb, $destination.$image_file);
     break;
   }

   // free resources
   @imagedestroy($thumb);
   @imagedestroy($source);

   return (bool) $ok;

    }

  }
  return false;
}
?>