<?php
/**
 * Centralized Role Management Functions
 * This file contains functions to handle user roles consistently across the system
 */

/**
 * Get role name by level
 * @param int $level The role level
 * @return string The role name
 */
function getRoleName($level) {
    $roles = [
        1 => 'Super Admin',
        2 => 'Principal', 
        3 => 'Accounts Management',
        4 => 'Head of Section',
        5 => 'Librarian',
        6 => 'Secretary',
        7 => 'Head Teacher',
        8 => 'Finance Manager',
        9 => 'HR Admin Director',
        10 => 'Accountant'
    ];
    
    return $roles[$level] ?? 'User';
}

/**
 * Get all available roles for dropdowns
 * @return array Array of roles [level => name]
 */
function getAllRoles() {
    return [
        1 => 'Super Admin',
        2 => 'Principal',
        3 => 'Accounts Management', 
        4 => 'Head of Section',
        5 => 'Librarian',
        6 => 'Secretary',
        7 => 'Head Teacher',
        8 => 'Finance Manager',
        9 => 'HR Admin Director',
        10 => 'Accountant'
    ];
}

/**
 * Generate role option elements for select dropdowns
 * @param int $selected_level The currently selected role level
 * @param array $exclude_levels Array of role levels to exclude
 * @return string HTML option elements
 */
function generateRoleOptions($selected_level = 0, $exclude_levels = []) {
    $roles = getAllRoles();
    $options = '';
    
    foreach ($roles as $level => $name) {
        if (in_array($level, $exclude_levels)) continue;
        
        $selected = ($level == $selected_level) ? 'selected' : '';
        $options .= "<option value=\"{$level}\" {$selected}>" . htmlspecialchars($name) . "</option>\n";
    }
    
    return $options;
}

/**
 * Check if a role level is valid
 * @param int $level The role level to check
 * @return bool True if valid, false otherwise
 */
function isValidRole($level) {
    $roles = getAllRoles();
    return isset($roles[$level]);
}
?>